/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.JoinCondition;
import org.modeshape.jcr.query.model.JoinType;
import org.modeshape.jcr.query.process.JoinComponent;
import org.modeshape.jcr.query.process.ProcessingComponent;

public class NestedLoopJoinComponent
extends JoinComponent {
    public NestedLoopJoinComponent(QueryContext context, ProcessingComponent left, ProcessingComponent right, JoinCondition condition, JoinType joinType) {
        super(context, left, right, condition, joinType);
    }

    @Override
    public List<Object[]> execute() {
        JoinComponent.ValueSelector leftSelector = NestedLoopJoinComponent.valueSelectorFor(this.left(), this.getJoinCondition());
        JoinComponent.ValueSelector rightSelector = NestedLoopJoinComponent.valueSelectorFor(this.right(), this.getJoinCondition());
        JoinComponent.Joinable joinable = NestedLoopJoinComponent.joinableFor(this.left(), this.right(), this.getJoinCondition());
        JoinType joinType = this.getJoinType();
        JoinComponent.TupleMerger merger = NestedLoopJoinComponent.createMerger(this.getColumns(), this.left().getColumns(), this.right().getColumns());
        List<Object[]> leftTuples = this.left().execute();
        List<Object[]> rightTuples = this.right().execute();
        ArrayList<Object[]> tuples = null;
        switch (joinType) {
            case INNER: {
                int maxSize = Math.min(leftTuples.size(), rightTuples.size());
                tuples = new ArrayList(maxSize);
                for (Object[] leftTuple : leftTuples) {
                    Object leftValue = leftSelector.evaluate(leftTuple);
                    if (leftValue == null) continue;
                    for (Object[] rightTuple : rightTuples) {
                        Object rightValue = rightSelector.evaluate(rightTuple);
                        if (rightValue == null || !joinable.evaluate(leftValue, rightValue)) continue;
                        Object[] result = merger.merge(leftTuple, rightTuple);
                        tuples.add(result);
                    }
                }
                break;
            }
            case LEFT_OUTER: {
                int maxSize = leftTuples.size();
                tuples = new ArrayList<Object[]>(maxSize);
                for (Object[] leftTuple : leftTuples) {
                    Object leftValue = leftSelector.evaluate(leftTuple);
                    boolean foundMatch = false;
                    if (leftValue != null) {
                        for (Object[] rightTuple : rightTuples) {
                            Object rightValue = rightSelector.evaluate(rightTuple);
                            if (rightValue == null || !joinable.evaluate(leftValue, rightValue)) continue;
                            Object[] result = merger.merge(leftTuple, rightTuple);
                            tuples.add(result);
                            foundMatch = true;
                        }
                    }
                    if (foundMatch) continue;
                    tuples.add(merger.merge(leftTuple, null));
                }
                break;
            }
            case RIGHT_OUTER: {
                int maxSize = rightTuples.size();
                tuples = new ArrayList(maxSize);
                for (Object[] rightTuple : rightTuples) {
                    Object rightValue = rightSelector.evaluate(rightTuple);
                    boolean foundMatch = false;
                    if (rightValue != null) {
                        for (Object[] leftTuple : leftTuples) {
                            Object leftValue = leftSelector.evaluate(leftTuple);
                            if (leftValue == null || !joinable.evaluate(leftValue, rightValue)) continue;
                            Object[] result = merger.merge(leftTuple, rightTuple);
                            tuples.add(result);
                            foundMatch = true;
                        }
                    }
                    if (foundMatch) continue;
                    tuples.add(merger.merge(null, rightTuple));
                }
                break;
            }
            case FULL_OUTER: {
                int maxSize = leftTuples.size() + rightTuples.size();
                tuples = new ArrayList(maxSize);
                for (Object[] leftTuple : leftTuples) {
                    Object leftValue = leftSelector.evaluate(leftTuple);
                    boolean foundMatch = false;
                    for (Object[] rightTuple : rightTuples) {
                        Object rightValue = rightSelector.evaluate(rightTuple);
                        if (rightValue == null) continue;
                        if (joinable.evaluate(leftValue, rightValue)) {
                            Object[] result = merger.merge(leftTuple, rightTuple);
                            tuples.add(result);
                            foundMatch = true;
                            continue;
                        }
                        tuples.add(merger.merge(null, rightTuple));
                    }
                    if (foundMatch) continue;
                    tuples.add(merger.merge(leftTuple, null));
                }
                break;
            }
            case CROSS: {
                int maxSize = leftTuples.size() * rightTuples.size();
                tuples = new ArrayList(maxSize);
                for (Object[] leftTuple : leftTuples) {
                    for (Object[] rightTuple : rightTuples) {
                        Object[] result = merger.merge(leftTuple, rightTuple);
                        tuples.add(result);
                    }
                }
                break;
            }
        }
        assert (tuples != null);
        return tuples;
    }
}

