/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.txn.Transactions;

public final class NoClientTransactions
extends Transactions {
    protected static final ThreadLocal<NoClientTransaction> ACTIVE_TRANSACTION = new ThreadLocal();

    public NoClientTransactions(SessionEnvironment.MonitorFactory monitorFactory, TransactionManager txnMgr) {
        super(monitorFactory, txnMgr);
    }

    @Override
    public synchronized Transactions.Transaction begin() throws NotSupportedException, SystemException {
        if (ACTIVE_TRANSACTION.get() == null) {
            this.txnMgr.begin();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Begin transaction {0}", new Object[]{this.currentTransactionId()});
            }
            ACTIVE_TRANSACTION.set(new NoClientTransaction(this.txnMgr));
        }
        return ACTIVE_TRANSACTION.get().transactionBegin();
    }

    protected class NoClientTransaction
    extends Transactions.TraceableSimpleTransaction {
        private final AtomicInteger nestedLevel;

        public NoClientTransaction(TransactionManager txnMgr) {
            super(NoClientTransactions.this, txnMgr);
            this.nestedLevel = new AtomicInteger(0);
        }

        @Override
        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            if (this.nestedLevel.getAndDecrement() == 1) {
                ACTIVE_TRANSACTION.remove();
                super.commit();
            } else {
                NoClientTransactions.this.logger.trace("Not committing transaction because it's nested within another transaction. Only the top level transaction should commit", new Object[0]);
            }
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            ACTIVE_TRANSACTION.remove();
            super.rollback();
        }

        protected NoClientTransaction transactionBegin() {
            this.nestedLevel.incrementAndGet();
            return this;
        }
    }
}

