/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.io.Serializable;
import org.modeshape.common.annotation.Immutable;

@Immutable
public final class DynamicField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final Object value;
    private final boolean analyzed;
    private final boolean stored;
    private final DynamicField next;

    public DynamicField(DynamicField next, String fieldName, Object value, boolean analyzed, boolean stored) {
        this.next = next;
        this.fieldName = fieldName;
        this.value = value;
        this.analyzed = analyzed;
        this.stored = stored;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public boolean isStored() {
        return this.stored;
    }

    public DynamicField getNext() {
        return this.next;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.toString(sb);
        sb.append('}');
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
        sb.append(this.fieldName);
        sb.append('=').append(this.value);
        if (this.next != null) {
            sb.append(',');
            this.next.toString(sb);
        }
    }
}

