/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.jcr.value.Path;

@Immutable
public final class WorkspaceAndPath {
    private final String workspaceName;
    private final Path path;

    public WorkspaceAndPath(String workspaceName, Path path) {
        this.workspaceName = workspaceName;
        this.path = path;
        assert (this.workspaceName != null);
        assert (this.path != null);
    }

    public Path getPath() {
        return this.path;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.workspaceName, this.path});
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkspaceAndPath) {
            WorkspaceAndPath that = (WorkspaceAndPath)obj;
            return this.workspaceName.equals(that.workspaceName) && this.path.equals(that.path);
        }
        return false;
    }

    public String toString() {
        return this.workspaceName + ":/" + this.path;
    }

    public WorkspaceAndPath withPath(Path path) {
        return path == this.path ? this : new WorkspaceAndPath(this.workspaceName, path);
    }
}

