/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.NodeTypeSchemata;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.query.QueryCancelledException;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.CancellableQuery;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryEngine;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.engine.IndexQueryEngine;
import org.modeshape.jcr.query.engine.ScanningQueryEngine;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.spi.query.QueryIndexWriter;
import org.modeshape.jcr.value.Path;

class RepositoryQueryManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final JcrRepository.RunningState runningState;
    private final ExecutorService indexingExecutorService;
    private final RepositoryConfiguration repoConfig;
    private final Lock engineInitLock = new ReentrantLock();
    private volatile QueryEngine queryEngine;
    private volatile Future<Void> asyncReindexingResult;

    protected RepositoryQueryManager(JcrRepository.RunningState runningState) {
        this.runningState = runningState;
        this.indexingExecutorService = null;
        this.repoConfig = null;
    }

    RepositoryQueryManager(JcrRepository.RunningState runningState, ExecutorService indexingExecutorService, RepositoryConfiguration config) {
        this.runningState = runningState;
        this.indexingExecutorService = indexingExecutorService;
        this.repoConfig = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        block7: {
            this.indexingExecutorService.shutdown();
            if (this.queryEngine != null) {
                try {
                    this.engineInitLock.lock();
                    if (this.queryEngine == null) break block7;
                    try {
                        this.queryEngine.shutdown();
                    }
                    finally {
                        this.queryEngine = null;
                    }
                }
                finally {
                    this.engineInitLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopReindexing() {
        try {
            this.engineInitLock.lock();
            if (this.asyncReindexingResult != null) {
                try {
                    this.asyncReindexingResult.get(1L, TimeUnit.MINUTES);
                }
                catch (TimeoutException e) {
                    this.logger.debug("Re-indexing has not finished in time, attempting to cancel operation", new Object[0]);
                    this.asyncReindexingResult.cancel(true);
                }
                catch (Exception e) {
                    this.logger.debug((Throwable)e, "Unexpected exception while waiting for re-indexing to terminate", new Object[0]);
                }
            }
        }
        finally {
            this.asyncReindexingResult = null;
            this.engineInitLock.unlock();
        }
    }

    public CancellableQuery query(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Map<String, NodeCache> overriddenNodeCachesByWorkspaceName, org.modeshape.jcr.api.query.qom.QueryCommand query, Schemata schemata, NodeTypes nodeTypes, PlanHints hints, Map<String, Object> variables) {
        final QueryEngine queryEngine = this.queryEngine();
        final QueryContext queryContext = queryEngine.createQueryContext(context, repositoryCache, workspaceNames, overriddenNodeCachesByWorkspaceName, schemata, nodeTypes, new BufferManager(context), hints, variables);
        final QueryCommand command = (QueryCommand)query;
        return new CancellableQuery(){
            private final Lock lock = new ReentrantLock();
            private QueryResults results;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public QueryResults execute() throws QueryCancelledException, RepositoryException {
                try {
                    this.lock.lock();
                    if (this.results == null) {
                        this.results = queryEngine.execute(queryContext, command);
                    }
                    QueryResults queryResults = this.results;
                    return queryResults;
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public boolean cancel() {
                return queryContext.cancel();
            }
        };
    }

    public QueryIndexWriter getIndexes() {
        return this.queryEngine().getQueryIndexWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final QueryEngine queryEngine() {
        if (this.queryEngine == null) {
            try {
                this.engineInitLock.lock();
                if (this.queryEngine == null) {
                    ScanningQueryEngine.Builder builder = null;
                    if (!this.repoConfig.getIndexes().getProviders().isEmpty()) {
                        builder = IndexQueryEngine.builder();
                        this.logger.debug("Queries with indexes are enabled for the '{0}' repository. Executing queries may require scanning the repository contents when the query cannot use the defined indexes.", new Object[]{this.repoConfig.getName()});
                    } else {
                        builder = ScanningQueryEngine.builder();
                        this.logger.debug("Queries with no indexes are enabled for the '{0}' repository. Executing queries will always scan the repository contents.", new Object[]{this.repoConfig.getName()});
                    }
                    this.queryEngine = builder.using(this.repoConfig, this.runningState.context()).build();
                }
            }
            finally {
                this.engineInitLock.unlock();
            }
        }
        return this.queryEngine;
    }

    protected void reindexContent(final boolean includeSystemContent, boolean async, boolean onlyIfEmpty) {
        if (onlyIfEmpty && !this.indexesEmpty()) {
            return;
        }
        if (async) {
            this.asyncReindexingResult = this.indexingExecutorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    RepositoryQueryManager.this.reindexContent(includeSystemContent);
                    return null;
                }
            });
        } else {
            this.reindexContent(includeSystemContent);
        }
    }

    protected boolean indexesEmpty() {
        QueryIndexWriter indexes = this.getIndexes();
        return indexes.initializedIndexes() && !indexes.canBeSkipped();
    }

    private void reindexContent(boolean includeSystemContent) {
        if (this.getIndexes().canBeSkipped()) {
            return;
        }
        NodeTypeSchemata schemata = this.runningState.nodeTypeManager().getRepositorySchemata();
        RepositoryCache repoCache = this.runningState.repositoryCache();
        this.logger.debug(JcrI18n.reindexAll.text(new Object[]{this.runningState.name()}), new Object[0]);
        if (includeSystemContent) {
            WorkspaceCache systemWorkspaceCache = repoCache.getWorkspaceCache(repoCache.getSystemWorkspaceName());
            CachedNode rootNode = systemWorkspaceCache.getNode(repoCache.getSystemKey());
            this.logger.debug("Starting reindex of system content in '{0}' repository.", new Object[]{this.runningState.name()});
            this.reindexSystemContent(rootNode, Integer.MAX_VALUE, schemata);
            this.logger.debug("Completed reindex of system content in '{0}' repository.", new Object[]{this.runningState.name()});
        }
        for (String workspaceName : repoCache.getWorkspaceNames()) {
            WorkspaceCache workspaceCache = repoCache.getWorkspaceCache(workspaceName);
            CachedNode rootNode = workspaceCache.getNode(workspaceCache.getRootKey());
            this.logger.debug("Starting reindex of workspace '{0}' content in '{1}' repository.", new Object[]{this.runningState.name(), workspaceName});
            this.reindexContent(workspaceName, schemata, workspaceCache, rootNode, Integer.MAX_VALUE, false);
            this.logger.debug("Completed reindex of workspace '{0}' content in '{1}' repository.", new Object[]{this.runningState.name(), workspaceName});
        }
    }

    public void reindexContent(JcrWorkspace workspace) {
        this.reindexContent(workspace, Path.ROOT_PATH, Integer.MAX_VALUE);
    }

    public void reindexContent(JcrWorkspace workspace, Path path, int depth) {
        if (this.getIndexes().canBeSkipped()) {
            return;
        }
        CheckArg.isPositive((int)depth, (String)"depth");
        JcrSession session = workspace.getSession();
        NodeCache cache = session.cache().getWorkspace();
        String workspaceName = workspace.getName();
        CachedNode node = cache.getNode(cache.getRootKey());
        for (Path.Segment segment : path) {
            ChildReference ref = node.getChildReferences(cache).getChild(segment);
            if (ref == null) {
                return;
            }
            node = cache.getNode(ref);
        }
        NodeTypeSchemata schemata = this.runningState.nodeTypeManager().getRepositorySchemata();
        String systemWorkspaceKey = this.runningState.repositoryCache().getSystemWorkspaceKey();
        if (node.getKey().getWorkspaceKey().equals(systemWorkspaceKey)) {
            this.reindexSystemContent(node, depth, schemata);
        } else {
            this.reindexContent(workspaceName, schemata, cache, node, depth, path.isRoot());
        }
    }

    protected void reindexContent(String workspaceName, NodeTypeSchemata schemata, NodeCache cache, CachedNode node, int depth, boolean reindexSystemContent) {
        NodeKey key;
        QueryIndexWriter indexes = this.getIndexes();
        if (indexes.canBeSkipped()) {
            return;
        }
        if (!node.isQueryable(cache)) {
            return;
        }
        PathCache paths = new PathCache(cache);
        Path nodePath = paths.getPath(node);
        QueryIndexWriter.IndexingContext indxCtx = indexes.createIndexingContext(null);
        indexes.updateIndex(workspaceName, node.getKey(), nodePath, node.getPrimaryType(cache), node.getMixinTypes(cache), node.getProperties(cache), schemata, indxCtx);
        if (depth == 1) {
            return;
        }
        LinkedList<NodeKey> queue = new LinkedList<NodeKey>();
        if (reindexSystemContent) {
            ChildReferences childRefs = node.getChildReferences(cache);
            ChildReference systemRef = childRefs.getChild(JcrLexicon.SYSTEM);
            NodeKey systemKey = systemRef != null ? systemRef.getKey() : null;
            for (ChildReference childRef : node.getChildReferences(cache)) {
                NodeKey childKey = childRef.getKey();
                if (childKey.equals(systemKey)) {
                    node = cache.getNode(childKey);
                    this.reindexSystemContent(node, depth - 1, schemata);
                    continue;
                }
                queue.add(childKey);
            }
        } else {
            for (ChildReference childRef : node.getChildReferences(cache)) {
                NodeKey childKey = childRef.getKey();
                if (childKey.getWorkspaceKey().equals(this.runningState.systemWorkspaceKey())) continue;
                queue.add(childKey);
            }
        }
        while ((key = (NodeKey)queue.poll()) != null) {
            node = cache.getNode(key);
            if (node == null || !node.isQueryable(cache)) continue;
            nodePath = paths.getPath(node);
            indexes.updateIndex(workspaceName, node.getKey(), nodePath, node.getPrimaryType(cache), node.getMixinTypes(cache), node.getProperties(cache), schemata, indxCtx);
            if (nodePath.size() > depth) continue;
            for (ChildReference childRef : node.getChildReferences(cache)) {
                queue.add(childRef.getKey());
            }
        }
    }

    protected void reindexSystemContent(CachedNode nodeInSystemBranch, int depth, NodeTypeSchemata schemata) {
        RepositoryCache repoCache = this.runningState.repositoryCache();
        String workspaceName = repoCache.getSystemWorkspaceName();
        WorkspaceCache systemWorkspaceCache = repoCache.getWorkspaceCache(workspaceName);
        this.reindexContent(workspaceName, schemata, systemWorkspaceCache, nodeInSystemBranch, depth, true);
    }

    protected void reindexSystemContent(boolean async) {
        RepositoryCache repositoryCache = this.runningState.repositoryCache();
        final WorkspaceCache systemWorkspaceCache = repositoryCache.getWorkspaceCache(repositoryCache.getSystemWorkspaceName());
        final CachedNode systemRoot = systemWorkspaceCache.getNode(repositoryCache.getSystemKey());
        if (async) {
            this.indexingExecutorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    RepositoryQueryManager.this.reindexSystemContent(systemRoot, systemWorkspaceCache);
                    return null;
                }
            });
        } else {
            this.reindexSystemContent(systemRoot, systemWorkspaceCache);
        }
    }

    protected final void reindexSystemContent(CachedNode systemRoot, NodeCache systemWorkspaceCache) {
        NodeTypeSchemata schemata = this.runningState.nodeTypeManager().getRepositorySchemata();
        this.reindexSystemContent(systemRoot, 1, schemata);
        for (ChildReference childReference : systemRoot.getChildReferences(systemWorkspaceCache)) {
            CachedNode systemNode = systemWorkspaceCache.getNode(childReference.getKey());
            this.reindexSystemContent(systemNode, Integer.MAX_VALUE, schemata);
        }
    }

    public Future<Boolean> reindexContentAsync(final JcrWorkspace workspace) {
        return this.indexingExecutorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RepositoryQueryManager.this.reindexContent(workspace);
                return Boolean.TRUE;
            }
        });
    }

    public Future<Boolean> reindexContentAsync(final JcrWorkspace workspace, final Path path, final int depth) {
        return this.indexingExecutorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RepositoryQueryManager.this.reindexContent(workspace, path, depth);
                return Boolean.TRUE;
            }
        });
    }
}

