/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.journal;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;

public final class JournalRecord
implements Serializable,
Iterable<Change> {
    private static final long serialVersionUID = 1L;
    private long timeBasedKey;
    private final ChangeSet content;

    protected JournalRecord(ChangeSet content) {
        this.content = content;
        this.timeBasedKey = -1L;
    }

    protected JournalRecord withTimeBasedKey(long timeBasedKey) {
        this.timeBasedKey = timeBasedKey;
        return this;
    }

    public long getTimeBasedKey() {
        return this.timeBasedKey;
    }

    public String getProcessKey() {
        return this.content.getProcessKey();
    }

    public String getRepositoryKey() {
        return this.content.getRepositoryKey();
    }

    public String getUserId() {
        return this.content.getUserId();
    }

    public String getWorkspaceName() {
        return this.content.getWorkspaceName();
    }

    public long getChangeTimeMillis() {
        return this.content.getTimestamp().getMillisecondsInUtc();
    }

    public Set<NodeKey> changedNodes() {
        return this.content.changedNodes();
    }

    public String getJournalId() {
        return this.content.getJournalId();
    }

    @Override
    public Iterator<Change> iterator() {
        return this.content.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JournalRecord record = (JournalRecord)o;
        return this.content.getUUID().equals(record.content.getUUID());
    }

    public int hashCode() {
        return this.content.getUUID().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JournalRecord {");
        sb.append("timeBasedKey=").append(new Date(this.timeBasedKey).toString());
        sb.append(", journalId=").append(this.getJournalId());
        sb.append(", processKey=").append(this.getProcessKey());
        sb.append(", userId=").append(this.getUserId());
        sb.append(", repositoryKey=").append(this.getRepositoryKey());
        sb.append(", workspaceName=").append(this.getWorkspaceName());
        sb.append(", content=").append(this.content.toString());
        sb.append('}');
        return sb.toString();
    }
}

