/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.transaction.Transaction;
import org.modeshape.jcr.NodeTypeSchemata;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.spi.query.QueryIndexProvider;
import org.modeshape.jcr.spi.query.QueryIndexWriter;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

public class CompositeIndexWriter
implements QueryIndexWriter {
    private final List<QueryIndexWriter> writers = new ArrayList<QueryIndexWriter>();

    public CompositeIndexWriter(Iterable<QueryIndexProvider> providers) {
        for (QueryIndexProvider provider : providers) {
            QueryIndexWriter writer;
            if (provider == null || (writer = provider.getQueryIndexWriter()) == null || writer.canBeSkipped()) continue;
            this.writers.add(writer);
        }
    }

    @Override
    public QueryIndexWriter.IndexingContext createIndexingContext(Transaction txn) {
        return new Context(txn);
    }

    @Override
    public boolean initializedIndexes() {
        for (QueryIndexWriter writer : this.writers) {
            if (writer.initializedIndexes()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeSkipped() {
        return this.writers.isEmpty();
    }

    @Override
    public void addToIndex(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> propertiesIterator, NodeTypeSchemata schemata, QueryIndexWriter.IndexingContext txnCtx) {
        for (QueryIndexWriter writer : this.writers) {
            writer.addToIndex(workspace, key, path, primaryType, mixinTypes, propertiesIterator, schemata, txnCtx);
        }
    }

    @Override
    public void updateIndex(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> properties, NodeTypeSchemata schemata, QueryIndexWriter.IndexingContext txnCtx) {
        for (QueryIndexWriter writer : this.writers) {
            writer.updateIndex(workspace, key, path, primaryType, mixinTypes, properties, schemata, txnCtx);
        }
    }

    @Override
    public void removeFromIndex(String workspace, Iterable<NodeKey> keys, QueryIndexWriter.IndexingContext txnCtx) {
        for (QueryIndexWriter writer : this.writers) {
            writer.removeFromIndex(workspace, keys, txnCtx);
        }
    }

    @Override
    public void addBinaryToIndex(Binary binary, QueryIndexWriter.IndexingContext txnCtx) {
        for (QueryIndexWriter writer : this.writers) {
            writer.addBinaryToIndex(binary, txnCtx);
        }
    }

    @Override
    public void removeBinariesFromIndex(Iterable<String> sha1s, QueryIndexWriter.IndexingContext txnCtx) {
        for (QueryIndexWriter writer : this.writers) {
            writer.removeBinariesFromIndex(sha1s, txnCtx);
        }
    }

    protected static final class Context
    implements QueryIndexWriter.IndexingContext {
        private final Transaction txn;

        protected Context(Transaction txn) {
            this.txn = txn;
        }

        @Override
        public Transaction getTransaction() {
            return this.txn;
        }
    }
}

