/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.query;

import java.util.List;
import javax.jcr.query.qom.Constraint;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.spi.query.IndexCollector;

public abstract class QueryIndexPlanner {
    public abstract void applyIndexes(QueryContext var1, SelectorName var2, List<Constraint> var3, IndexCollector var4);

    public static QueryIndexPlanner both(final QueryIndexPlanner planner1, final QueryIndexPlanner planner2) {
        if (planner1 == null) {
            return planner2;
        }
        if (planner2 == null) {
            return planner1;
        }
        return new QueryIndexPlanner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void applyIndexes(QueryContext context, SelectorName selector, List<Constraint> andedConstraints, IndexCollector indexes) {
                RuntimeException error = null;
                try {
                    planner1.applyIndexes(context, selector, andedConstraints, indexes);
                    return;
                }
                catch (RuntimeException e) {
                    error = e;
                }
                finally {
                    try {
                        planner2.applyIndexes(context, selector, andedConstraints, indexes);
                    }
                    catch (RuntimeException e) {
                        if (error == null) {
                            error = e;
                        }
                    }
                    finally {
                        if (error == null) return;
                        throw error;
                    }
                }
            }
        };
    }
}

