/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventJournal;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.observation.Event;
import org.modeshape.jcr.api.observation.PropertyEvent;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.AbstractNodeChange;
import org.modeshape.jcr.cache.change.AbstractSequencingChange;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeMoved;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.NodeRenamed;
import org.modeshape.jcr.cache.change.NodeReordered;
import org.modeshape.jcr.cache.change.NodeSequenced;
import org.modeshape.jcr.cache.change.NodeSequencingFailure;
import org.modeshape.jcr.cache.change.Observable;
import org.modeshape.jcr.cache.change.PropertyAdded;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.cache.change.PropertyRemoved;
import org.modeshape.jcr.journal.ChangeJournal;
import org.modeshape.jcr.journal.JournalRecord;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;

@ThreadSafe
final class JcrObservationManager
implements ObservationManager,
ChangeSetListener {
    protected static final Logger LOGGER = Logger.getLogger(JcrObservationManager.class);
    static final String OBSERVATION_USER_DATA_KEY = "org.modeshape.jcr.observation.userdata";
    static final String MOVE_FROM_KEY = "srcAbsPath";
    static final String MOVE_TO_KEY = "destAbsPath";
    static final String ORDER_DEST_KEY = "destChildRelPath";
    static final String ORDER_SRC_KEY = "srcChildRelPath";
    private final Observable repositoryObservable;
    private final Map<EventListener, JcrListenerAdapter> listeners;
    protected final JcrSession session;
    private final RepositoryStatistics repositoryStatistics;
    private final Map<Integer, AtomicInteger> changesReceivedAndDispatched;
    private final Lock changesLock;
    private final ReadWriteLock listenersLock;

    JcrObservationManager(JcrSession session, Observable repositoryObservable, RepositoryStatistics statistics) {
        CheckArg.isNotNull((Object)session, (String)"session");
        CheckArg.isNotNull((Object)repositoryObservable, (String)"repositoryObservable");
        CheckArg.isNotNull((Object)statistics, (String)"statistics");
        this.session = session;
        this.repositoryObservable = repositoryObservable;
        this.repositoryObservable.register(this);
        this.listenersLock = new ReentrantReadWriteLock(true);
        this.listeners = new HashMap<EventListener, JcrListenerAdapter>();
        this.repositoryStatistics = statistics;
        this.changesLock = new ReentrantLock();
        this.changesReceivedAndDispatched = new HashMap<Integer, AtomicInteger>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        CheckArg.isNotNull((Object)listener, (String)"listener");
        this.checkSession();
        JcrListenerAdapter adapter = new JcrListenerAdapter(listener, eventTypes, absPath, isDeep, uuid, nodeTypeName, noLocal);
        try {
            this.listenersLock.writeLock().lock();
            this.repositoryObservable.unregister(adapter);
            this.repositoryObservable.register(adapter);
            this.listeners.put(listener, adapter);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    void checkSession() throws RepositoryException {
        this.session.checkLive();
    }

    @Override
    public void notify(ChangeSet changeSet) {
        this.incrementEventQueueStatistic(changeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementEventQueueStatistic(ChangeSet changeSet) {
        this.repositoryStatistics.increment(ValueMetric.EVENT_QUEUE_SIZE);
        try {
            this.changesLock.lock();
            if (!this.changesReceivedAndDispatched.containsKey(changeSet.hashCode())) {
                this.changesReceivedAndDispatched.put(changeSet.hashCode(), new AtomicInteger(this.listeners.size()));
            }
        }
        finally {
            this.changesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementEventQueueStatistic(ChangeSet changeSet) {
        try {
            this.changesLock.lock();
            if (this.changesReceivedAndDispatched.containsKey(changeSet.hashCode())) {
                int timesProcessed = this.changesReceivedAndDispatched.get(changeSet.hashCode()).decrementAndGet();
                if (timesProcessed == 0) {
                    this.repositoryStatistics.decrement(ValueMetric.EVENT_QUEUE_SIZE);
                    this.changesReceivedAndDispatched.remove(changeSet.hashCode());
                }
            } else {
                this.changesReceivedAndDispatched.put(changeSet.hashCode(), new AtomicInteger(this.listeners.size() - 1));
            }
        }
        finally {
            this.changesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
        this.checkSession();
        try {
            this.listenersLock.readLock().lock();
            JcrEventListenerIterator jcrEventListenerIterator = new JcrEventListenerIterator((Collection<EventListener>)Collections.unmodifiableSet(this.listeners.keySet()));
            return jcrEventListenerIterator;
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllEventListeners() {
        try {
            this.listenersLock.writeLock().lock();
            for (JcrListenerAdapter listener : this.listeners.values()) {
                assert (listener != null);
                this.repositoryObservable.unregister(listener);
            }
            this.listeners.clear();
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(EventListener listener) throws RepositoryException {
        this.checkSession();
        CheckArg.isNotNull((Object)listener, (String)"listener");
        try {
            this.listenersLock.writeLock().lock();
            JcrListenerAdapter jcrListener = this.listeners.remove(listener);
            if (jcrListener != null) {
                this.repositoryObservable.unregister(jcrListener);
            }
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    public void setUserData(String userData) {
        this.session.addContextData(OBSERVATION_USER_DATA_KEY, userData);
    }

    public EventJournal getEventJournal() {
        return this.session.repository().journalId() != null ? new JcrEventJournal() : null;
    }

    public EventJournal getEventJournal(int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName) {
        return this.session.repository().journalId() != null ? new JcrEventJournal(absPath, eventTypes, isDeep, nodeTypeName, uuid) : null;
    }

    protected class JcrEventJournal
    implements EventJournal {
        private final ChangeSetConverter changeSetConverter;
        private long position = -1L;
        private Iterator<javax.jcr.observation.Event> eventsIterator = null;
        private Iterator<JournalRecord> recordsIterator = null;
        private org.joda.time.DateTime laterThanDate = null;

        protected JcrEventJournal() {
            this.changeSetConverter = new ChangeSetConverter();
        }

        protected JcrEventJournal(String absPath, int eventTypes, boolean isDeep, String[] nodeTypeNames, String[] uuids) {
            this.changeSetConverter = new ChangeSetConverter(absPath, eventTypes, isDeep, nodeTypeNames, false, uuids);
        }

        public void skipTo(long date) {
            this.laterThanDate = new org.joda.time.DateTime(date);
            this.position = -1L;
            this.eventsIterator = null;
        }

        public javax.jcr.observation.Event nextEvent() {
            if (!this.advance()) {
                throw new NoSuchElementException();
            }
            ++this.position;
            return this.eventsIterator.next();
        }

        public void skip(long skipNum) {
            if (skipNum < 0L) {
                throw new IllegalArgumentException("Illegal argument to skip: " + skipNum);
            }
            int i = 0;
            while ((long)i < skipNum) {
                this.nextEvent();
                ++i;
            }
        }

        public long getSize() {
            return -1L;
        }

        public long getPosition() {
            return this.position;
        }

        public boolean hasNext() {
            return this.advance();
        }

        public Object next() {
            return this.nextEvent();
        }

        public void remove() {
            throw new UnsupportedOperationException("Cannot remove events via the event journal iterator");
        }

        private boolean advance() {
            if (this.eventsIterator != null && this.eventsIterator.hasNext()) {
                return true;
            }
            if (this.position == -1L) {
                ChangeJournal journal = JcrObservationManager.this.session.repository().journal();
                Iterator<Object> iterator = this.recordsIterator = this.laterThanDate != null ? journal.recordsNewerThan(new org.joda.time.DateTime((Object)this.laterThanDate), true, false).iterator() : journal.allRecords(false).iterator();
            }
            while (this.recordsIterator.hasNext()) {
                JournalRecord record = this.recordsIterator.next();
                this.eventsIterator = this.changeSetConverter.convert(record.getChangeSet()).iterator();
                if (!this.eventsIterator.hasNext()) continue;
                return true;
            }
            return false;
        }
    }

    protected final class ChangeSetConverter {
        private final String absPath;
        private final int eventTypes;
        private final boolean isDeep;
        private final String[] nodeTypeNames;
        private final boolean noLocal;
        private final Set<String> uuids;

        protected ChangeSetConverter(String absPath, int eventTypes, boolean isDeep, String[] nodeTypeNames, boolean noLocal, String[] uuids) {
            this.absPath = absPath;
            this.eventTypes = eventTypes;
            this.isDeep = isDeep;
            this.nodeTypeNames = nodeTypeNames;
            this.noLocal = noLocal;
            this.uuids = uuids == null ? null : (uuids.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(uuids)));
        }

        protected ChangeSetConverter() {
            this(null, 447, true, null, false, null);
        }

        protected List<javax.jcr.observation.Event> convert(ChangeSet changeSet) {
            ArrayList<javax.jcr.observation.Event> events = new ArrayList<javax.jcr.observation.Event>();
            if (this.shouldRejectChangeSet(changeSet)) {
                return events;
            }
            String userData = changeSet.getUserData().get(JcrObservationManager.OBSERVATION_USER_DATA_KEY);
            JcrEventBundle bundle = new JcrEventBundle(changeSet.getTimestamp(), changeSet.getUserId(), userData);
            for (Change change : changeSet) {
                this.processChange(events, bundle, change);
            }
            return events;
        }

        private boolean shouldRejectChangeSet(ChangeSet changeSet) {
            return !this.acceptBasedOnOriginatingSession(changeSet) || !this.acceptBasedOnOriginatingWorkspace(changeSet);
        }

        private void processChange(List<javax.jcr.observation.Event> events, JcrEventBundle bundle, Change change) {
            if (!(change instanceof AbstractNodeChange)) {
                return;
            }
            AbstractNodeChange nodeChange = (AbstractNodeChange)change;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing change: " + nodeChange, new Object[0]);
            }
            if (this.shouldRejectChange(nodeChange)) {
                return;
            }
            Path newPath = nodeChange.getPath();
            String nodeId = this.nodeIdentifier(nodeChange.getKey());
            NodeType primaryType = this.nodeType(nodeChange.getPrimaryType());
            Set<NodeType> mixinTypes = this.nodeTypes(nodeChange.getMixinTypes());
            if (nodeChange instanceof NodeMoved) {
                NodeMoved nodeMovedChange = (NodeMoved)nodeChange;
                Path oldPath = nodeMovedChange.getOldPath();
                this.fireNodeMoved(events, bundle, newPath, nodeId, oldPath, primaryType, mixinTypes);
            } else if (nodeChange instanceof NodeRenamed) {
                NodeRenamed nodeRenamedChange = (NodeRenamed)nodeChange;
                Path oldPath = this.pathFactory().create(newPath.subpath(0, newPath.size() - 1), nodeRenamedChange.getOldSegment());
                this.fireNodeMoved(events, bundle, newPath, nodeId, oldPath, primaryType, mixinTypes);
            } else if (nodeChange instanceof NodeReordered) {
                NodeReordered nodeReordered = (NodeReordered)nodeChange;
                Path oldPath = nodeReordered.getOldPath();
                if (this.eventListenedFor(32)) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    if (nodeReordered.getReorderedBeforePath() != null) {
                        info.put(JcrObservationManager.ORDER_DEST_KEY, this.stringFor(nodeReordered.getReorderedBeforePath().getLastSegment()));
                    } else {
                        info.put(JcrObservationManager.ORDER_DEST_KEY, null);
                    }
                    if (oldPath != null) {
                        info.put(JcrObservationManager.ORDER_SRC_KEY, this.stringFor(oldPath.getLastSegment()));
                    }
                    events.add((javax.jcr.observation.Event)new JcrEvent(bundle, 32, this.stringFor(newPath), nodeId, Collections.unmodifiableMap(info), primaryType, mixinTypes));
                }
                this.fireExtraEventsForMove(events, bundle, newPath, nodeId, oldPath, primaryType, mixinTypes);
            } else if (nodeChange instanceof NodeAdded && this.eventListenedFor(1)) {
                events.add((javax.jcr.observation.Event)new JcrEvent(bundle, 1, this.stringFor(newPath), nodeId, primaryType, mixinTypes));
            } else if (nodeChange instanceof NodeRemoved && this.eventListenedFor(2)) {
                events.add((javax.jcr.observation.Event)new JcrEvent(bundle, 2, this.stringFor(newPath), nodeId, primaryType, mixinTypes));
            } else if (nodeChange instanceof PropertyChanged && this.eventListenedFor(16)) {
                PropertyChanged propertyChanged = (PropertyChanged)nodeChange;
                Name propertyName = propertyChanged.getNewProperty().getName();
                Path propertyPath = this.pathFactory().create(newPath, this.stringFor(propertyName));
                boolean isMultiValue = propertyChanged.getNewProperty().isMultiple();
                Object currentValue = isMultiValue ? propertyChanged.getNewProperty().getValuesAsArray() : propertyChanged.getNewProperty().getFirstValue();
                Object oldValue = null;
                if (propertyChanged.getOldProperty() != null) {
                    boolean wasMultiValue = propertyChanged.getOldProperty().isMultiple();
                    oldValue = wasMultiValue ? propertyChanged.getOldProperty().getValuesAsArray() : propertyChanged.getOldProperty().getFirstValue();
                }
                events.add((javax.jcr.observation.Event)new JcrPropertyEvent(bundle, 16, this.stringFor(propertyPath), nodeId, currentValue, oldValue, primaryType, mixinTypes));
            } else if (nodeChange instanceof PropertyAdded && this.eventListenedFor(4)) {
                PropertyAdded propertyAdded = (PropertyAdded)nodeChange;
                Name propertyName = propertyAdded.getProperty().getName();
                Path propertyPath = this.pathFactory().create(newPath, this.stringFor(propertyName));
                boolean isMultiValue = propertyAdded.getProperty().isMultiple();
                Object currentValue = isMultiValue ? propertyAdded.getProperty().getValuesAsArray() : propertyAdded.getProperty().getFirstValue();
                events.add((javax.jcr.observation.Event)new JcrPropertyEvent(bundle, 4, this.stringFor(propertyPath), nodeId, currentValue, primaryType, mixinTypes));
            } else if (nodeChange instanceof PropertyRemoved && this.eventListenedFor(8)) {
                PropertyRemoved propertyRemoved = (PropertyRemoved)nodeChange;
                Name propertyName = propertyRemoved.getProperty().getName();
                Path propertyPath = this.pathFactory().create(newPath, propertyName);
                boolean isMultiValue = propertyRemoved.getProperty().isMultiple();
                Object currentValue = isMultiValue ? propertyRemoved.getProperty().getValuesAsArray() : propertyRemoved.getProperty().getFirstValue();
                events.add((javax.jcr.observation.Event)new JcrPropertyEvent(bundle, 8, this.stringFor(propertyPath), nodeId, currentValue, primaryType, mixinTypes));
            } else if (nodeChange instanceof NodeSequenced && this.eventListenedFor(128)) {
                NodeSequenced sequencedChange = (NodeSequenced)nodeChange;
                Map<String, Object> infoMap = this.createEventInfoMapForSequencerChange(sequencedChange);
                events.add((javax.jcr.observation.Event)new JcrEvent(bundle, 128, this.stringFor(sequencedChange.getOutputNodePath()), this.nodeIdentifier(sequencedChange.getOutputNodeKey()), infoMap, primaryType, mixinTypes));
            } else if (nodeChange instanceof NodeSequencingFailure && this.eventListenedFor(256)) {
                NodeSequencingFailure sequencingFailure = (NodeSequencingFailure)nodeChange;
                Map<String, Object> infoMap = this.createEventInfoMapForSequencerChange(sequencingFailure);
                infoMap.put("sequencingFailureCause", sequencingFailure.getCause());
                events.add((javax.jcr.observation.Event)new JcrEvent(bundle, 256, this.stringFor(sequencingFailure.getPath()), nodeId, infoMap, primaryType, mixinTypes));
            }
        }

        private Map<String, Object> createEventInfoMapForSequencerChange(AbstractSequencingChange sequencingChange) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("sequencedNodePath", this.stringFor(sequencingChange.getPath()));
            infoMap.put("sequencedNodeId", this.nodeIdentifier(sequencingChange.getKey()));
            infoMap.put("outputPath", sequencingChange.getOutputPath());
            infoMap.put("selectedPath", sequencingChange.getSelectedPath());
            infoMap.put("sequencerName", sequencingChange.getSequencerName());
            infoMap.put("userId", sequencingChange.getUserId());
            return infoMap;
        }

        private void fireNodeMoved(List<javax.jcr.observation.Event> events, JcrEventBundle bundle, Path newPath, String nodeId, Path oldPath, NodeType nodePrimaryType, Set<NodeType> nodeMixinTypes) {
            if (this.eventListenedFor(32)) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put(JcrObservationManager.MOVE_FROM_KEY, this.stringFor(oldPath));
                info.put(JcrObservationManager.MOVE_TO_KEY, this.stringFor(newPath));
                events.add((javax.jcr.observation.Event)new JcrEvent(bundle, 32, this.stringFor(newPath), nodeId, Collections.unmodifiableMap(info), nodePrimaryType, nodeMixinTypes));
            }
            this.fireExtraEventsForMove(events, bundle, newPath, nodeId, oldPath, nodePrimaryType, nodeMixinTypes);
        }

        private void fireExtraEventsForMove(List<javax.jcr.observation.Event> events, JcrEventBundle bundle, Path newPath, String nodeId, Path oldPath, NodeType nodePrimaryType, Set<NodeType> nodeMixinTypes) {
            if (this.eventListenedFor(1)) {
                events.add((javax.jcr.observation.Event)new JcrEvent(bundle, 1, this.stringFor(newPath), nodeId, nodePrimaryType, nodeMixinTypes));
            }
            if (this.eventListenedFor(2)) {
                events.add((javax.jcr.observation.Event)new JcrEvent(bundle, 2, this.stringFor(oldPath), nodeId, nodePrimaryType, nodeMixinTypes));
            }
        }

        private boolean shouldRejectChange(AbstractNodeChange nodeChange) {
            return !this.acceptBasedOnUuid(nodeChange) || !this.acceptBasedOnPath(nodeChange) || !this.acceptBasedOnPermission(nodeChange) || !this.acceptIfLockChange(nodeChange) || !this.acceptBasedOnNodeTypeName(nodeChange);
        }

        private boolean acceptIfLockChange(AbstractNodeChange nodeChange) {
            if (!(nodeChange instanceof PropertyAdded || nodeChange instanceof PropertyRemoved || nodeChange instanceof PropertyChanged)) {
                return true;
            }
            Path path = nodeChange.getPath();
            if (path.size() < 2) {
                return true;
            }
            Name firstSegmentName = path.subpath(0, 1).getLastSegment().getName();
            boolean isSystemLockChange = JcrLexicon.SYSTEM.equals(firstSegmentName) && ModeShapeLexicon.LOCKS.equals(path.getParent().getLastSegment().getName());
            return !isSystemLockChange;
        }

        private boolean eventListenedFor(int eventType) {
            return (this.eventTypes & eventType) == eventType;
        }

        private boolean acceptBasedOnPermission(AbstractNodeChange nodeChange) {
            try {
                JcrObservationManager.this.session.checkPermission(this.parentNodePathOfChange(nodeChange), "read");
                return true;
            }
            catch (AccessDeniedException e) {
                return false;
            }
        }

        private boolean acceptBasedOnOriginatingWorkspace(ChangeSet changeSet) {
            boolean sameWorkspace = this.getWorkspaceName().equalsIgnoreCase(changeSet.getWorkspaceName());
            boolean isSystemWorkspace = this.getSystemWorkspaceName().equalsIgnoreCase(changeSet.getWorkspaceName());
            return sameWorkspace || isSystemWorkspace;
        }

        private boolean acceptBasedOnOriginatingSession(ChangeSet changeSet) {
            return !this.noLocal || !this.getSessionId().equals(changeSet.getProcessKey());
        }

        private boolean acceptBasedOnNodeTypeName(AbstractNodeChange change) {
            if (this.nodeTypeNames != null && this.nodeTypeNames.length == 0) {
                return false;
            }
            String[] mixinStrings = null;
            if (this.shouldCheckNodeType()) {
                String primaryTypeName = null;
                try {
                    Path parentPath = this.parentNodePathOfChange(change);
                    AbstractJcrNode parentNode = JcrObservationManager.this.session.node(parentPath);
                    Set<Name> parentMixinNames = parentNode.getMixinTypeNames();
                    mixinStrings = new String[parentMixinNames.size()];
                    int i = 0;
                    for (Name mixinName : parentMixinNames) {
                        mixinStrings[i++] = this.stringFor(mixinName);
                    }
                    primaryTypeName = this.stringFor(parentNode.getPrimaryTypeName());
                    return this.getNodeTypeManager().isDerivedFrom(this.nodeTypeNames, primaryTypeName, mixinStrings);
                }
                catch (RepositoryException e) {
                    LOGGER.error((Throwable)e, (I18nResource)JcrI18n.cannotPerformNodeTypeCheck, new Object[]{primaryTypeName, Arrays.toString(mixinStrings), this.nodeTypeNames});
                    return false;
                }
            }
            return true;
        }

        private boolean acceptBasedOnPath(AbstractNodeChange change) {
            if (!StringUtil.isBlank((String)this.absPath)) {
                Path matchPath = (Path)JcrObservationManager.this.session.pathFactory().create(this.absPath);
                Path parentPath = this.parentNodePathOfChange(change);
                return this.isDeep ? matchPath.isAtOrAbove(parentPath) : matchPath.equals(parentPath);
            }
            return true;
        }

        private boolean acceptBasedOnUuid(AbstractNodeChange change) {
            return this.uuids == null || !this.uuids.isEmpty() && this.uuids.contains(this.nodeIdentifier(change.getKey()));
        }

        private Path parentNodePathOfChange(AbstractNodeChange change) {
            Path changePath = change.getPath();
            if (change instanceof PropertyAdded || change instanceof PropertyRemoved || change instanceof PropertyChanged) {
                return changePath;
            }
            return changePath.isRoot() ? changePath : changePath.getParent();
        }

        private boolean shouldCheckNodeType() {
            return this.nodeTypeNames != null && this.nodeTypeNames.length > 0;
        }

        private String stringFor(Path path) {
            return JcrObservationManager.this.session.stringFactory().create(path);
        }

        private String stringFor(Path.Segment segment) {
            return JcrObservationManager.this.session.stringFactory().create(segment);
        }

        private String stringFor(Name name) {
            return JcrObservationManager.this.session.stringFactory().create(name);
        }

        private PathFactory pathFactory() {
            return JcrObservationManager.this.session.pathFactory();
        }

        private String getSessionId() {
            return JcrObservationManager.this.session.context().getProcessId();
        }

        private String getWorkspaceName() {
            return JcrObservationManager.this.session.getWorkspace().getName();
        }

        private String getSystemWorkspaceName() {
            return JcrObservationManager.this.session.repository().systemWorkspaceName();
        }

        private String nodeIdentifier(NodeKey key) {
            return JcrObservationManager.this.session.nodeIdentifier(key);
        }

        private NodeType nodeType(Name name) {
            return JcrObservationManager.this.session.repository().nodeTypeManager().getNodeTypes().getNodeType(name);
        }

        private Set<NodeType> nodeTypes(Set<Name> names) {
            NodeTypes nodeTypes = JcrObservationManager.this.session.repository().nodeTypeManager().getNodeTypes();
            HashSet<NodeType> result = new HashSet<NodeType>(names.size());
            for (Name name : names) {
                result.add(nodeTypes.getNodeType(name));
            }
            return result;
        }

        private JcrNodeTypeManager getNodeTypeManager() throws RepositoryException {
            return JcrObservationManager.this.session.getWorkspace().getNodeTypeManager();
        }
    }

    protected static class JcrPropertyEvent
    extends JcrEvent
    implements PropertyEvent {
        private final Object currentValue;
        private final Object oldValue;

        JcrPropertyEvent(JcrEventBundle bundle, int type, String path, String id, Object currentValue, Object oldValue, NodeType nodePrimaryType, Set<NodeType> nodeMixinTypes) {
            super(bundle, type, path, id, nodePrimaryType, nodeMixinTypes);
            this.currentValue = currentValue;
            this.oldValue = oldValue;
        }

        JcrPropertyEvent(JcrEventBundle bundle, int type, String path, String id, Object currentValue, NodeType nodePrimaryType, Set<NodeType> nodeMixinTypes) {
            this(bundle, type, path, id, currentValue, null, nodePrimaryType, nodeMixinTypes);
        }

        public Object getCurrentValue() {
            return this.firstValueFrom(this.currentValue);
        }

        public boolean isMultiValue() {
            return this.currentValue instanceof Object[];
        }

        public List<?> getCurrentValues() {
            return this.listValueFrom(this.currentValue);
        }

        public boolean wasMultiValue() {
            return this.oldValue instanceof Object[];
        }

        public Object getPreviousValue() {
            return this.firstValueFrom(this.oldValue);
        }

        public List<?> getPreviousValues() {
            return this.listValueFrom(this.oldValue);
        }

        private List<?> listValueFrom(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Object[]) {
                return ((Object[])value).length > 0 ? Arrays.asList((Object[])value) : Collections.emptyList();
            }
            return Arrays.asList(value);
        }

        private Object firstValueFrom(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Object[]) {
                return ((Object[])value).length > 0 ? ((Object[])value)[0] : null;
            }
            return value;
        }
    }

    @Immutable
    protected static class JcrEvent
    implements Event {
        private final String id;
        private final String path;
        private final int type;
        private final JcrEventBundle bundle;
        private final Map<String, ?> info;
        private final NodeType nodePrimaryType;
        private final NodeType[] nodeMixinTypes;

        JcrEvent(JcrEventBundle bundle, int type, String path, String id, NodeType nodePrimaryType, Set<NodeType> nodeMixinTypes) {
            this(bundle, type, path, id, null, nodePrimaryType, nodeMixinTypes);
        }

        JcrEvent(JcrEventBundle bundle, int type, String path, String id, Map<String, ?> info, NodeType nodePrimaryType, Set<NodeType> nodeMixinTypes) {
            this.type = type;
            this.path = path;
            this.bundle = bundle;
            this.id = id;
            this.info = info;
            this.nodePrimaryType = nodePrimaryType;
            this.nodeMixinTypes = nodeMixinTypes != null ? nodeMixinTypes.toArray(new NodeType[0]) : new NodeType[]{};
        }

        public String getPath() {
            return this.path;
        }

        public int getType() {
            return this.type;
        }

        public String getUserID() {
            return this.bundle.getUserID();
        }

        public long getDate() {
            return this.bundle.getDate().getMilliseconds();
        }

        public String getIdentifier() {
            return this.id;
        }

        public String getUserData() {
            return this.bundle.getUserData();
        }

        public Map<String, ?> getInfo() {
            return this.info != null ? Collections.unmodifiableMap(this.info) : Collections.emptyMap();
        }

        public NodeType getPrimaryNodeType() {
            return this.nodePrimaryType;
        }

        public NodeType[] getMixinNodeTypes() {
            return this.nodeMixinTypes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.type) {
                case 1: {
                    sb.append("Node added");
                    break;
                }
                case 2: {
                    sb.append("Node removed");
                    break;
                }
                case 4: {
                    sb.append("Property added");
                    break;
                }
                case 16: {
                    sb.append("Property changed");
                    break;
                }
                case 8: {
                    sb.append("Property removed");
                    break;
                }
                case 32: {
                    if (this.info.containsKey(JcrObservationManager.MOVE_FROM_KEY) || this.info.containsKey(JcrObservationManager.MOVE_TO_KEY)) {
                        sb.append("Node moved");
                        sb.append(" from ").append(this.info.get(JcrObservationManager.MOVE_FROM_KEY)).append(" to ").append(this.info.get(JcrObservationManager.MOVE_TO_KEY));
                    } else {
                        Object source;
                        sb.append("Node reordered");
                        String destination = this.info.get(JcrObservationManager.ORDER_DEST_KEY).toString();
                        if (destination == null) {
                            destination = " at the end of the children list";
                        }
                        if ((source = this.info.get(JcrObservationManager.ORDER_SRC_KEY)) != null) {
                            sb.append(" from ").append(source);
                        }
                        sb.append(" to ").append(destination);
                    }
                    sb.append(" by ").append(this.getUserID());
                    return sb.toString();
                }
                case 128: {
                    sb.append("Node sequenced");
                    sb.append(" sequenced node:").append(this.info.get("sequencedNodeId")).append(" at path:").append(this.info.get("sequencedNodePath"));
                    sb.append(" ,output node:").append(this.getIdentifier()).append(" at path:").append(this.getPath());
                    return sb.toString();
                }
                case 256: {
                    sb.append("Node sequencing failure");
                    sb.append(" sequenced node:").append(this.info.get("sequencedNodeId")).append(" at path:").append(this.info.get("sequencedNodePath"));
                    sb.append(" ,cause: ").append(this.getInfo().get("sequencingFailureCause"));
                    return sb.toString();
                }
            }
            sb.append(" at ").append(this.path).append(" by ").append(this.getUserID());
            return sb.toString();
        }
    }

    @Immutable
    protected static class JcrEventBundle {
        private final DateTime date;
        private final String userId;
        private final String userData;

        public JcrEventBundle(DateTime dateTime, String userId, String userData) {
            this.userId = userId;
            this.userData = userData;
            this.date = dateTime;
        }

        public String getUserID() {
            return this.userId;
        }

        public DateTime getDate() {
            return this.date;
        }

        public String getUserData() {
            return this.userData;
        }
    }

    protected static class JcrEventIterator
    extends JcrRangeIterator<javax.jcr.observation.Event>
    implements EventIterator {
        public JcrEventIterator(Collection<javax.jcr.observation.Event> events) {
            super(events);
        }

        public javax.jcr.observation.Event nextEvent() {
            return (javax.jcr.observation.Event)this.next();
        }
    }

    protected static class JcrEventListenerIterator
    extends JcrRangeIterator<EventListener>
    implements EventListenerIterator {
        public JcrEventListenerIterator(Collection<EventListener> listeners) {
            super(listeners);
        }

        public EventListener nextEventListener() {
            return (EventListener)this.next();
        }
    }

    protected static class JcrRangeIterator<E>
    implements RangeIterator {
        private final List<? extends E> elements;
        private int position = 0;

        public JcrRangeIterator(Collection<? extends E> elements) {
            CheckArg.isNotNull(elements, (String)"elements");
            this.elements = new ArrayList<E>(elements);
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.elements.size();
        }

        public boolean hasNext() {
            return this.getPosition() < this.getSize();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E element = this.elements.get(this.position);
            ++this.position;
            return element;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void skip(long skipNum) {
            this.position = (int)((long)this.position + skipNum);
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
        }
    }

    @NotThreadSafe
    protected final class JcrListenerAdapter
    implements ChangeSetListener {
        private final EventListener delegate;
        private final ChangeSetConverter changeSetConverter;

        JcrListenerAdapter(EventListener delegate, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) {
            assert (delegate != null);
            this.delegate = delegate;
            this.changeSetConverter = new ChangeSetConverter(absPath, eventTypes, isDeep, nodeTypeNames, noLocal, uuids);
        }

        @Override
        public void notify(ChangeSet changeSet) {
            JcrObservationManager.this.decrementEventQueueStatistic(changeSet);
            List<javax.jcr.observation.Event> events = this.changeSetConverter.convert(changeSet);
            if (!events.isEmpty()) {
                this.delegate.onEvent((EventIterator)new JcrEventIterator((Collection<javax.jcr.observation.Event>)events));
            }
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof JcrListenerAdapter && this.delegate == ((JcrListenerAdapter)obj).delegate;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

