/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.RepositoryException;
import org.infinispan.commons.util.ReflectionUtil;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.ExtensionLogger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryIndexColumnDefinitionTemplate;
import org.modeshape.jcr.RepositoryIndexDefinition;
import org.modeshape.jcr.RepositoryIndexDefinitionTemplate;
import org.modeshape.jcr.RepositoryIndexes;
import org.modeshape.jcr.SystemContent;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.query.CompositeIndexWriter;
import org.modeshape.jcr.query.engine.ScanningQueryEngine;
import org.modeshape.jcr.spi.index.IndexColumnDefinitionTemplate;
import org.modeshape.jcr.spi.index.IndexDefinition;
import org.modeshape.jcr.spi.index.IndexDefinitionChanges;
import org.modeshape.jcr.spi.index.IndexDefinitionTemplate;
import org.modeshape.jcr.spi.index.IndexExistsException;
import org.modeshape.jcr.spi.index.IndexManager;
import org.modeshape.jcr.spi.index.InvalidIndexDefinitionException;
import org.modeshape.jcr.spi.index.NoSuchIndexException;
import org.modeshape.jcr.spi.index.provider.IndexProvider;
import org.modeshape.jcr.spi.index.provider.IndexProviderExistsException;
import org.modeshape.jcr.spi.index.provider.IndexWriter;
import org.modeshape.jcr.spi.index.provider.NoSuchProviderException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.ValueFactory;

@ThreadSafe
class RepositoryIndexManager
implements ChangeSetListener,
IndexManager {
    private final JcrRepository.RunningState repository;
    private final RepositoryConfiguration config;
    private final ExecutionContext context;
    private final String systemWorkspaceName;
    private final Path indexesPath;
    private final Collection<RepositoryConfiguration.Component> components;
    private final ConcurrentMap<String, IndexProvider> providers = new ConcurrentHashMap<String, IndexProvider>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile IndexWriter indexWriter;
    private final Logger logger = Logger.getLogger(this.getClass());
    private volatile RepositoryIndexes indexes = RepositoryIndexes.NO_INDEXES;

    RepositoryIndexManager(JcrRepository.RunningState repository, RepositoryConfiguration config) {
        this.repository = repository;
        this.config = config;
        this.context = repository.context();
        this.systemWorkspaceName = this.repository.repositoryCache().getSystemWorkspaceName();
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        this.indexesPath = pathFactory.createAbsolutePath(JcrLexicon.SYSTEM, ModeShapeLexicon.INDEXES);
        this.components = config.getIndexProviders();
        for (RepositoryConfiguration.Component component : this.components) {
            try {
                IndexProvider provider = (IndexProvider)component.createInstance(ScanningQueryEngine.class.getClassLoader());
                this.register(provider);
            }
            catch (Throwable t) {
                if (t.getCause() != null) {
                    t = t.getCause();
                }
                this.repository.error(t, JcrI18n.unableToInitializeSequencer, component, repository.name(), t.getMessage());
            }
        }
    }

    protected synchronized void initialize() {
        if (this.initialized.get()) {
            return;
        }
        Iterator providerIter = this.providers.entrySet().iterator();
        while (providerIter.hasNext()) {
            IndexProvider provider = (IndexProvider)providerIter.next().getValue();
            try {
                this.doInitialize(provider);
            }
            catch (Throwable t) {
                if (t.getCause() != null) {
                    t = t.getCause();
                }
                this.repository.error(t, JcrI18n.unableToInitializeIndexProvider, provider.getName(), this.repository.name(), t.getMessage());
                providerIter.remove();
            }
        }
        this.refreshIndexWriter();
        this.initialized.set(true);
    }

    protected void refreshIndexWriter() {
        this.indexWriter = CompositeIndexWriter.create(this.providers.values());
    }

    protected void doInitialize(IndexProvider provider) throws RepositoryException {
        provider.initialize();
        Method postInitialize = ReflectionUtil.findMethod(IndexProvider.class, (String)"postInitialize");
        ReflectionUtil.invokeAccessibly((Object)provider, (Method)postInitialize, (Object[])new Object[0]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Successfully initialized index provider '{0}' in repository '{1}'", new Object[]{provider.getName(), this.repository.name()});
        }
    }

    void shutdown() {
        for (IndexProvider provider : this.providers.values()) {
            try {
                provider.shutdown();
            }
            catch (RepositoryException e) {
                this.logger.error((Throwable)e, (I18nResource)JcrI18n.errorShuttingDownIndexProvider, new Object[]{this.repository.name(), provider.getName(), e.getMessage()});
            }
        }
    }

    IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    IndexWriter getIndexWriterForProvidersNeedingReindexing() {
        LinkedList<IndexProvider> reindexProviders = new LinkedList<IndexProvider>();
        for (IndexProvider provider : this.providers.values()) {
            if (!provider.isReindexingRequired()) continue;
            reindexProviders.add(provider);
        }
        return CompositeIndexWriter.create(reindexProviders);
    }

    @Override
    public synchronized void register(IndexProvider provider) throws RepositoryException {
        IndexProvider existing;
        if (this.providers.containsKey(provider.getName())) {
            throw new IndexProviderExistsException(JcrI18n.indexProviderAlreadyExists.text(new Object[]{provider.getName(), this.repository.name()}));
        }
        ReflectionUtil.setValue((Object)provider, (String)"repositoryName", (Object)this.repository.name());
        ReflectionUtil.setValue((Object)provider, (String)"logger", (Object)ExtensionLogger.getLogger(provider.getClass()));
        if (this.initialized.get()) {
            this.doInitialize(provider);
        }
        if ((existing = this.providers.putIfAbsent(provider.getName(), provider)) != null) {
            throw new IndexProviderExistsException(JcrI18n.indexProviderAlreadyExists.text(new Object[]{provider.getName(), this.repository.name()}));
        }
        this.readIndexDefinitions();
        this.refreshIndexWriter();
    }

    @Override
    public void unregister(String providerName) throws RepositoryException {
        IndexProvider provider = (IndexProvider)this.providers.remove(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(JcrI18n.indexProviderDoesNotExist.text(new Object[]{providerName, this.repository.name()}));
        }
        if (this.initialized.get()) {
            provider.shutdown();
        }
        this.readIndexDefinitions();
        this.refreshIndexWriter();
    }

    @Override
    public Set<String> getProviderNames() {
        return org.modeshape.common.collection.Collections.unmodifiableSet(new HashSet(this.providers.keySet()));
    }

    protected Iterable<IndexProvider> getProviders() {
        return new ArrayList<IndexProvider>(this.providers.values());
    }

    @Override
    public IndexProvider getProvider(String name) {
        return (IndexProvider)this.providers.get(name);
    }

    @Override
    public Map<String, IndexDefinition> getIndexDefinitions() {
        return this.indexes.getIndexDefinitions();
    }

    @Override
    public IndexColumnDefinitionTemplate createIndexColumnDefinitionTemplate() {
        return new RepositoryIndexColumnDefinitionTemplate();
    }

    @Override
    public IndexDefinitionTemplate createIndexDefinitionTemplate() {
        return new RepositoryIndexDefinitionTemplate();
    }

    @Override
    public void registerIndex(IndexDefinition indexDefinition, boolean allowUpdate) throws InvalidIndexDefinitionException, IndexExistsException, RepositoryException {
        this.registerIndexes(new IndexDefinition[]{indexDefinition}, allowUpdate);
    }

    @Override
    public void registerIndexes(IndexDefinition[] indexDefinitions, boolean allowUpdate) throws InvalidIndexDefinitionException, IndexExistsException, RepositoryException {
        CheckArg.isNotNull((Object)indexDefinitions, (String)"indexDefinitions");
        SessionCache systemCache = this.repository.createSystemSession(this.context, false);
        SystemContent system = new SystemContent(systemCache);
        for (IndexDefinition defn : indexDefinitions) {
            String name = defn.getName();
            String providerName = defn.getProviderName();
            if (this.indexes.getIndexDefinitions().containsKey(name)) {
                throw new IndexExistsException(JcrI18n.indexAlreadyExists.text(new Object[]{name, this.repository.name()}));
            }
            if (name == null) {
                throw new InvalidIndexDefinitionException(JcrI18n.indexMustHaveName.text(new Object[]{defn, this.repository.name()}));
            }
            if (providerName == null) {
                throw new InvalidIndexDefinitionException(JcrI18n.indexMustHaveProviderName.text(new Object[]{name, this.repository.name()}));
            }
            defn = RepositoryIndexDefinition.createFrom(defn, this.providers.containsKey(providerName));
            system.store(defn, allowUpdate);
        }
        this.indexes = this.readIndexDefinitions();
    }

    @Override
    public void unregisterIndex(String indexName) throws NoSuchIndexException, RepositoryException {
        IndexDefinition defn = this.indexes.getIndexDefinitions().get(indexName);
        if (defn == null) {
            throw new NoSuchIndexException(JcrI18n.indexDoesNotExist.text(new Object[]{indexName, this.repository.name()}));
        }
        SessionCache systemCache = this.repository.createSystemSession(this.context, false);
        SystemContent system = new SystemContent(systemCache);
        system.remove(defn);
        this.indexes = this.readIndexDefinitions();
    }

    RepositoryIndexManager with(JcrRepository.RunningState repository) {
        return new RepositoryIndexManager(repository, this.config);
    }

    protected final ValueFactory<String> strings() {
        return this.context.getValueFactories().getStringFactory();
    }

    public RepositoryIndexes getIndexes() {
        return this.indexes;
    }

    @Override
    public void notify(ChangeSet changeSet) {
        Object providerName;
        if (!this.systemWorkspaceName.equals(changeSet.getWorkspaceName())) {
            return;
        }
        AtomicReference<Map<Name, IndexChangeInfo>> changesByProviderName = new AtomicReference<Map<Name, IndexChangeInfo>>();
        for (Change change : changeSet) {
            PropertyChanged propChanged;
            Path changedPath;
            Name indexName;
            if (change instanceof NodeAdded) {
                NodeAdded added = (NodeAdded)change;
                Path addedPath = added.getPath();
                if (!this.indexesPath.isAncestorOf(addedPath)) continue;
                providerName = addedPath.getSegment(2).getName();
                if (addedPath.size() <= 3) continue;
                indexName = addedPath.getSegment(3).getName();
                RepositoryIndexManager.changeInfoForProvider(changesByProviderName, (Name)providerName).changed(indexName);
                continue;
            }
            if (change instanceof NodeRemoved) {
                NodeRemoved removed = (NodeRemoved)change;
                Path removedPath = removed.getPath();
                if (!this.indexesPath.isAncestorOf(removedPath)) continue;
                providerName = removedPath.getSegment(2).getName();
                if (removedPath.size() > 4) {
                    indexName = removedPath.getSegment(3).getName();
                    RepositoryIndexManager.changeInfoForProvider(changesByProviderName, (Name)providerName).changed(indexName);
                    continue;
                }
                if (removedPath.size() > 3) {
                    indexName = removedPath.getSegment(3).getName();
                    RepositoryIndexManager.changeInfoForProvider(changesByProviderName, (Name)providerName).removed(indexName);
                    continue;
                }
                if (removedPath.size() != 3) continue;
                RepositoryIndexManager.changeInfoForProvider(changesByProviderName, (Name)providerName).removedAll();
                continue;
            }
            if (!(change instanceof PropertyChanged) || !this.indexesPath.isAncestorOf(changedPath = (propChanged = (PropertyChanged)change).getPathToNode()) || changedPath.size() <= 3) continue;
            providerName = changedPath.getSegment(2).getName();
            indexName = changedPath.getSegment(3).getName();
            RepositoryIndexManager.changeInfoForProvider(changesByProviderName, (Name)providerName).changed(indexName);
        }
        if (changesByProviderName.get() == null || ((Map)changesByProviderName.get()).isEmpty()) {
            return;
        }
        RepositoryIndexes indexes = this.readIndexDefinitions();
        StringFactory strings = this.context.getValueFactories().getStringFactory();
        for (Map.Entry entry : ((Map)changesByProviderName.get()).entrySet()) {
            providerName = (String)strings.create((Name)entry.getKey());
            IndexProvider provider = (IndexProvider)this.providers.get(providerName);
            if (provider == null) continue;
            IndexChanges changes = new IndexChanges();
            IndexChangeInfo info = (IndexChangeInfo)entry.getValue();
            if (info.removedAll) {
                for (IndexDefinition defn : indexes.getIndexDefinitions().values()) {
                    if (!defn.getProviderName().equals(providerName)) continue;
                    changes.remove(defn.getName());
                }
            }
            for (Name name : info.removedIndexes) {
                changes.remove((String)strings.create(name));
            }
            for (Name name : info.changedIndexes) {
                IndexDefinition defn = indexes.getIndexDefinitions().get(strings.create(name));
                if (defn == null) continue;
                changes.change(defn);
            }
            try {
                provider.notify(changes);
            }
            catch (RuntimeException e) {
                this.logger.error((Throwable)e, (I18nResource)JcrI18n.errorNotifyingProviderOfIndexChanges, new Object[]{providerName, this.repository.name(), e.getMessage()});
            }
        }
        this.indexes = indexes;
    }

    protected static IndexChangeInfo changeInfoForProvider(AtomicReference<Map<Name, IndexChangeInfo>> changesByProviderName, Name providerName) {
        IndexChangeInfo info;
        Map<Name, IndexChangeInfo> byProviderName = changesByProviderName.get();
        if (byProviderName == null) {
            byProviderName = new HashMap<Name, IndexChangeInfo>();
            changesByProviderName.set(byProviderName);
        }
        if ((info = byProviderName.get(providerName)) == null) {
            info = new IndexChangeInfo();
            byProviderName.put(providerName, info);
        }
        return info;
    }

    protected RepositoryIndexes readIndexDefinitions() {
        NodeTypes nodeTypes = this.repository.nodeTypeManager().getNodeTypes();
        try {
            SessionCache systemCache = this.repository.createSystemSession(this.context, false);
            SystemContent system = new SystemContent(systemCache);
            List<IndexDefinition> indexDefns = system.readAllIndexDefinitions(this.providers.keySet());
            return new Indexes(indexDefns, nodeTypes);
        }
        catch (Throwable e) {
            this.logger.error(e, (I18nResource)JcrI18n.errorRefreshingIndexDefinitions, new Object[]{this.repository.name()});
            return this.indexes;
        }
    }

    @Immutable
    public static final class Indexes
    extends RepositoryIndexes {
        private final Map<String, IndexDefinition> indexByName = new HashMap<String, IndexDefinition>();
        private final Map<String, Map<String, Collection<IndexDefinition>>> indexesByProviderByNodeTypeName = new HashMap<String, Map<String, Collection<IndexDefinition>>>();

        protected Indexes(Collection<IndexDefinition> defns, NodeTypes nodeTypes) {
            if (!defns.isEmpty()) {
                HashMap<Name, LinkedList<String>> subtypesByName = new HashMap<Name, LinkedList<String>>();
                for (JcrNodeType nodeType : nodeTypes.getAllNodeTypes()) {
                    for (JcrNodeType supertype : nodeType.getTypeAndSupertypes()) {
                        LinkedList<String> types = (LinkedList<String>)subtypesByName.get(supertype.getInternalName());
                        if (types == null) {
                            types = new LinkedList<String>();
                            subtypesByName.put(supertype.getInternalName(), types);
                        }
                        types.add(nodeType.getName());
                    }
                }
                HashSet nodeTypeNames = new HashSet();
                for (IndexDefinition defn : defns) {
                    this.indexByName.put(defn.getName(), defn);
                    nodeTypeNames.clear();
                    Name nodeTypeName = defn.getNodeTypeName();
                    for (String typeAndSubtype : (Collection)subtypesByName.get(nodeTypeName)) {
                        Collection<IndexDefinition> indexes;
                        Map<String, Collection<IndexDefinition>> byProvider = this.indexesByProviderByNodeTypeName.get(typeAndSubtype);
                        if (byProvider == null) {
                            byProvider = new HashMap<String, Collection<IndexDefinition>>();
                            this.indexesByProviderByNodeTypeName.put(typeAndSubtype, byProvider);
                        }
                        if ((indexes = byProvider.get(defn.getProviderName())) == null) {
                            indexes = new LinkedList<IndexDefinition>();
                            byProvider.put(typeAndSubtype, indexes);
                        }
                        indexes.add(defn);
                    }
                }
            }
        }

        @Override
        public Map<String, IndexDefinition> getIndexDefinitions() {
            return Collections.unmodifiableMap(this.indexByName);
        }

        @Override
        public Iterable<IndexDefinition> indexesFor(String nodeTypeName, String providerName) {
            Map<String, Collection<IndexDefinition>> defnsByProvider = this.indexesByProviderByNodeTypeName.get(nodeTypeName);
            if (defnsByProvider == null) {
                return null;
            }
            return defnsByProvider.get(providerName);
        }
    }

    protected static final class IndexChanges
    implements IndexDefinitionChanges {
        private final Set<String> removedDefinitions = new HashSet<String>();
        private final Map<String, IndexDefinition> changedDefinitions = new HashMap<String, IndexDefinition>();

        protected IndexChanges() {
        }

        protected void remove(String name) {
            this.removedDefinitions.add(name);
        }

        protected void change(IndexDefinition indexDefn) {
            this.changedDefinitions.put(indexDefn.getName(), indexDefn);
        }

        @Override
        public Set<String> getRemovedIndexDefinitions() {
            return this.removedDefinitions;
        }

        @Override
        public Map<String, IndexDefinition> getUpdatedIndexDefinitions() {
            return this.changedDefinitions;
        }
    }

    protected static final class IndexChangeInfo {
        protected final Set<Name> changedIndexes = new HashSet<Name>();
        protected final Set<Name> removedIndexes = new HashSet<Name>();
        protected boolean removedAll = false;

        protected IndexChangeInfo() {
        }

        public void changed(Name indexName) {
            this.changedIndexes.add(indexName);
            this.removedIndexes.remove(indexName);
        }

        public void removed(Name indexName) {
            this.removedIndexes.add(indexName);
            this.changedIndexes.remove(indexName);
        }

        public void removedAll() {
            this.removedAll = true;
            this.removedIndexes.clear();
            this.changedIndexes.clear();
        }
    }
}

