/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.change;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;

public abstract class AbstractNodeChange
extends Change {
    private static final long serialVersionUID = 1L;
    private final NodeKey key;
    private final Name[] types;
    protected final Path path;

    protected AbstractNodeChange(NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes) {
        assert (key != null);
        assert (path != null);
        this.key = key;
        this.path = path;
        int typesCount = (mixinTypes != null ? mixinTypes.size() : 0) + 1;
        this.types = new Name[typesCount];
        this.types[0] = primaryType;
        if (typesCount > 1) {
            assert (mixinTypes != null);
            System.arraycopy(mixinTypes.toArray(new Name[0]), 0, this.types, 1, mixinTypes.size());
        }
    }

    public Path getPath() {
        return this.path;
    }

    public NodeKey getKey() {
        return this.key;
    }

    public Name getPrimaryType() {
        return this.types[0];
    }

    public Set<Name> getMixinTypes() {
        if (this.types.length == 1) {
            return Collections.emptySet();
        }
        return new HashSet<Name>(Arrays.asList(Arrays.copyOfRange(this.types, 1, this.types.length)));
    }
}

