/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.query.qom.Constraint;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.query.qom.NodePath;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.spi.index.IndexCollector;
import org.modeshape.jcr.spi.index.IndexDefinition;
import org.modeshape.jcr.spi.index.provider.IndexPlanner;

@Immutable
public final class IndexPlan
implements Comparable<IndexPlan> {
    private static final Map<String, Object> NO_PARAMETERS = Collections.emptyMap();
    private final String name;
    private final String providerName;
    private final int costEstimate;
    private final long cardinalityEstimate;
    private final Collection<Constraint> constraints;
    private final Map<String, Object> parameters;
    protected static final String NODE_BY_PATH_INDEX_NAME = "NodeByPath";
    protected static final String CHILDREN_BY_PATH_INDEX_NAME = "ChildrenByPath";
    protected static final String DESCENDANTS_BY_PATH_INDEX_NAME = "DescendantsByPath";
    protected static final String PATH_PARAMETER = "path";

    public IndexPlan(String name, String providerName, Collection<Constraint> constraints, int costEstimate, long cardinalityEstimate, Map<String, Object> parameters) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        CheckArg.isNonNegative((int)costEstimate, (String)"costEstimate");
        CheckArg.isNonNegative((long)cardinalityEstimate, (String)"cardinalityEstimate");
        this.name = name;
        this.providerName = providerName;
        this.constraints = constraints;
        this.costEstimate = costEstimate;
        this.cardinalityEstimate = cardinalityEstimate;
        this.parameters = parameters == null ? NO_PARAMETERS : parameters;
    }

    public long getCardinalityEstimate() {
        return this.cardinalityEstimate;
    }

    public int getCostEstimate() {
        return this.costEstimate;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public Collection<Constraint> getConstraints() {
        return this.constraints;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" cost=").append(this.getCostEstimate());
        sb.append(", cardinality=").append(this.getCardinalityEstimate());
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            sb.append(", ").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(IndexPlan that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        return this.getCostEstimate() - that.costEstimate;
    }

    @Immutable
    public static class StandardIndexPlanner
    extends IndexPlanner {
        public static final IndexPlanner INSTANCE = new StandardIndexPlanner();

        @Override
        public void applyIndexes(QueryContext context, SelectorName selector, List<Constraint> andedConstraints, Iterable<IndexDefinition> indexesOnSelector, IndexCollector indexes) {
            for (Constraint constraint : andedConstraints) {
                String path;
                if (constraint instanceof SameNode) {
                    SameNode sameNode = (SameNode)constraint;
                    path = sameNode.getPath();
                    indexes.addIndex(IndexPlan.NODE_BY_PATH_INDEX_NAME, null, Collections.singletonList(constraint), 1, 1L, IndexPlan.PATH_PARAMETER, path);
                    continue;
                }
                if (constraint instanceof ChildNode) {
                    ChildNode childNode = (ChildNode)constraint;
                    path = childNode.getParentPath();
                    indexes.addIndex(IndexPlan.CHILDREN_BY_PATH_INDEX_NAME, null, Collections.singletonList(constraint), 10, 100L, IndexPlan.PATH_PARAMETER, path);
                    continue;
                }
                if (constraint instanceof DescendantNode) {
                    DescendantNode descendantNode = (DescendantNode)constraint;
                    path = descendantNode.getAncestorPath();
                    indexes.addIndex(IndexPlan.DESCENDANTS_BY_PATH_INDEX_NAME, null, Collections.singletonList(constraint), 1000, 10000L, IndexPlan.PATH_PARAMETER, path);
                    continue;
                }
                if (!(constraint instanceof Comparison)) continue;
                Comparison comparison = (Comparison)constraint;
                if (comparison.operator() != Operator.EQUAL_TO) {
                    return;
                }
                DynamicOperand leftSide = comparison.getOperand1();
                if (!(leftSide instanceof NodePath)) continue;
                StaticOperand rightSide = comparison.getOperand2();
                Object value = null;
                if (rightSide instanceof BindVariableName) {
                    BindVariableName varName = (BindVariableName)rightSide;
                    value = context.getVariables().get(varName.getBindVariableName());
                } else if (rightSide instanceof Literal) {
                    value = ((Literal)rightSide).value();
                }
                if (value == null) {
                    return;
                }
                String path2 = null;
                if (value instanceof String) {
                    path2 = (String)value;
                }
                if (path2 == null) continue;
                indexes.addIndex(IndexPlan.NODE_BY_PATH_INDEX_NAME, null, Collections.singletonList(constraint), 1, 1L, IndexPlan.PATH_PARAMETER, path2);
            }
        }
    }
}

