/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Iterator;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;

@NotThreadSafe
final class JcrChildNodeIterator
implements NodeIterator {
    private final NodeResolver resolver;
    private final Iterator<ChildReference> iterator;
    private Node resolvedNode;
    private Iterator<Node> nodeIterator;
    private int ndx;
    private long size;

    JcrChildNodeIterator(NodeResolver resolver, Iterator<ChildReference> iterator) {
        this.resolver = resolver;
        this.iterator = iterator;
        this.size = -1L;
    }

    JcrChildNodeIterator(NodeResolver resolver, ChildReferences childReferences) {
        assert (this.size >= 0L);
        this.resolver = resolver;
        this.iterator = childReferences.iterator();
        this.size = childReferences.size();
    }

    public long getPosition() {
        return this.ndx;
    }

    public long getSize() {
        if (this.size > -1L) {
            return this.size;
        }
        if (!this.hasNext()) {
            this.size = this.resolvedNode == null ? (long)this.ndx : (long)(this.ndx + 1);
            return this.size;
        }
        LinkedList<Node> remainingNodes = new LinkedList<Node>();
        if (this.resolvedNode != null) {
            this.size = this.ndx + 1;
            remainingNodes.add(this.resolvedNode);
            this.resolvedNode = null;
        } else {
            this.size = this.ndx;
        }
        while (this.iterator.hasNext()) {
            Node node = this.resolver.nodeFrom(this.iterator.next());
            if (node == null) continue;
            remainingNodes.add(node);
            ++this.size;
        }
        this.nodeIterator = remainingNodes.iterator();
        return this.size;
    }

    public boolean hasNext() {
        if (this.nodeIterator != null) {
            return this.nodeIterator.hasNext();
        }
        while (this.iterator.hasNext() && this.resolvedNode == null) {
            ChildReference ref = this.iterator.next();
            this.resolvedNode = this.resolver.nodeFrom(ref);
        }
        return this.resolvedNode != null;
    }

    public Object next() {
        return this.nextNode();
    }

    public Node nextNode() {
        if (this.nodeIterator != null) {
            return this.nodeIterator.next();
        }
        Node child = null;
        if (this.resolvedNode == null) {
            ChildReference childRef;
            while ((child = this.resolver.nodeFrom(childRef = this.iterator.next())) == null) {
            }
        } else {
            child = this.resolvedNode;
            this.resolvedNode = null;
        }
        ++this.ndx;
        return child;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skip(long count) {
        CheckArg.isNonNegative((long)count, (String)"count");
        while (--count >= 0L) {
            this.nextNode();
        }
    }

    protected static interface NodeResolver {
        public Node nodeFrom(ChildReference var1);
    }
}

