/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.modeshape.common.collection.ReadOnlyIterator;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.RepositoryIndexColumnDefinition;
import org.modeshape.jcr.RepositoryIndexDefinition;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.index.IndexDefinitionTemplate;

class RepositoryIndexDefinitionTemplate
implements IndexDefinitionTemplate {
    private final String DEFAULT_NODE_TYPE_NAME = JcrNtLexicon.BASE.getString();
    private String name;
    private String providerName;
    private IndexDefinition.IndexKind kind = IndexDefinition.IndexKind.DUPLICATES;
    private String nodeTypeName = this.DEFAULT_NODE_TYPE_NAME;
    private String description = "";
    private boolean enabled = true;
    private List<IndexColumnDefinition> columnDefns = new ArrayList<IndexColumnDefinition>();
    private Map<String, Object> extendedProperties = new HashMap<String, Object>();
    private IndexDefinition.WorkspaceMatchRule workspaceRule = RepositoryIndexDefinition.MATCH_ALL_WORKSPACES_RULE;

    RepositoryIndexDefinitionTemplate() {
    }

    public String getName() {
        return this.name;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public IndexDefinition.IndexKind getKind() {
        return this.kind;
    }

    public String getNodeTypeName() {
        return this.nodeTypeName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasSingleColumn() {
        return this.columnDefns.size() == 1;
    }

    public int size() {
        return this.columnDefns.size();
    }

    public IndexColumnDefinition getColumnDefinition(int position) throws NoSuchElementException {
        return this.columnDefns.get(position);
    }

    public Object getIndexProperty(String propertyName) {
        return this.extendedProperties.get(propertyName);
    }

    public Map<String, Object> getIndexProperties() {
        return this.extendedProperties;
    }

    public IndexDefinition.WorkspaceMatchRule getWorkspaceMatchRule() {
        return this.workspaceRule;
    }

    public Iterator<IndexColumnDefinition> iterator() {
        return ReadOnlyIterator.around(this.columnDefns.iterator());
    }

    public IndexDefinitionTemplate setName(String name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        this.name = name;
        return this;
    }

    public IndexDefinitionTemplate setProviderName(String providerName) {
        CheckArg.isNotNull((Object)providerName, (String)"providerName");
        this.providerName = providerName;
        return this;
    }

    public IndexDefinitionTemplate setKind(IndexDefinition.IndexKind kind) {
        CheckArg.isNotNull((Object)kind, (String)"kind");
        this.kind = kind;
        return this;
    }

    public IndexDefinitionTemplate setNodeTypeName(String name) {
        this.nodeTypeName = name != null ? name : this.DEFAULT_NODE_TYPE_NAME;
        return this;
    }

    public IndexDefinitionTemplate setDescription(String description) {
        this.description = description != null ? description : "";
        return this;
    }

    public IndexDefinitionTemplate setColumnDefinitions(Iterable<? extends IndexColumnDefinition> columnDefinitions) {
        this.columnDefns.clear();
        for (IndexColumnDefinition indexColumnDefinition : columnDefinitions) {
            this.columnDefns.add(RepositoryIndexColumnDefinition.createFrom(indexColumnDefinition));
        }
        return this;
    }

    public IndexDefinitionTemplate setAllWorkspaces() {
        this.workspaceRule = RepositoryIndexDefinition.MATCH_ALL_WORKSPACES_RULE;
        return this;
    }

    public IndexDefinitionTemplate setWorkspace(String workspaceName) {
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceRule = new RepositoryIndexDefinition.ExactWorkspaceMatchRule(workspaceName);
        return this;
    }

    public IndexDefinitionTemplate setWorkspaces(String ... workspaceNames) {
        CheckArg.isNotEmpty((Object[])workspaceNames, (String)"workspaceNames");
        this.workspaceRule = RepositoryIndexDefinition.workspaceMatchRule(workspaceNames);
        return this;
    }

    public IndexDefinitionTemplate setWorkspaceNamePattern(String regex) {
        this.workspaceRule = new RepositoryIndexDefinition.ExactWorkspaceMatchRule(regex);
        return this;
    }
}

