/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Comparator;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.Serializer;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.MapDB;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueFactory;

public abstract class IndexSpec {
    protected final ExecutionContext context;
    protected final MapDB.Serializers serializers;

    public static IndexSpec create(ExecutionContext context, IndexDefinition defn) {
        if (defn.hasSingleColumn()) {
            return new SingleColumnSpec(context, defn);
        }
        return null;
    }

    protected IndexSpec(ExecutionContext context, IndexDefinition defn) {
        this.context = context;
        this.serializers = MapDB.serializers(this.context.getValueFactories());
    }

    public abstract Serializer<?> getSerializer();

    public abstract BTreeKeySerializer<?> getBTreeKeySerializer();

    public abstract Comparator<?> getComparator();

    public abstract IndexValues.Converter<?> getConverter();

    public abstract Class<?> getValueClass();

    protected static class SingleColumnSpec
    extends IndexSpec {
        private final IndexColumnDefinition columnDefn;
        private final PropertyType type;

        protected SingleColumnSpec(ExecutionContext context, IndexDefinition defn) {
            super(context, defn);
            assert (defn.hasSingleColumn());
            this.columnDefn = defn.getColumnDefinition(0);
            this.type = PropertyType.valueFor(this.columnDefn.getColumnType());
        }

        @Override
        public Serializer<?> getSerializer() {
            return this.serializers.serializerFor(this.getValueClass());
        }

        @Override
        public BTreeKeySerializer<?> getBTreeKeySerializer() {
            return this.serializers.bTreeKeySerializerFor(this.getValueClass(), this.getComparator(), false);
        }

        @Override
        public Comparator<?> getComparator() {
            return this.getColumnType().getComparator();
        }

        @Override
        public Class<?> getValueClass() {
            return this.getColumnType().getValueClass();
        }

        protected PropertyType getColumnType() {
            return this.type;
        }

        @Override
        public IndexValues.Converter<?> getConverter() {
            ValueFactory<?> factory = this.context.getValueFactories().getValueFactory(this.getColumnType());
            return IndexValues.converter(factory);
        }
    }
}

