/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.PropertyExistence;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.api.query.qom.Between;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.api.query.qom.SetCriteria;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.spi.index.ResultWriter;
import org.modeshape.jcr.spi.index.provider.Filter;

class Operations {
    protected static final Logger LOGGER = Logger.getLogger(Operations.class);

    public static <T> Filter.Results createOperation(NavigableMap<T, String> keysByValue, IndexValues.Converter<T> converter, Collection<Constraint> constraints) {
        OperationBuilder builder = new BasicOperationBuilder<T>(keysByValue, converter);
        for (Constraint constraint : constraints) {
            OperationBuilder newBuilder = builder.apply(constraint, false);
            if (newBuilder == null) continue;
            builder = newBuilder;
        }
        return ((OperationBuilder)builder).build();
    }

    private Operations() {
    }

    protected static class DualOperationBuilder<T>
    extends OperationBuilder<T> {
        protected final OperationBuilder<T> left;
        protected final OperationBuilder<T> right;

        protected DualOperationBuilder(OperationBuilder<T> left, OperationBuilder<T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        protected OperationBuilder<T> apply(Between between, boolean negated) {
            OperationBuilder<T> left = this.left.apply(between, negated);
            OperationBuilder<T> right = this.right.apply(between, negated);
            return new DualOperationBuilder<T>(left, right);
        }

        @Override
        protected OperationBuilder<T> apply(Comparison comparison, boolean negated) {
            OperationBuilder<T> left = this.left.apply(comparison, negated);
            OperationBuilder<T> right = this.right.apply(comparison, negated);
            return new DualOperationBuilder<T>(left, right);
        }

        @Override
        protected OperationBuilder<T> apply(SetCriteria setCriteria, boolean negated) {
            OperationBuilder<T> left = this.left.apply(setCriteria, negated);
            OperationBuilder<T> right = this.right.apply(setCriteria, negated);
            return new DualOperationBuilder<T>(left, right);
        }

        @Override
        protected Filter.Results build() {
            final Filter.Results first = this.left.build();
            return new Filter.Results(){
                Filter.Results second = null;

                @Override
                public boolean getNextBatch(ResultWriter writer, int batchSize) {
                    if (first.getNextBatch(writer, batchSize)) {
                        return true;
                    }
                    if (this.second == null) {
                        this.second = DualOperationBuilder.this.right.build();
                    }
                    return this.second.getNextBatch(writer, batchSize);
                }

                @Override
                public void close() {
                }
            };
        }
    }

    protected static class SetOperationBuilder<T>
    extends BasicOperationBuilder<T> {
        private final SetCriteria criteria;
        private final boolean negated;

        protected SetOperationBuilder(NavigableMap<T, String> keysByValue, IndexValues.Converter<T> converter, SetCriteria criteria, boolean negated) {
            super(keysByValue, converter);
            this.criteria = criteria;
            this.negated = negated;
        }

        @Override
        protected OperationBuilder<T> create(NavigableMap<T, String> keysByValue) {
            return new SetOperationBuilder<T>(keysByValue, this.converter, this.criteria, this.negated);
        }

        @Override
        protected OperationBuilder<T> apply(SetCriteria setCriteria, boolean negated) {
            throw new UnsupportedOperationException("Can't evaluate two SetCriteria that are not ANDed or ORed together");
        }

        @Override
        protected Iterator<String> keys() {
            final HashSet matchedKeys = new HashSet();
            for (javax.jcr.query.qom.StaticOperand valueOperand : this.criteria.getValues()) {
                Object lowValue = this.converter.toLowerValue(valueOperand);
                Object highValue = this.converter.toUpperValue(valueOperand);
                NavigableMap submap = null;
                if (lowValue == null) {
                    if (highValue == null) continue;
                    submap = this.keysByValue.headMap(highValue, true);
                } else {
                    submap = highValue == null ? this.keysByValue.tailMap(lowValue, true) : this.keysByValue.subMap(lowValue, true, highValue, true);
                }
                if (submap.isEmpty()) continue;
                matchedKeys.addAll(submap.values());
            }
            if (!this.negated) {
                return matchedKeys.iterator();
            }
            final Iterator<String> allKeys = super.keys();
            if (matchedKeys.isEmpty()) {
                return allKeys;
            }
            return new Iterator<String>(){
                private String next;

                @Override
                public boolean hasNext() {
                    return this.findNext();
                }

                @Override
                public String next() {
                    if (this.findNext()) {
                        assert (this.next != null);
                        String result = this.next;
                        this.next = null;
                        return result;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private boolean findNext() {
                    if (this.next != null) {
                        return true;
                    }
                    while (allKeys.hasNext()) {
                        String possible = (String)allKeys.next();
                        if (matchedKeys.contains(possible)) continue;
                        this.next = possible;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    protected static class BasicOperationBuilder<T>
    extends OperationBuilder<T> {
        protected final NavigableMap<T, String> keysByValue;
        protected final IndexValues.Converter<T> converter;

        protected BasicOperationBuilder(NavigableMap<T, String> keysByValue, IndexValues.Converter<T> converter) {
            this.keysByValue = keysByValue;
            this.converter = converter;
        }

        protected OperationBuilder<T> create(NavigableMap<T, String> keysByValue) {
            return new BasicOperationBuilder<T>(keysByValue, this.converter);
        }

        @Override
        protected OperationBuilder<T> apply(Between between, boolean negated) {
            T lower = this.converter.toLowerValue(between.getLowerBound());
            T upper = this.converter.toUpperValue(between.getUpperBound());
            boolean isLowerIncluded = between.isLowerBoundIncluded();
            boolean isUpperIncluded = between.isUpperBoundIncluded();
            if (negated) {
                OperationBuilder<T> lowerOp = this.create(this.keysByValue.headMap(lower, isLowerIncluded));
                OperationBuilder<T> upperOp = this.create(this.keysByValue.tailMap(upper, isUpperIncluded));
                return new DualOperationBuilder<T>(lowerOp, upperOp);
            }
            return this.create(this.keysByValue.subMap(lower, isLowerIncluded, upper, isUpperIncluded));
        }

        @Override
        protected OperationBuilder<T> apply(Comparison comparison, boolean negated) {
            StaticOperand operand = comparison.getOperand2();
            Operator op = comparison.operator();
            if (negated) {
                op = op.not();
            }
            switch (op) {
                case EQUAL_TO: {
                    T lowerValue = this.converter.toLowerValue(operand);
                    T upperValue = this.converter.toUpperValue(operand);
                    return this.create(this.keysByValue.subMap(lowerValue, true, upperValue, true));
                }
                case GREATER_THAN: {
                    T value = this.converter.toUpperValue(operand);
                    return this.create(this.keysByValue.tailMap(value, false));
                }
                case GREATER_THAN_OR_EQUAL_TO: {
                    T value = this.converter.toUpperValue(operand);
                    return this.create(this.keysByValue.tailMap(value, true));
                }
                case LESS_THAN: {
                    T value = this.converter.toLowerValue(operand);
                    return this.create(this.keysByValue.headMap(value, false));
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    T value = this.converter.toLowerValue(operand);
                    return this.create(this.keysByValue.headMap(value, true));
                }
                case NOT_EQUAL_TO: {
                    OperationBuilder<T> lowerOp = this.create(this.keysByValue.headMap(this.converter.toLowerValue(operand), false));
                    OperationBuilder<T> upperOp = this.create(this.keysByValue.tailMap(this.converter.toUpperValue(operand), false));
                    return new DualOperationBuilder<T>(lowerOp, upperOp);
                }
            }
            return this;
        }

        @Override
        protected OperationBuilder<T> apply(SetCriteria setCriteria, boolean negated) {
            return new SetOperationBuilder<T>(this.keysByValue, this.converter, setCriteria, negated);
        }

        protected Iterator<String> keys() {
            return this.keysByValue.values().iterator();
        }

        @Override
        protected Filter.Results build() {
            final Iterator<String> filteredKeys = this.keys();
            float score = 1.0f;
            return new Filter.Results(){

                @Override
                public boolean getNextBatch(ResultWriter writer, int batchSize) {
                    for (int count = 0; count < batchSize && filteredKeys.hasNext(); ++count) {
                        writer.add(new NodeKey((String)filteredKeys.next()), 1.0f);
                    }
                    return filteredKeys.hasNext();
                }

                @Override
                public void close() {
                }
            };
        }
    }

    protected static abstract class OperationBuilder<T> {
        protected OperationBuilder() {
        }

        public OperationBuilder<T> apply(Constraint constraint, boolean negated) {
            if (constraint instanceof Between) {
                return this.apply((Between)constraint, negated);
            }
            if (constraint instanceof Comparison) {
                return this.apply((Comparison)constraint, negated);
            }
            if (constraint instanceof And) {
                And and = (And)constraint;
                return this.apply(and.getConstraint1(), negated).apply(and.getConstraint2(), negated);
            }
            if (constraint instanceof Or) {
                Or or = (Or)constraint;
                OperationBuilder<T> left = this.apply(or.getConstraint1(), negated);
                OperationBuilder<T> right = this.apply(or.getConstraint2(), negated);
                return new DualOperationBuilder<T>(left, right);
            }
            if (constraint instanceof Not) {
                Not not = (Not)constraint;
                return this.apply(not.getConstraint(), !negated);
            }
            if (constraint instanceof PropertyExistence) {
                return this;
            }
            if (constraint instanceof SetCriteria) {
                SetCriteria criteria = (SetCriteria)constraint;
                return this.apply(criteria, negated);
            }
            LOGGER.debug("Unable to process constraint, so ignoring: {0}", new Object[]{constraint});
            return this;
        }

        protected abstract OperationBuilder<T> apply(Between var1, boolean var2);

        protected abstract OperationBuilder<T> apply(Comparison var1, boolean var2);

        protected abstract OperationBuilder<T> apply(SetCriteria var1, boolean var2);

        protected abstract Filter.Results build();
    }
}

