/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.query.qom.Constraint;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.RepositoryIndexes;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.query.qom.NodePath;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.spi.index.IndexCollector;
import org.modeshape.jcr.spi.index.provider.IndexPlanner;

public abstract class IndexPlanners {
    private static final IndexPlanners IMPLICIT = new IndexPlanners(){

        @Override
        public void applyIndexes(QueryContext context, SelectorName selector, List<Constraint> andedConstraints, RepositoryIndexes indexDefinitions, IndexCollector indexes) {
            StandardIndexPlanner.INSTANCE.applyIndexes(context, selector, andedConstraints, null, indexes);
        }
    };
    protected static final String NODE_BY_PATH_INDEX_NAME = "NodeByPath";
    protected static final String CHILDREN_BY_PATH_INDEX_NAME = "ChildrenByPath";
    protected static final String DESCENDANTS_BY_PATH_INDEX_NAME = "DescendantsByPath";
    protected static final String PATH_PARAMETER = "path";

    public abstract void applyIndexes(QueryContext var1, SelectorName var2, List<Constraint> var3, RepositoryIndexes var4, IndexCollector var5);

    public static IndexPlanners implicit() {
        return IMPLICIT;
    }

    public static IndexPlanners withProviders(final Map<String, IndexPlanner> plannersByProviderName) {
        return new IndexPlanners(){

            @Override
            public void applyIndexes(QueryContext context, SelectorName selector, List<Constraint> andedConstraints, RepositoryIndexes indexDefinitions, IndexCollector indexes) {
                StandardIndexPlanner.INSTANCE.applyIndexes(context, selector, andedConstraints, null, indexes);
                if (indexDefinitions != null) {
                    for (Map.Entry entry : plannersByProviderName.entrySet()) {
                        String providerName = (String)entry.getKey();
                        Iterable<IndexDefinition> indexDefns = indexDefinitions.indexesFor(selector.name(), providerName);
                        if (indexDefns == null) continue;
                        IndexPlanner planner = (IndexPlanner)entry.getValue();
                        planner.applyIndexes(context, selector, andedConstraints, indexDefns, indexes);
                    }
                }
            }
        };
    }

    @Immutable
    private static class StandardIndexPlanner
    extends IndexPlanner {
        public static final IndexPlanner INSTANCE = new StandardIndexPlanner();

        private StandardIndexPlanner() {
        }

        @Override
        public void applyIndexes(QueryContext context, SelectorName selector, List<Constraint> andedConstraints, Iterable<IndexDefinition> indexesOnSelector, IndexCollector indexes) {
            for (Constraint constraint : andedConstraints) {
                String path;
                if (constraint instanceof SameNode) {
                    SameNode sameNode = (SameNode)constraint;
                    path = sameNode.getPath();
                    indexes.addIndex(IndexPlanners.NODE_BY_PATH_INDEX_NAME, null, null, Collections.singletonList(constraint), 1, 1L, IndexPlanners.PATH_PARAMETER, path);
                    continue;
                }
                if (constraint instanceof ChildNode) {
                    ChildNode childNode = (ChildNode)constraint;
                    path = childNode.getParentPath();
                    indexes.addIndex(IndexPlanners.CHILDREN_BY_PATH_INDEX_NAME, null, null, Collections.singletonList(constraint), 10, 100L, IndexPlanners.PATH_PARAMETER, path);
                    continue;
                }
                if (constraint instanceof DescendantNode) {
                    DescendantNode descendantNode = (DescendantNode)constraint;
                    path = descendantNode.getAncestorPath();
                    indexes.addIndex(IndexPlanners.DESCENDANTS_BY_PATH_INDEX_NAME, null, null, Collections.singletonList(constraint), 1000, 10000L, IndexPlanners.PATH_PARAMETER, path);
                    continue;
                }
                if (!(constraint instanceof Comparison)) continue;
                Comparison comparison = (Comparison)constraint;
                if (comparison.operator() != Operator.EQUAL_TO) {
                    return;
                }
                DynamicOperand leftSide = comparison.getOperand1();
                if (!(leftSide instanceof NodePath)) continue;
                StaticOperand rightSide = comparison.getOperand2();
                Object value = null;
                if (rightSide instanceof BindVariableName) {
                    BindVariableName varName = (BindVariableName)rightSide;
                    value = context.getVariables().get(varName.getBindVariableName());
                } else if (rightSide instanceof Literal) {
                    value = ((Literal)rightSide).value();
                }
                if (value == null) {
                    return;
                }
                String path2 = null;
                if (value instanceof String) {
                    path2 = (String)value;
                }
                if (path2 == null) continue;
                indexes.addIndex(IndexPlanners.NODE_BY_PATH_INDEX_NAME, null, null, Collections.singletonList(constraint), 1, 1L, IndexPlanners.PATH_PARAMETER, path2);
            }
        }
    }
}

