/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.query.qom.Constraint;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.engine.IndexPlan;
import org.modeshape.jcr.query.engine.IndexPlanners;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.spi.index.IndexCollector;

@Immutable
public class AddIndexes
implements OptimizerRule {
    private static final AddIndexes IMPLICIT_INDEXES = new AddIndexes(null);
    private final IndexPlanners planners;

    public static AddIndexes implicitIndexes() {
        return IMPLICIT_INDEXES;
    }

    public static AddIndexes with(IndexPlanners planners) {
        return new AddIndexes(planners);
    }

    protected AddIndexes(IndexPlanners planner) {
        this.planners = planner != null ? planner : IndexPlanners.implicit();
    }

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (final PlanNode source : plan.findAllAtOrBelow(PlanNode.Type.SOURCE)) {
            final AtomicReference constraints = new AtomicReference();
            source.applyToAncestorsUpTo(PlanNode.Type.ACCESS, new PlanNode.Operation(){

                @Override
                public void apply(PlanNode node) {
                    Constraint constraint;
                    if (node.getType() == PlanNode.Type.SELECT && (constraint = node.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class)) != null) {
                        if (constraints.get() == null) {
                            constraints.set(new LinkedList());
                        }
                        ((List)constraints.get()).add(constraint);
                    }
                }
            });
            if (constraints.get() == null) continue;
            IndexCollector collector = new IndexCollector(){

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints, int costEstimate, long cardinalityEstimate, Map<String, Object> parameters) {
                    PlanNode indexNode = new PlanNode(PlanNode.Type.INDEX, source.getSelectors());
                    IndexPlan indexPlan = new IndexPlan(name, workspaceName, providerName, constraints, costEstimate, cardinalityEstimate, parameters);
                    indexNode.setProperty(PlanNode.Property.INDEX_SPECIFICATION, indexPlan);
                    source.addLastChild(indexNode);
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints, int costEstimate, long cardinalityEstimate) {
                    this.addIndex(name, workspaceName, providerName, constraints, costEstimate, cardinalityEstimate, null);
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints, int costEstimate, long cardinalityEstimate, String parameterName, Object parameterValue) {
                    Map<String, Object> params = Collections.singletonMap(parameterName, parameterValue);
                    this.addIndex(name, workspaceName, providerName, constraints, costEstimate, cardinalityEstimate, params);
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints, int costEstimate, long cardinalityEstimate, String parameterName1, Object parameterValue1, String parameterName2, Object parameterValue2) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put(parameterName1, parameterValue1);
                    params.put(parameterName2, parameterValue2);
                    this.addIndex(name, workspaceName, providerName, constraints, costEstimate, cardinalityEstimate, params);
                }
            };
            assert (source.getSelectors().size() == 1);
            SelectorName selectorName = source.getSelectors().iterator().next();
            this.planners.applyIndexes(context, selectorName, (List)constraints.get(), context.getIndexDefinitions(), collector);
        }
        return plan;
    }
}

