/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import java.util.List;
import javax.jcr.query.qom.Constraint;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.spi.index.IndexCollector;

public abstract class IndexPlanner {
    public abstract void applyIndexes(QueryContext var1, SelectorName var2, List<Constraint> var3, Iterable<IndexDefinition> var4, IndexCollector var5);

    public static IndexPlanner both(final IndexPlanner planner1, final IndexPlanner planner2) {
        if (planner1 == null) {
            return planner2;
        }
        if (planner2 == null) {
            return planner1;
        }
        return new IndexPlanner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void applyIndexes(QueryContext context, SelectorName selector, List<Constraint> andedConstraints, Iterable<IndexDefinition> indexesOnSelector, IndexCollector indexes) {
                RuntimeException error = null;
                try {
                    planner1.applyIndexes(context, selector, andedConstraints, indexesOnSelector, indexes);
                    return;
                }
                catch (RuntimeException e) {
                    error = e;
                }
                finally {
                    try {
                        planner2.applyIndexes(context, selector, andedConstraints, indexesOnSelector, indexes);
                    }
                    catch (RuntimeException e) {
                        if (error == null) {
                            error = e;
                        }
                    }
                    finally {
                        if (error == null) return;
                        throw error;
                    }
                }
            }
        };
    }
}

