/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.LinkedListMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.basic.BasicName;
import org.modeshape.jcr.value.basic.BasicPath;
import org.modeshape.jcr.value.basic.ChildPath;
import org.modeshape.jcr.value.basic.IdentifierPath;
import org.modeshape.jcr.value.basic.JodaDateTime;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.modeshape.jcr.value.basic.RootPath;
import org.modeshape.jcr.value.basic.StringReference;

@Immutable
public enum PropertyType {
    STRING("String", ValueComparators.STRING_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), String.class, 1, new Class[0]),
    BINARY("Binary", ValueComparators.BINARY_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), BinaryValue.class, 2, new Class[0]),
    LONG("Long", ValueComparators.LONG_COMPARATOR, (Canonicalizer)new LongCanonicalizer(), Long.class, 3, Integer.class, Short.class),
    DOUBLE("Double", ValueComparators.DOUBLE_COMPARATOR, (Canonicalizer)new DoubleCanonicalizer(), Double.class, 4, Float.class),
    DECIMAL("Decimal", ValueComparators.DECIMAL_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), BigDecimal.class, 12, new Class[0]),
    DATE("Date", ValueComparators.DATE_TIME_COMPARATOR, (Canonicalizer)new DateCanonicalizer(), DateTime.class, 5, Calendar.class, Date.class),
    BOOLEAN("Boolean", ValueComparators.BOOLEAN_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Boolean.class, 6, new Class[0]),
    NAME("Name", ValueComparators.NAME_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Name.class, 7, BasicName.class),
    PATH("Path", ValueComparators.PATH_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Path.class, 8, BasicPath.class, ChildPath.class, IdentifierPath.class, RootPath.class),
    REFERENCE("Reference", ValueComparators.REFERENCE_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Reference.class, 9, NodeKeyReference.class, StringReference.class),
    WEAKREFERENCE("WeakReference", ValueComparators.REFERENCE_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Reference.class, 10, NodeKeyReference.class, StringReference.class),
    SIMPLEREFERENCE("SimpleReference", ValueComparators.REFERENCE_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Reference.class, 100, NodeKeyReference.class),
    URI("URI", ValueComparators.URI_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), URI.class, 11, new Class[0]),
    OBJECT("Object", ValueComparators.OBJECT_COMPARATOR, (Canonicalizer)new ObjectCanonicalizer(), Object.class, 0, new Class[0]);

    private static final List<PropertyType> ALL_PROPERTY_TYPES;
    private static final Map<String, PropertyType> PROPERTY_TYPE_BY_LOWERCASE_NAME;
    private static final Multimap<Class<?>, PropertyType> PROPERTY_TYPES_BY_INSTANCE_CLASS;
    private final String name;
    private final Comparator<?> comparator;
    private final Canonicalizer canonicalizer;
    private final Class<?> valueClass;
    private final Set<Class<?>> castableValueClasses;
    private final TypeChecker typeChecker;
    private final int jcrType;

    private PropertyType(String name, Comparator<?> comparator, Canonicalizer canonicalizer, Class<?> valueClass, int jcrType, Class<?> ... castableClasses) {
        this(name, comparator, canonicalizer, valueClass, null, jcrType, castableClasses);
    }

    private PropertyType(String name, Comparator<?> comparator, Canonicalizer canonicalizer, Class<?> valueClass, TypeChecker typeChecker, int jcrType, Class<?> ... castableClasses) {
        this.name = name;
        this.comparator = comparator;
        this.canonicalizer = canonicalizer;
        this.valueClass = valueClass;
        this.jcrType = jcrType;
        this.castableValueClasses = castableClasses != null && castableClasses.length != 0 ? Collections.unmodifiableSet(new HashSet(Arrays.asList(castableClasses))) : Collections.emptySet();
        this.typeChecker = typeChecker != null ? typeChecker : new ClassBasedTypeChecker(this.valueClass);
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String getName() {
        return this.name;
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    public Object getCanonicalValue(Object value) {
        return this.canonicalizer.canonicalizeValue(value);
    }

    public final boolean isTypeFor(Object value) {
        if (this.typeChecker.isTypeFor(value)) {
            return true;
        }
        for (Class<?> valueClass : this.castableValueClasses) {
            if (!valueClass.isInstance(value)) continue;
            return true;
        }
        return false;
    }

    public final boolean isTypeFor(Class<?> clazz) {
        for (Class<?> valueClass : this.castableValueClasses) {
            if (!valueClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public final boolean isTypeForEach(Iterable<?> values) {
        for (Object value : values) {
            if (this.isTypeFor(value)) continue;
            return false;
        }
        return true;
    }

    public final boolean isTypeForEach(Iterator<?> values) {
        while (values.hasNext()) {
            Object value = values.next();
            if (this.isTypeFor(value)) continue;
            return false;
        }
        return true;
    }

    public final int jcrType() {
        return this.jcrType;
    }

    public static PropertyType discoverType(Object value) {
        if (value == null) {
            throw new IllegalArgumentException(GraphI18n.unableToDiscoverPropertyTypeForNullValue.text(new Object[0]));
        }
        PropertyType classBasedType = PropertyType.discoverType(value.getClass());
        if (classBasedType != null) {
            if (classBasedType == REFERENCE && value instanceof Reference) {
                Reference ref = (Reference)value;
                if (ref.isSimple()) {
                    return SIMPLEREFERENCE;
                }
                return ref.isWeak() ? WEAKREFERENCE : REFERENCE;
            }
            return classBasedType;
        }
        for (PropertyType type : PropertyType.values()) {
            if (type == OBJECT || !type.isTypeFor(value)) continue;
            return type;
        }
        return OBJECT;
    }

    public static PropertyType discoverType(Class<?> clazz) {
        CheckArg.isNotNull(clazz, (String)"clazz");
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        Collection types = PROPERTY_TYPES_BY_INSTANCE_CLASS.get(clazz);
        int num = types.size();
        if (num == 1) {
            return (PropertyType)((Object)types.iterator().next());
        }
        if (num > 1) {
            for (PropertyType aType : types) {
                if (!aType.isTypeFor(clazz)) continue;
                return aType;
            }
        }
        for (PropertyType aType : PropertyType.values()) {
            if (!aType.isTypeFor(clazz)) continue;
            return aType;
        }
        return null;
    }

    public static Iterator<PropertyType> iterator() {
        return ALL_PROPERTY_TYPES.iterator();
    }

    public static PropertyType valueFor(String typeNameInAnyCase) {
        PropertyType type = PROPERTY_TYPE_BY_LOWERCASE_NAME.get(typeNameInAnyCase);
        return type != null ? type : STRING;
    }

    public static PropertyType valueFor(int jcrPropertyType) {
        switch (jcrPropertyType) {
            case 2: {
                return BINARY;
            }
            case 6: {
                return BOOLEAN;
            }
            case 5: {
                return DATE;
            }
            case 12: {
                return DECIMAL;
            }
            case 4: {
                return DOUBLE;
            }
            case 3: {
                return LONG;
            }
            case 7: {
                return NAME;
            }
            case 8: {
                return PATH;
            }
            case 9: {
                return REFERENCE;
            }
            case 1: {
                return STRING;
            }
            case 11: {
                return URI;
            }
            case 10: {
                return WEAKREFERENCE;
            }
            case 100: {
                return SIMPLEREFERENCE;
            }
        }
        return OBJECT;
    }

    static {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        HashMap<String, PropertyType> byLowerCaseName = new HashMap<String, PropertyType>();
        LinkedListMultimap propTypesByClass = LinkedListMultimap.create();
        for (PropertyType type : PropertyType.values()) {
            types.add(type);
            byLowerCaseName.put(type.getName().toLowerCase(), type);
            for (Class<?> clazz : type.castableValueClasses) {
                propTypesByClass.put(clazz, (Object)type);
            }
            propTypesByClass.put(type.valueClass, (Object)type);
        }
        propTypesByClass.put(Long.TYPE, (Object)LONG);
        propTypesByClass.put(Short.TYPE, (Object)LONG);
        propTypesByClass.put(Integer.TYPE, (Object)LONG);
        propTypesByClass.put(Double.TYPE, (Object)DOUBLE);
        propTypesByClass.put(Float.TYPE, (Object)DOUBLE);
        propTypesByClass.put(Boolean.TYPE, (Object)BOOLEAN);
        byLowerCaseName.put("undefined", OBJECT);
        ALL_PROPERTY_TYPES = Collections.unmodifiableList(types);
        PROPERTY_TYPE_BY_LOWERCASE_NAME = Collections.unmodifiableMap(byLowerCaseName);
        PROPERTY_TYPES_BY_INSTANCE_CLASS = propTypesByClass;
    }

    protected static final class ClassBasedTypeChecker
    implements TypeChecker {
        private final Class<?> valueClass;

        protected ClassBasedTypeChecker(Class<?> valueClass) {
            this.valueClass = valueClass;
            assert (this.valueClass != null);
        }

        @Override
        public boolean isTypeFor(Object value) {
            return this.valueClass.isInstance(value);
        }
    }

    private static interface TypeChecker {
        public boolean isTypeFor(Object var1);
    }

    protected static final class DateCanonicalizer
    implements Canonicalizer {
        protected DateCanonicalizer() {
        }

        @Override
        public Object canonicalizeValue(Object value) {
            if (value instanceof DateTime) {
                return value;
            }
            if (value instanceof Calendar) {
                return new JodaDateTime((Calendar)value);
            }
            if (value instanceof Date) {
                return new JodaDateTime((Date)value);
            }
            return value;
        }
    }

    protected static final class DoubleCanonicalizer
    implements Canonicalizer {
        protected DoubleCanonicalizer() {
        }

        @Override
        public Object canonicalizeValue(Object value) {
            if (value instanceof Float) {
                return new Double(((Float)value).floatValue());
            }
            return value;
        }
    }

    protected static final class LongCanonicalizer
    implements Canonicalizer {
        protected LongCanonicalizer() {
        }

        @Override
        public Object canonicalizeValue(Object value) {
            if (value instanceof Integer) {
                return new Long(((Integer)value).intValue());
            }
            if (value instanceof Short) {
                return new Long(((Short)value).shortValue());
            }
            return value;
        }
    }

    protected static final class ObjectCanonicalizer
    implements Canonicalizer {
        protected ObjectCanonicalizer() {
        }

        @Override
        public Object canonicalizeValue(Object value) {
            return value;
        }
    }

    private static interface Canonicalizer {
        public Object canonicalizeValue(Object var1);
    }
}

