/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.change;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.AbstractNodeChange;
import org.modeshape.jcr.cache.change.AbstractPropertyChange;
import org.modeshape.jcr.cache.change.BinaryValueUnused;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeChanged;
import org.modeshape.jcr.cache.change.NodeMoved;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.NodeRenamed;
import org.modeshape.jcr.cache.change.NodeReordered;
import org.modeshape.jcr.cache.change.NodeSequenced;
import org.modeshape.jcr.cache.change.NodeSequencingFailure;
import org.modeshape.jcr.cache.change.RepositoryMetadataChanged;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

public abstract class ChangeSetAdapter
implements ChangeSetListener {
    protected final ExecutionContext context;
    protected final NodeTypePredicate predicate;

    public ChangeSetAdapter(ExecutionContext context) {
        this(context, null);
    }

    public ChangeSetAdapter(ExecutionContext context, NodeTypePredicate predicate) {
        assert (context != null);
        this.context = context;
        this.predicate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(ChangeSet changeSet) {
        String workspaceName = changeSet.getWorkspaceName();
        if (workspaceName != null) {
            if (this.includesWorkspace(workspaceName)) {
                try {
                    this.beginWorkspaceChanges();
                    HashMap<Name, AbstractPropertyChange> propChanges = new HashMap<Name, AbstractPropertyChange>();
                    NodeKey lastKey = null;
                    for (Change change : changeSet) {
                        AbstractNodeChange anc;
                        if (!(change instanceof AbstractNodeChange) || !this.matchesType((anc = (AbstractNodeChange)change).getPrimaryType(), anc.getMixinTypes())) continue;
                        if (change instanceof NodeAdded) {
                            this.firePropertyChanges(lastKey, propChanges);
                            NodeAdded added = (NodeAdded)change;
                            this.addNode(workspaceName, added.getKey(), added.getPath(), added.getPrimaryType(), added.getMixinTypes(), this.props(added.getProperties()), added.isQueryable());
                        } else if (change instanceof NodeRemoved) {
                            this.firePropertyChanges(lastKey, propChanges);
                            NodeRemoved removed = (NodeRemoved)change;
                            this.removeNode(workspaceName, removed.getKey(), removed.getParentKey(), removed.getPath(), removed.getPrimaryType(), removed.getMixinTypes(), removed.isQueryable());
                        } else if (change instanceof AbstractPropertyChange) {
                            AbstractPropertyChange propChange = (AbstractPropertyChange)change;
                            if (propChange.getKey().equals(lastKey)) {
                                this.firePropertyChanges(lastKey, propChanges);
                            }
                            propChanges.put(propChange.getProperty().getName(), propChange);
                        } else if (change instanceof NodeChanged) {
                            this.firePropertyChanges(lastKey, propChanges);
                            NodeChanged nodeChanged = (NodeChanged)change;
                            this.changeNode(workspaceName, nodeChanged.getKey(), nodeChanged.getPath(), nodeChanged.getPrimaryType(), nodeChanged.getMixinTypes(), nodeChanged.isQueryable());
                        } else if (change instanceof NodeMoved) {
                            this.firePropertyChanges(lastKey, propChanges);
                            NodeMoved moved = (NodeMoved)change;
                            this.moveNode(workspaceName, moved.getKey(), moved.getPrimaryType(), moved.getMixinTypes(), moved.getNewParent(), moved.getOldParent(), moved.getNewPath(), moved.getOldPath(), moved.isQueryable());
                        } else if (change instanceof NodeRenamed) {
                            this.firePropertyChanges(lastKey, propChanges);
                            NodeRenamed renamed = (NodeRenamed)change;
                            this.renameNode(workspaceName, renamed.getKey(), renamed.getPath(), renamed.getOldSegment(), renamed.getPrimaryType(), renamed.getMixinTypes(), renamed.isQueryable());
                        } else if (change instanceof NodeReordered) {
                            this.firePropertyChanges(lastKey, propChanges);
                            NodeReordered reordered = (NodeReordered)change;
                            this.reorderNode(workspaceName, reordered.getKey(), reordered.getPrimaryType(), reordered.getMixinTypes(), reordered.getParent(), reordered.getPath(), reordered.getOldPath(), reordered.getReorderedBeforePath(), reordered.isQueryable());
                        } else if (change instanceof NodeSequenced) {
                            this.firePropertyChanges(lastKey, propChanges);
                            NodeSequenced s = (NodeSequenced)change;
                            this.sequenced(workspaceName, s.getKey(), s.getPath(), s.getPrimaryType(), s.getMixinTypes(), s.getOutputNodeKey(), s.getOutputNodePath(), s.getOutputPath(), s.getUserId(), s.getSelectedPath(), s.getSequencerName(), s.isQueryable());
                        } else if (change instanceof NodeSequencingFailure) {
                            this.firePropertyChanges(lastKey, propChanges);
                            NodeSequencingFailure f = (NodeSequencingFailure)change;
                            this.sequenceFailure(workspaceName, f.getKey(), f.getPath(), f.getPrimaryType(), f.getMixinTypes(), f.getOutputPath(), f.getUserId(), f.getSelectedPath(), f.getSequencerName(), f.isQueryable(), f.getCause());
                        }
                        lastKey = ((AbstractNodeChange)change).getKey();
                    }
                }
                finally {
                    this.completeWorkspaceChanges();
                }
            }
        } else {
            this.beginChanges();
            for (Change change : changeSet) {
                if (change instanceof WorkspaceAdded) {
                    WorkspaceAdded added = (WorkspaceAdded)change;
                    this.addWorkspace(added.getWorkspaceName());
                    continue;
                }
                if (change instanceof WorkspaceRemoved) {
                    WorkspaceRemoved removed = (WorkspaceRemoved)change;
                    this.removeWorkspace(removed.getWorkspaceName());
                    continue;
                }
                if (change instanceof RepositoryMetadataChanged) {
                    this.repositoryMetadataChanged();
                    continue;
                }
                if (!(change instanceof BinaryValueUnused)) continue;
                BinaryValueUnused bvu = (BinaryValueUnused)change;
                this.binaryValueUnused(bvu.getKey());
            }
            this.completeChanges();
        }
    }

    private boolean matchesType(Name primaryType, Set<Name> mixinTypes) {
        return this.predicate == null ? true : this.predicate.matchesType(primaryType, mixinTypes);
    }

    protected void beginWorkspaceChanges() {
    }

    protected void completeWorkspaceChanges() {
    }

    protected void beginChanges() {
    }

    protected void completeChanges() {
    }

    private void firePropertyChanges(NodeKey key, Map<Name, AbstractPropertyChange> propChanges) {
        if (propChanges.isEmpty()) {
            this.modifyProperties(key, propChanges);
            propChanges.clear();
        }
    }

    protected void modifyProperties(NodeKey key, Map<Name, AbstractPropertyChange> propChanges) {
    }

    private final CachedNode.Properties props(final Map<Name, Property> properties) {
        return new CachedNode.Properties(){

            @Override
            public Property getProperty(Name name) {
                return (Property)properties.get(name);
            }

            @Override
            public Iterator<Property> iterator() {
                return properties.values().iterator();
            }
        };
    }

    protected boolean includesWorkspace(String workspaceName) {
        return true;
    }

    protected void addNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
    }

    protected void removeNode(String workspaceName, NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes, boolean queryable) {
    }

    protected void changeNode(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, boolean queryable) {
    }

    protected void moveNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey oldParent, NodeKey newParent, Path newPath, Path oldPath, boolean queryable) {
    }

    protected void renameNode(String workspaceName, NodeKey key, Path newPath, Path.Segment oldSegment, Name primaryType, Set<Name> mixinTypes, boolean queryable) {
    }

    protected void reorderNode(String workspaceName, NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey parent, Path newPath, Path oldPath, Path reorderedBeforePath, boolean queryable) {
    }

    protected void sequenced(String workspaceName, NodeKey sequencedNodeKey, Path sequencedNodePath, Name sequencedNodePrimaryType, Set<Name> sequencedNodeMixinTypes, NodeKey outputNodeKey, Path outputNodePath, String outputPath, String userId, String selectedPath, String sequencerName, boolean queryable) {
    }

    protected void sequenceFailure(String workspaceName, NodeKey sequencedNodeKey, Path sequencedNodePath, Name sequencedNodePrimaryType, Set<Name> sequencedNodeMixinTypes, String outputPath, String userId, String selectedPath, String sequencerName, boolean queryable, Throwable cause) {
    }

    protected void repositoryMetadataChanged() {
    }

    protected void binaryValueUnused(BinaryKey key) {
    }

    protected void addWorkspace(String workspaceName) {
    }

    protected void removeWorkspace(String workspaceName) {
    }

    public static interface NodeTypePredicate {
        public boolean matchesType(Name var1, Set<Name> var2);
    }
}

