/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine;

import java.util.Collections;
import java.util.Map;
import javax.jcr.query.qom.Constraint;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.api.query.qom.NodePath;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.NodeId;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.spi.index.IndexCostCalculator;
import org.modeshape.jcr.spi.index.provider.IndexPlanner;

public abstract class IndexPlanners {
    private static final IndexPlanners IMPLICIT = new IndexPlanners(){

        @Override
        public void applyIndexes(QueryContext context, IndexCostCalculator calculator) {
            StandardIndexPlanner.INSTANCE.applyIndexes(context, calculator);
        }
    };
    protected static final String NODE_BY_PATH_INDEX_NAME = "NodeByPath";
    protected static final String NODE_BY_ID_INDEX_NAME = "NodeById";
    protected static final String CHILDREN_BY_PATH_INDEX_NAME = "ChildrenByPath";
    protected static final String DESCENDANTS_BY_PATH_INDEX_NAME = "DescendantsByPath";
    protected static final String PATH_PARAMETER = "path";
    protected static final String ID_PARAMETER = "id";

    public abstract void applyIndexes(QueryContext var1, IndexCostCalculator var2);

    public static IndexPlanners implicit() {
        return IMPLICIT;
    }

    public static IndexPlanners withProviders(final Map<String, IndexPlanner> plannersByProviderName) {
        return new IndexPlanners(){

            @Override
            public void applyIndexes(QueryContext context, IndexCostCalculator calculator) {
                StandardIndexPlanner.INSTANCE.applyIndexes(context, calculator);
                if (context.getIndexDefinitions().hasIndexDefinitions()) {
                    for (IndexPlanner planner : plannersByProviderName.values()) {
                        planner.applyIndexes(context, calculator);
                    }
                }
            }
        };
    }

    @Immutable
    private static class StandardIndexPlanner
    extends IndexPlanner {
        public static final IndexPlanner INSTANCE = new StandardIndexPlanner();

        private StandardIndexPlanner() {
        }

        @Override
        public void applyIndexes(QueryContext context, IndexCostCalculator calculator) {
            for (Constraint constraint : calculator.andedConstraints()) {
                BindVariableName varName;
                Object value;
                StaticOperand rightSide;
                String path;
                if (constraint instanceof SameNode) {
                    SameNode sameNode = (SameNode)constraint;
                    path = sameNode.getPath();
                    calculator.addIndex(IndexPlanners.NODE_BY_PATH_INDEX_NAME, null, null, Collections.singletonList(constraint), 1, 1L, Float.valueOf(-1.0f), IndexPlanners.PATH_PARAMETER, path);
                    continue;
                }
                if (constraint instanceof ChildNode) {
                    ChildNode childNode = (ChildNode)constraint;
                    path = childNode.getParentPath();
                    calculator.addIndex(IndexPlanners.CHILDREN_BY_PATH_INDEX_NAME, null, null, Collections.singletonList(constraint), 10, 100L, Float.valueOf(-1.0f), IndexPlanners.PATH_PARAMETER, path);
                    continue;
                }
                if (constraint instanceof DescendantNode) {
                    DescendantNode descendantNode = (DescendantNode)constraint;
                    path = descendantNode.getAncestorPath();
                    calculator.addIndex(IndexPlanners.DESCENDANTS_BY_PATH_INDEX_NAME, null, null, Collections.singletonList(constraint), 1000, 10000L, Float.valueOf(-1.0f), IndexPlanners.PATH_PARAMETER, path);
                    continue;
                }
                if (!(constraint instanceof Comparison)) continue;
                Comparison comparison = (Comparison)constraint;
                if (comparison.operator() != Operator.EQUAL_TO) {
                    return;
                }
                DynamicOperand leftSide = comparison.getOperand1();
                if (leftSide instanceof NodePath) {
                    rightSide = comparison.getOperand2();
                    value = null;
                    if (rightSide instanceof BindVariableName) {
                        varName = (BindVariableName)rightSide;
                        value = context.getVariables().get(varName.getBindVariableName());
                    } else if (rightSide instanceof Literal) {
                        value = ((Literal)rightSide).value();
                    }
                    if (value == null) {
                        return;
                    }
                    String path2 = null;
                    if (value instanceof String) {
                        path2 = (String)value;
                    }
                    if (path2 != null) {
                        calculator.addIndex(IndexPlanners.NODE_BY_PATH_INDEX_NAME, null, null, Collections.singletonList(constraint), 1, 1L, Float.valueOf(-1.0f), IndexPlanners.PATH_PARAMETER, path2);
                    }
                }
                if (!(leftSide instanceof NodeId)) continue;
                rightSide = comparison.getOperand2();
                value = null;
                if (rightSide instanceof BindVariableName) {
                    varName = (BindVariableName)rightSide;
                    value = context.getVariables().get(varName.getBindVariableName());
                } else if (rightSide instanceof Literal) {
                    value = ((Literal)rightSide).value();
                }
                if (value == null) {
                    return;
                }
                String id = null;
                if (value instanceof String) {
                    id = (String)value;
                }
                if (id == null) continue;
                calculator.addIndex(IndexPlanners.NODE_BY_ID_INDEX_NAME, null, null, Collections.singletonList(constraint), 1, 1L, Float.valueOf(-1.0f), IndexPlanners.ID_PARAMETER, id);
            }
        }
    }
}

