/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.engine.process.BufferedRows;
import org.modeshape.jcr.query.engine.process.CountableSequence;

public class PartialMemoryCountableSequence
extends CountableSequence {
    private final Queue<NodeSequence.Batch> inMemoryBatches = new LinkedList<NodeSequence.Batch>();
    private final int approxRowsInMemory;

    public PartialMemoryCountableSequence(String workspaceName, NodeSequence original, BufferManager bufferMgr, CachedNodeSupplier nodeCache, int numRowsInMemory) {
        super(workspaceName, original, bufferMgr, nodeCache, true);
        this.approxRowsInMemory = numRowsInMemory;
    }

    @Override
    protected NodeSequence.Batch doNextBatch() {
        if (!this.inMemoryBatches.isEmpty()) {
            return this.inMemoryBatches.poll();
        }
        return super.doNextBatch();
    }

    @Override
    protected long loadAll(NodeSequence sequence, BufferManager.QueueBuffer<BufferedRows.BufferedRow> buffer, AtomicLong batchSize) {
        return this.loadAll(sequence, buffer, batchSize, this.inMemoryBatches, this.approxRowsInMemory);
    }
}

