/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class Comparison
implements Constraint,
javax.jcr.query.qom.Comparison {
    private static final long serialVersionUID = 1L;
    private final DynamicOperand operand1;
    private final StaticOperand operand2;
    private final Operator operator;
    private final int hc;

    public Comparison(DynamicOperand operand1, Operator operator, StaticOperand operand2) {
        CheckArg.isNotNull((Object)operand1, (String)"operand1");
        CheckArg.isNotNull((Object)operator, (String)"operator");
        CheckArg.isNotNull((Object)operand2, (String)"operand2");
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.operator = operator;
        this.hc = HashCode.compute((Object[])new Object[]{this.operand1, this.operand2, this.operator});
    }

    public DynamicOperand getOperand1() {
        return this.operand1;
    }

    public StaticOperand getOperand2() {
        return this.operand2;
    }

    public final Operator operator() {
        return this.operator;
    }

    public String getOperator() {
        switch (this.operator()) {
            case EQUAL_TO: {
                return "jcr.operator.equal.to";
            }
            case GREATER_THAN: {
                return "jcr.operator.greater.than";
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return "jcr.operator.greater.than.or.equal.to";
            }
            case LESS_THAN: {
                return "jcr.operator.less.than";
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return "jcr.operator.less.than.or.equal.to";
            }
            case LIKE: {
                return "jcr.operator.like";
            }
            case NOT_EQUAL_TO: {
                return "jcr.operator.not.equal.to";
            }
        }
        assert (false);
        return null;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Comparison) {
            Comparison that = (Comparison)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.operator.equals((Object)that.operator)) {
                return false;
            }
            if (!this.operand1.equals(that.operand1)) {
                return false;
            }
            return this.operand2.equals(that.operand2);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

