/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.validate;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Collections;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.PropertyType;

@Immutable
public class ImmutableColumn
implements Schemata.Column {
    public static final Set<Operator> ALL_OPERATORS = Collections.unmodifiableSet(EnumSet.allOf(Operator.class));
    public static final Set<Operator> NO_OPERATORS = Collections.unmodifiableSet(EnumSet.noneOf(Operator.class));
    public static final PropertyType DEFAULT_REQUIRED_TYPE = PropertyType.STRING;
    public static final boolean DEFAULT_FULL_TEXT_SEARCHABLE = false;
    public static final boolean DEFAULT_ORDERABLE = true;
    private final boolean fullTextSearchable;
    private final boolean orderable;
    private final boolean comparable;
    private final String name;
    private final String typeName;
    private final PropertyType requiredType;
    private final Set<Operator> operators;
    private final Object minimumValue;
    private final Object maximumValue;

    protected ImmutableColumn(String name, String type, PropertyType requiredType) {
        this(name, type, requiredType, false, true, null, null, ALL_OPERATORS);
    }

    protected ImmutableColumn(String name, String type) {
        this(name, type, DEFAULT_REQUIRED_TYPE, false, true, null, null, ALL_OPERATORS);
    }

    protected ImmutableColumn(String name, String type, PropertyType requiredType, boolean fullTextSearchable) {
        this(name, type, requiredType, fullTextSearchable, true, null, null, ALL_OPERATORS);
    }

    protected ImmutableColumn(String name, String type, PropertyType requiredType, boolean fullTextSearchable, boolean orderable, boolean canContainReferences, Object minimum, Object maximum, Operator ... operators) {
        this(name, type, requiredType, fullTextSearchable, orderable, minimum, maximum, operators != null && operators.length != 0 ? EnumSet.copyOf(Arrays.asList(operators)) : null);
    }

    protected ImmutableColumn(String name, String type, PropertyType requiredType, boolean fullTextSearchable, boolean orderable, Object minimum, Object maximum, Set<Operator> operators) {
        this.name = name;
        this.typeName = type;
        this.requiredType = requiredType;
        this.fullTextSearchable = fullTextSearchable;
        this.orderable = orderable;
        this.operators = operators == null || operators.isEmpty() ? ALL_OPERATORS : Collections.unmodifiableSet(EnumSet.copyOf(operators));
        this.minimumValue = minimum;
        this.maximumValue = maximum;
        if (this.operators.isEmpty()) {
            this.comparable = false;
        } else {
            boolean comparable;
            boolean bl = comparable = this.requiredType == PropertyType.STRING;
            if (!comparable) {
                for (Operator operator : this.operators) {
                    if (operator != Operator.GREATER_THAN && operator != Operator.GREATER_THAN_OR_EQUAL_TO && operator != Operator.LESS_THAN && operator != Operator.LESS_THAN_OR_EQUAL_TO) continue;
                    comparable = true;
                    break;
                }
            }
            this.comparable = comparable;
        }
        assert (this.name != null);
        assert (this.typeName != null);
        assert (this.operators != null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPropertyTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isFullTextSearchable() {
        return this.fullTextSearchable;
    }

    @Override
    public boolean isOrderable() {
        return this.orderable;
    }

    @Override
    public boolean isComparable() {
        return this.comparable;
    }

    @Override
    public Object getMinimum() {
        return this.minimumValue;
    }

    @Override
    public Object getMaximum() {
        return this.maximumValue;
    }

    @Override
    public PropertyType getRequiredType() {
        return this.requiredType;
    }

    @Override
    public Set<Operator> getOperators() {
        return this.operators;
    }

    public String toString() {
        return this.name + "(" + this.typeName + ")";
    }
}

