/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.Database;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.modeshape.jcr.value.binary.StoredBinaryValue;
import org.modeshape.jcr.value.binary.TransientBinaryStore;

@ThreadSafe
public class DatabaseBinaryStore
extends AbstractBinaryStore {
    private static final boolean ALIVE = true;
    private static final boolean UNUSED = false;
    private final String driverClass;
    private final String connectionURL;
    private final String username;
    private final String password;
    private final String datasourceJNDILocation;
    private DataSource dataSource;
    private final FileSystemBinaryStore cache;
    private Database database;

    public DatabaseBinaryStore(String driverClass, String connectionURL, String username, String password) {
        this.driverClass = driverClass;
        this.connectionURL = connectionURL;
        this.username = username;
        this.password = password;
        this.datasourceJNDILocation = null;
        this.cache = TransientBinaryStore.get();
    }

    public DatabaseBinaryStore(String datasourceJNDILocation) {
        this.driverClass = null;
        this.connectionURL = null;
        this.username = null;
        this.password = null;
        this.datasourceJNDILocation = datasourceJNDILocation;
        this.cache = TransientBinaryStore.get();
    }

    @Override
    public void start() {
        super.start();
        if (!StringUtil.isBlank((String)this.datasourceJNDILocation)) {
            this.lookupDataSource();
        } else {
            this.lookupDriver();
        }
        this.database();
    }

    protected Database database() {
        if (this.database == null) {
            Connection connection = this.newConnection();
            try {
                this.database = new Database(connection);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                Database.tryToClose(connection);
            }
        }
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryValue storeValue(InputStream stream, final boolean markAsUnused) throws BinaryStoreException {
        final BinaryValue temp = this.cache.storeValue(stream, markAsUnused);
        try {
            BinaryValue binaryValue = this.dbCall(new DBCallable<BinaryValue>(){

                @Override
                public BinaryValue execute(Connection connection) throws Exception {
                    BinaryKey key = new BinaryKey(temp.getKey().toString());
                    Database database = DatabaseBinaryStore.this.database();
                    if (database.contentExists(key, true, connection)) {
                        return new StoredBinaryValue(DatabaseBinaryStore.this, key, temp.getSize());
                    }
                    if (database.contentExists(key, false, connection)) {
                        if (!markAsUnused) {
                            database.restoreContent(connection, Arrays.asList(key));
                        }
                    } else {
                        database.insertContent(key, temp.getStream(), temp.getSize(), connection);
                        if (markAsUnused) {
                            database.markUnused(Arrays.asList(key), connection);
                        }
                    }
                    return new StoredBinaryValue(DatabaseBinaryStore.this, key, temp.getSize());
                }
            });
            return binaryValue;
        }
        finally {
            this.cache.markAsUnused(temp.getKey());
        }
    }

    @Override
    public InputStream getInputStream(BinaryKey key) throws BinaryStoreException {
        Connection connection = this.newConnection();
        try {
            InputStream inputStream = this.database.readContent(key, connection);
            if (inputStream == null) {
                throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, this.database.getTableName()}));
            }
            return inputStream;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void markAsUsed(final Iterable<BinaryKey> keys) throws BinaryStoreException {
        this.dbCall(new DBCallable<Object>(){

            @Override
            public Object execute(Connection connection) throws Exception {
                DatabaseBinaryStore.this.database.restoreContent(connection, keys);
                return null;
            }
        });
    }

    @Override
    public void markAsUnused(final Iterable<BinaryKey> keys) throws BinaryStoreException {
        this.dbCall(new DBCallable<Void>(){

            @Override
            public Void execute(Connection connection) throws Exception {
                DatabaseBinaryStore.this.database().markUnused(keys, connection);
                return null;
            }
        });
    }

    @Override
    public void removeValuesUnusedLongerThan(final long minimumAge, final TimeUnit unit) throws BinaryStoreException {
        this.dbCall(new DBCallable<Void>(){

            @Override
            public Void execute(Connection connection) throws Exception {
                long deadline = System.currentTimeMillis() - unit.toMillis(minimumAge);
                DatabaseBinaryStore.this.database().removeExpiredContent(deadline, connection);
                return null;
            }
        });
    }

    @Override
    protected String getStoredMimeType(final BinaryValue source) throws BinaryStoreException {
        return this.dbCall(new DBCallable<String>(){

            @Override
            public String execute(Connection connection) throws Exception {
                BinaryKey key = source.getKey();
                if (!DatabaseBinaryStore.this.database().contentExists(key, true, connection) && !DatabaseBinaryStore.this.database().contentExists(key, false, connection)) {
                    throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, DatabaseBinaryStore.this.database().getTableName()}));
                }
                return DatabaseBinaryStore.this.database().getMimeType(key, connection);
            }
        });
    }

    @Override
    protected void storeMimeType(final BinaryValue source, final String mimeType) throws BinaryStoreException {
        this.dbCall(new DBCallable<Void>(){

            @Override
            public Void execute(Connection connection) throws Exception {
                DatabaseBinaryStore.this.database().setMimeType(source.getKey(), mimeType, connection);
                return null;
            }
        });
    }

    @Override
    public String getExtractedText(final BinaryValue source) throws BinaryStoreException {
        return this.dbCall(new DBCallable<String>(){

            @Override
            public String execute(Connection connection) throws Exception {
                BinaryKey key = source.getKey();
                if (!DatabaseBinaryStore.this.database().contentExists(key, true, connection)) {
                    throw new BinaryStoreException(JcrI18n.unableToFindBinaryValue.text(new Object[]{key, DatabaseBinaryStore.this.database().getTableName()}));
                }
                return DatabaseBinaryStore.this.database().getExtractedText(key, connection);
            }
        });
    }

    @Override
    public void storeExtractedText(final BinaryValue source, final String extractedText) throws BinaryStoreException {
        this.dbCall(new DBCallable<Void>(){

            @Override
            public Void execute(Connection connection) throws Exception {
                DatabaseBinaryStore.this.database().setExtractedText(source.getKey(), extractedText, connection);
                return null;
            }
        });
    }

    @Override
    public Iterable<BinaryKey> getAllBinaryKeys() throws BinaryStoreException {
        return this.dbCall(new DBCallable<Iterable<BinaryKey>>(){

            @Override
            public Iterable<BinaryKey> execute(Connection connection) throws Exception {
                return DatabaseBinaryStore.this.database().getBinaryKeys(connection);
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    private Connection newConnection() {
        try {
            return this.dataSource != null ? this.dataSource.getConnection() : DriverManager.getConnection(this.connectionURL, this.username, this.password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void lookupDataSource() {
        try {
            InitialContext context = new InitialContext();
            this.dataSource = (DataSource)context.lookup(this.datasourceJNDILocation);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private void lookupDriver() {
        try {
            Class.forName(this.driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T dbCall(DBCallable<T> callable) throws BinaryStoreException {
        Connection connection = this.newConnection();
        try {
            T t = callable.execute(connection);
            return t;
        }
        catch (BinaryStoreException bse) {
            throw bse;
        }
        catch (Exception e) {
            throw new BinaryStoreException(e);
        }
        finally {
            Database.tryToClose(connection);
        }
    }

    private static interface DBCallable<T> {
        public T execute(Connection var1) throws Exception;
    }
}

