/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.StaticOperand;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.api.query.qom.SetCriteria;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.engine.IndexPlan;
import org.modeshape.jcr.query.engine.IndexPlanners;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.spi.index.IndexCostCalculator;
import org.modeshape.jcr.value.StringFactory;

@Immutable
public class AddIndexes
implements OptimizerRule {
    private static final AddIndexes IMPLICIT_INDEXES = new AddIndexes(null);
    private final IndexPlanners planners;

    public static AddIndexes implicitIndexes() {
        return IMPLICIT_INDEXES;
    }

    public static AddIndexes with(IndexPlanners planners) {
        return new AddIndexes(planners);
    }

    protected AddIndexes(IndexPlanners planner) {
        this.planners = planner != null ? planner : IndexPlanners.implicit();
    }

    @Override
    public PlanNode execute(final QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode source : plan.findAllAtOrBelow(PlanNode.Type.SOURCE)) {
            assert (source.getSelectors().size() == 1);
            final SelectorName selectorName = source.getSelectors().iterator().next();
            final LinkedList constraints = new LinkedList();
            final LinkedList joinConditions = new LinkedList();
            final HashSet<String> nodeTypeNames = new HashSet<String>();
            source.applyToAncestors(new PlanNode.Operation(){

                @Override
                public void apply(PlanNode node) {
                    block6: {
                        block5: {
                            SetCriteria criteria;
                            Constraint constraint;
                            block7: {
                                if (node.getType() != PlanNode.Type.SELECT) break block5;
                                constraint = node.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                                if (constraint == null) break block6;
                                constraints.add(constraint);
                                if (!nodeTypeNames.isEmpty()) break block6;
                                if (!(constraint instanceof Comparison)) break block7;
                                Comparison comparison = (Comparison)constraint;
                                if (!this.isPrimaryTypeConstraint(comparison.getOperand1())) break block6;
                                this.addLiteral(comparison.getOperand2(), nodeTypeNames);
                                break block6;
                            }
                            if (!(constraint instanceof SetCriteria) || !this.isPrimaryTypeConstraint((criteria = (SetCriteria)constraint).getOperand())) break block6;
                            for (StaticOperand operand : criteria.getValues()) {
                                this.addLiteral(operand, nodeTypeNames);
                            }
                            break block6;
                        }
                        if (node.getType() == PlanNode.Type.JOIN) {
                            List<Constraint> joinConstraints;
                            JoinCondition joinCondition = node.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
                            if (joinCondition != null) {
                                joinConditions.add(joinCondition);
                            }
                            if ((joinConstraints = node.getPropertyAsList(PlanNode.Property.JOIN_CONSTRAINTS, Constraint.class)) != null) {
                                for (Constraint joinConstraint : joinConstraints) {
                                    constraints.add(joinConstraint);
                                }
                            }
                        }
                    }
                }

                private boolean isPrimaryTypeConstraint(DynamicOperand operand) {
                    PropertyValue propValue;
                    if (operand instanceof PropertyValue && (propValue = (PropertyValue)operand).getSelectorName().equals(selectorName.getString())) {
                        String propName = propValue.getPropertyName();
                        return "jcr:primaryType".equals(propName) || "jcr:mixinTypes".equals(propName);
                    }
                    return false;
                }

                private void addLiteral(StaticOperand operand, Set<String> collector) {
                    if (operand instanceof Literal) {
                        Literal literal = (Literal)operand;
                        StringFactory strings = context.getExecutionContext().getValueFactories().getStringFactory();
                        nodeTypeNames.add(strings.create(literal.value()));
                    }
                }
            });
            if (constraints.isEmpty() && joinConditions.isEmpty()) continue;
            nodeTypeNames.add(selectorName.getString());
            final LinkedList indexPlans = new LinkedList();
            IndexCostCalculator calculator = new IndexCostCalculator(){

                @Override
                public Set<String> selectedNodeTypes() {
                    return nodeTypeNames;
                }

                @Override
                public Collection<Constraint> andedConstraints() {
                    return constraints;
                }

                @Override
                public Collection<JoinCondition> joinConditions() {
                    return joinConditions;
                }

                @Override
                public Map<String, Object> getVariables() {
                    return context.getVariables();
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<JoinCondition> joinConditions2, int costEstimate, long cardinalityEstimate) {
                    IndexPlan indexPlan = new IndexPlan(name, workspaceName, providerName, null, joinConditions2, costEstimate, cardinalityEstimate, 1.0f, null);
                    indexPlans.add(indexPlan);
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints2, int costEstimate, long cardinalityEstimate, Float selectivityEstimate, Map<String, Object> parameters) {
                    IndexPlan indexPlan = new IndexPlan(name, workspaceName, providerName, constraints2, null, costEstimate, cardinalityEstimate, selectivityEstimate.floatValue(), parameters);
                    indexPlans.add(indexPlan);
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints2, int costEstimate, long cardinalityEstimate, Float selectivityEstimate) {
                    this.addIndex(name, workspaceName, providerName, constraints2, costEstimate, cardinalityEstimate, selectivityEstimate, null);
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints2, int costEstimate, long cardinalityEstimate, Float selectivityEstimate, String parameterName, Object parameterValue) {
                    Map<String, Object> params = Collections.singletonMap(parameterName, parameterValue);
                    this.addIndex(name, workspaceName, providerName, constraints2, costEstimate, cardinalityEstimate, selectivityEstimate, params);
                }

                @Override
                public void addIndex(String name, String workspaceName, String providerName, Collection<Constraint> constraints2, int costEstimate, long cardinalityEstimate, Float selectivityEstimate, String parameterName1, Object parameterValue1, String parameterName2, Object parameterValue2) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put(parameterName1, parameterValue1);
                    params.put(parameterName2, parameterValue2);
                    this.addIndex(name, workspaceName, providerName, constraints2, costEstimate, cardinalityEstimate, selectivityEstimate, params);
                }
            };
            this.planners.applyIndexes(context, calculator);
            if (indexPlans.isEmpty()) continue;
            Collections.sort(indexPlans);
            for (IndexPlan indexPlan : indexPlans) {
                PlanNode indexNode = new PlanNode(PlanNode.Type.INDEX, source.getSelectors());
                indexNode.setProperty(PlanNode.Property.INDEX_SPECIFICATION, indexPlan);
                source.addLastChild(indexNode);
            }
        }
        return plan;
    }
}

