/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import java.util.Set;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.value.Name;

@ThreadSafe
public abstract class NodeTypeMatcher
implements ChangeSetAdapter.NodeTypePredicate {
    public static NodeTypeMatcher create(Set<Name> nodeTypeNames, NodeTypes nodeTypes) {
        ChangeSetAdapter.NodeTypePredicate delegate = null;
        delegate = nodeTypeNames == null || nodeTypeNames.isEmpty() ? MatchNonePredicate.INSTANCE : (nodeTypeNames.contains(JcrNtLexicon.BASE) ? NtBaseMatchPredicate.INSTANCE : new NodeTypeSetMatcher(nodeTypeNames));
        return new MutableNodeTypeMatcher(delegate, nodeTypes);
    }

    public abstract void use(ChangeSetAdapter.NodeTypePredicate var1);

    private static final class MatchNonePredicate
    implements ChangeSetAdapter.NodeTypePredicate {
        protected static final MatchNonePredicate INSTANCE = new MatchNonePredicate();

        private MatchNonePredicate() {
        }

        @Override
        public boolean matchesType(Name primaryType, Set<Name> mixinTypes) {
            return false;
        }

        public String toString() {
            return "<MatchNone>";
        }
    }

    private static final class NtBaseMatchPredicate
    implements ChangeSetAdapter.NodeTypePredicate {
        protected static final NtBaseMatchPredicate INSTANCE = new NtBaseMatchPredicate();

        private NtBaseMatchPredicate() {
        }

        @Override
        public boolean matchesType(Name primaryType, Set<Name> mixinTypes) {
            return true;
        }

        public String toString() {
            return "<MatchAll>";
        }
    }

    private static final class NodeTypeSetMatcher
    implements ChangeSetAdapter.NodeTypePredicate {
        private final Set<Name> allNodeTypes;

        protected NodeTypeSetMatcher(Set<Name> allNodeTypes) {
            this.allNodeTypes = allNodeTypes;
        }

        @Override
        public boolean matchesType(Name primaryType, Set<Name> mixinTypes) {
            if (this.allNodeTypes.contains(primaryType)) {
                return true;
            }
            if (mixinTypes != null) {
                for (Name mixinType : mixinTypes) {
                    if (!this.allNodeTypes.contains(mixinType)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "<Match=" + this.allNodeTypes + ">";
        }
    }

    private static final class MutableNodeTypeMatcher
    extends NodeTypeMatcher {
        private volatile ChangeSetAdapter.NodeTypePredicate delegate;
        private final NodeTypes nodeTypes;

        protected MutableNodeTypeMatcher(ChangeSetAdapter.NodeTypePredicate delegate, NodeTypes nodeTypes) {
            this.delegate = delegate;
            this.nodeTypes = nodeTypes;
        }

        @Override
        public boolean matchesType(Name primaryType, Set<Name> mixinTypes) {
            return this.delegate.matchesType(primaryType, mixinTypes) && this.nodeTypes.isQueryable(primaryType);
        }

        @Override
        public void use(ChangeSetAdapter.NodeTypePredicate other) {
            if (other instanceof MatchNonePredicate) {
                this.delegate = MatchNonePredicate.INSTANCE;
            } else if (other instanceof NtBaseMatchPredicate) {
                this.delegate = NtBaseMatchPredicate.INSTANCE;
            }
            assert (other instanceof MutableNodeTypeMatcher);
            this.delegate = ((MutableNodeTypeMatcher)other).delegate;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

