/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.bus;

import org.modeshape.common.collection.ring.SingleProducerCursor;
import org.modeshape.common.collection.ring.WaitStrategy;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.api.monitor.ValueMetric;

public final class RepositoryCursor
extends SingleProducerCursor {
    private final RepositoryStatistics statistics;

    protected RepositoryCursor(int bufferSize, WaitStrategy waitStrategy, RepositoryStatistics statistics) {
        super(bufferSize, waitStrategy);
        this.statistics = statistics;
    }

    public boolean publish(long position) {
        boolean result = super.publish(position);
        if (result && this.statistics != null) {
            long stillToBeProcessedBySlowestConsumer;
            long positionOfSlowestConsumer = super.positionOfSlowestConsumer();
            int bufferSize = this.getBufferSize();
            long l = stillToBeProcessedBySlowestConsumer = positionOfSlowestConsumer > position ? (long)bufferSize - positionOfSlowestConsumer + position : position - positionOfSlowestConsumer;
            assert (stillToBeProcessedBySlowestConsumer >= 0L);
            this.statistics.set(ValueMetric.EVENT_QUEUE_SIZE, stillToBeProcessedBySlowestConsumer);
            long availablePositions = (long)bufferSize - stillToBeProcessedBySlowestConsumer;
            assert (availablePositions >= 0L);
            this.statistics.set(ValueMetric.EVENT_BUFFER_AVAILABILITY, availablePositions);
        }
        return result;
    }
}

