/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine;

import org.modeshape.common.collection.ImmutableProblems;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.engine.ScanningQueryEngine;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.TypeSystem;

public class Results
implements QueryResults {
    public static final Results EMPTY = new Results();
    private static final Problems NO_PROBLEMS = new ImmutableProblems((Problems)new SimpleProblems());
    private final Problems problems;
    private final QueryResults.Columns columns;
    private final NodeSequence rows;
    private final QueryResults.Statistics statistics;
    private final String plan;
    private final CachedNodeSupplier cachedNodes;

    private Results() {
        this.problems = NO_PROBLEMS;
        this.columns = ScanningQueryEngine.ResultColumns.EMPTY;
        this.statistics = new QueryResults.Statistics();
        this.plan = null;
        this.rows = NodeSequence.emptySequence(0);
        this.cachedNodes = null;
    }

    public Results(QueryResults.Columns columns, QueryResults.Statistics statistics, NodeSequence rows, CachedNodeSupplier cachedNodes, Problems problems, String plan) {
        assert (columns != null);
        assert (statistics != null);
        assert (rows != null);
        assert (cachedNodes != null);
        this.problems = problems != null ? problems : NO_PROBLEMS;
        this.columns = columns;
        this.statistics = statistics;
        this.plan = plan;
        this.rows = rows;
        this.cachedNodes = cachedNodes;
    }

    @Override
    public CachedNodeSupplier getCachedNodes() {
        return this.cachedNodes;
    }

    @Override
    public QueryResults.Columns getColumns() {
        return this.columns;
    }

    @Override
    public NodeSequence getRows() {
        return this.rows;
    }

    @Override
    public long getRowCount() {
        return this.rows.getRowCount();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public String getPlan() {
        return this.plan;
    }

    @Override
    public Problems getProblems() {
        return this.problems;
    }

    @Override
    public boolean hasErrors() {
        return this.problems.hasErrors();
    }

    @Override
    public boolean hasWarnings() {
        return this.problems.hasWarnings();
    }

    @Override
    public QueryResults.Statistics getStatistics() {
        return this.statistics;
    }

    public String toString() {
        return this.toString(null, Integer.MAX_VALUE);
    }

    public String toString(TypeSystem typeSystem, int maxTuples) {
        StringBuilder sb = new StringBuilder();
        this.toString(typeSystem, sb, maxTuples);
        return sb.toString();
    }

    public void toString(TypeSystem typeSystem, StringBuilder sb) {
        this.toString(typeSystem, sb, Integer.MAX_VALUE);
    }

    public void toString(TypeSystem typeSystem, StringBuilder sb, int maxTuples) {
        sb.append("Result columns: \n");
        for (Column column : this.columns) {
            sb.append(" ").append(column).append('\n');
        }
    }
}

