/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.ImmediateFuture;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryIndexManager;
import org.modeshape.jcr.RepositoryIndexes;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.index.IndexManager;
import org.modeshape.jcr.api.query.QueryCancelledException;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.journal.ChangeJournal;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.CancellableQuery;
import org.modeshape.jcr.query.CompositeIndexWriter;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryEngine;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.engine.IndexQueryEngine;
import org.modeshape.jcr.query.engine.ScanningQueryEngine;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.spi.index.IndexWriter;
import org.modeshape.jcr.spi.index.provider.IndexProvider;
import org.modeshape.jcr.spi.index.provider.ManagedIndex;
import org.modeshape.jcr.value.Path;

class RepositoryQueryManager
implements ChangeSetListener {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final Logger indexLogger = Logger.getLogger((String)(this.getClass().getPackage().getName() + ".index"));
    private final JcrRepository.RunningState runningState;
    private final ExecutorService indexingExecutorService;
    private final RepositoryConfiguration repoConfig;
    private final RepositoryConfiguration.Reindexing reindexingCfg;
    private final RepositoryIndexManager indexManager;
    private final Lock engineInitLock = new ReentrantLock();
    private volatile QueryEngine queryEngine;
    private volatile Future<Void> asyncReindexingResult;
    private volatile RepositoryIndexManager.ScanningTasks toBeScanned = new RepositoryIndexManager.ScanningTasks();
    private final AtomicBoolean started = new AtomicBoolean(false);

    RepositoryQueryManager(JcrRepository.RunningState runningState, ExecutorService indexingExecutorService, RepositoryConfiguration config, RepositoryConfiguration.Reindexing reindexingCfg) {
        this.runningState = runningState;
        this.indexingExecutorService = indexingExecutorService;
        this.repoConfig = config;
        this.reindexingCfg = reindexingCfg;
        this.indexManager = new RepositoryIndexManager(runningState, config);
    }

    synchronized void initialize() {
        this.toBeScanned.add(this.indexManager.initialize());
        this.started.set(true);
    }

    @Override
    public synchronized void notify(ChangeSet changeSet) {
        boolean scanRequired;
        if (this.started.get() && (scanRequired = this.toBeScanned.add(this.indexManager.notify(changeSet)))) {
            this.indexManager.refreshIndexWriter();
            this.reindexIfNeeded(this.reindexingCfg.isAsync(), false);
        }
    }

    ChangeSetListener getListener() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        block7: {
            this.started.compareAndSet(true, false);
            this.indexingExecutorService.shutdown();
            if (this.queryEngine != null) {
                try {
                    this.engineInitLock.lock();
                    if (this.queryEngine == null) break block7;
                    try {
                        this.queryEngine.shutdown();
                    }
                    finally {
                        this.queryEngine = null;
                    }
                }
                finally {
                    this.engineInitLock.unlock();
                }
            }
        }
        this.indexManager.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopReindexing() {
        try {
            this.engineInitLock.lock();
            if (this.asyncReindexingResult != null) {
                try {
                    this.asyncReindexingResult.get(1L, TimeUnit.MINUTES);
                }
                catch (TimeoutException e) {
                    this.logger.debug("Re-indexing has not finished in time, attempting to cancel operation", new Object[0]);
                    this.asyncReindexingResult.cancel(true);
                }
                catch (Exception e) {
                    this.logger.debug((Throwable)e, "Unexpected exception while waiting for re-indexing to terminate", new Object[0]);
                }
            }
        }
        finally {
            this.asyncReindexingResult = null;
            this.engineInitLock.unlock();
        }
    }

    public CancellableQuery query(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Map<String, NodeCache> overriddenNodeCachesByWorkspaceName, org.modeshape.jcr.api.query.qom.QueryCommand query, Schemata schemata, RepositoryIndexes indexDefns, NodeTypes nodeTypes, PlanHints hints, Map<String, Object> variables) {
        final QueryEngine queryEngine = this.queryEngine();
        final QueryContext queryContext = queryEngine.createQueryContext(context, repositoryCache, workspaceNames, overriddenNodeCachesByWorkspaceName, schemata, indexDefns, nodeTypes, new BufferManager(context), hints, variables);
        final QueryCommand command = (QueryCommand)query;
        return new CancellableQuery(){
            private final Lock lock = new ReentrantLock();
            private QueryResults results;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public QueryResults execute() throws QueryCancelledException, RepositoryException {
                try {
                    this.lock.lock();
                    if (this.results == null) {
                        this.results = queryEngine.execute(queryContext, command);
                    }
                    QueryResults queryResults = this.results;
                    return queryResults;
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public boolean cancel() {
                return queryContext.cancel();
            }
        };
    }

    public IndexWriter getIndexWriter() {
        return this.indexManager.getIndexWriter();
    }

    protected RepositoryIndexManager getIndexManager() {
        return this.indexManager;
    }

    RepositoryIndexes getIndexes() {
        return this.indexManager.getIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final QueryEngine queryEngine() {
        if (this.queryEngine == null) {
            try {
                this.engineInitLock.lock();
                if (this.queryEngine == null) {
                    ScanningQueryEngine.Builder builder = null;
                    if (!this.repoConfig.getIndexProviders().isEmpty()) {
                        builder = IndexQueryEngine.builder();
                        this.logger.debug("Queries with indexes are enabled for the '{0}' repository. Executing queries may require scanning the repository contents when the query cannot use the defined indexes.", new Object[]{this.repoConfig.getName()});
                    } else {
                        builder = ScanningQueryEngine.builder();
                        this.logger.debug("Queries with no indexes are enabled for the '{0}' repository. Executing queries will always scan the repository contents.", new Object[]{this.repoConfig.getName()});
                    }
                    this.queryEngine = builder.using(this.repoConfig, this.indexManager, this.runningState.context()).build();
                }
            }
            finally {
                this.engineInitLock.unlock();
            }
        }
        return this.queryEngine;
    }

    protected void reindex() {
        if (!this.indexManager.hasProviders()) {
            return;
        }
        boolean async = this.reindexingCfg.isAsync();
        RepositoryConfiguration.ReindexingMode mode = this.reindexingCfg.mode();
        switch (mode) {
            case INCREMENTAL: {
                final ChangeJournal journal = this.runningState.journal();
                if (journal == null) {
                    this.logger.warn((I18nResource)JcrI18n.warnIncrementalIndexingJournalNotEnabled, new Object[]{this.repoConfig.getName()});
                    break;
                }
                if (!journal.started()) {
                    this.logger.warn((I18nResource)JcrI18n.warnIncrementalIndexingJournalNotStarted, new Object[]{this.repoConfig.getName()});
                    break;
                }
                if (!async) {
                    this.reindexIncrementally(journal);
                    break;
                }
                this.indexingExecutorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        RepositoryQueryManager.this.reindexIncrementally(journal);
                        return null;
                    }
                });
                break;
            }
            case IF_MISSING: {
                this.reindexIfNeeded(async, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown indexing mode: " + mode.toString());
            }
        }
    }

    private void reindexIncrementally(ChangeJournal journal) {
        long earliestTimestamp = Long.MAX_VALUE;
        ArrayList<IndexProvider> incrementalIndexingProviders = new ArrayList<IndexProvider>();
        for (IndexProvider provider : this.indexManager.getProviders()) {
            Long latestIndexUpdateTime = provider.getLatestIndexUpdateTime();
            if (latestIndexUpdateTime == null) {
                this.logger.warn((I18nResource)JcrI18n.warnIncrementalIndexingNotSupported, new Object[]{provider.getName()});
                continue;
            }
            incrementalIndexingProviders.add(provider);
            earliestTimestamp = Math.min(earliestTimestamp, latestIndexUpdateTime);
        }
        if (incrementalIndexingProviders.isEmpty()) {
            return;
        }
        assert (earliestTimestamp != Long.MAX_VALUE);
        Iterator<NodeKey> changedNodes = journal.changedNodesSince(earliestTimestamp);
        IndexWriter writer = CompositeIndexWriter.create(incrementalIndexingProviders);
        RepositoryCache repositoryCache = this.runningState.repositoryCache();
        for (String workspaceName : repositoryCache.getWorkspaceNames()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Performing incremental reindexing since '{0}' for repository '{1}' on workspace '{2}'", new Object[]{new Date(earliestTimestamp), repositoryCache.getName(), workspaceName});
            }
            WorkspaceCache workspaceCache = repositoryCache.getWorkspaceCache(workspaceName);
            this.reindexSince(workspaceCache, writer, changedNodes);
        }
    }

    protected void reindexIfNeeded(boolean async, final boolean includeSystemContent) {
        final RepositoryIndexManager.ScanningRequest request = this.toBeScanned.drain();
        if (!request.isEmpty()) {
            final IndexWriter writer = this.indexManager.getIndexWriterForProviders(request.providerNames());
            final RepositoryCache repoCache = this.runningState.repositoryCache();
            this.scan(async, writer, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    RepositoryIndexManager.ScanOperation op = new RepositoryIndexManager.ScanOperation(){

                        @Override
                        public void scan(String workspaceName, Path path) {
                            WorkspaceCache workspaceCache = repoCache.getWorkspaceCache(workspaceName);
                            if (workspaceCache != null) {
                                CachedNode node = workspaceCache.getNode(workspaceCache.getRootKey());
                                if (!path.isRoot()) {
                                    for (Path.Segment segment : path) {
                                        ChildReference child = node.getChildReferences(workspaceCache).getChild(segment);
                                        if (child == null) {
                                            node = null;
                                            break;
                                        }
                                        node = workspaceCache.getNode(child);
                                        if (node != null) continue;
                                        break;
                                    }
                                }
                                if (node != null) {
                                    boolean scanSystemContent;
                                    if (RepositoryQueryManager.this.logger.isDebugEnabled()) {
                                        RepositoryQueryManager.this.logger.debug("Performing full reindexing for repository '{0}' and workspace '{1}'", new Object[]{repoCache.getName(), workspaceName});
                                    }
                                    boolean bl = scanSystemContent = includeSystemContent || repoCache.getSystemWorkspaceName().equals(workspaceName);
                                    if (RepositoryQueryManager.this.reindexContent(workspaceName, workspaceCache, node, Integer.MAX_VALUE, scanSystemContent, writer)) {
                                        RepositoryQueryManager.this.commitChanges(workspaceName);
                                    }
                                }
                            }
                        }
                    };
                    request.onEachPathInWorkspace(op);
                    return null;
                }
            });
        }
    }

    protected void cleanAndReindex(boolean async) {
        final IndexWriter writer = this.getIndexWriter();
        this.scan(async, this.getIndexWriter(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                writer.clearAllIndexes();
                RepositoryQueryManager.this.reindexContent(true, writer);
                return null;
            }
        });
    }

    private void scan(boolean async, IndexWriter indexes, Callable<Void> callable) {
        if (!indexes.canBeSkipped()) {
            if (async) {
                this.asyncReindexingResult = this.indexingExecutorService.submit(callable);
            } else {
                try {
                    callable.call();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private void reindexContent(boolean includeSystemContent, IndexWriter indexes) {
        if (indexes.canBeSkipped()) {
            return;
        }
        RepositoryCache repoCache = this.runningState.repositoryCache();
        this.logger.debug(JcrI18n.reindexAll.text(new Object[]{this.runningState.name()}), new Object[0]);
        if (includeSystemContent) {
            String systemWorkspaceName = repoCache.getSystemWorkspaceName();
            WorkspaceCache systemWorkspaceCache = repoCache.getWorkspaceCache(systemWorkspaceName);
            CachedNode rootNode = systemWorkspaceCache.getNode(repoCache.getSystemKey());
            this.logger.debug("Starting reindex of system content in '{0}' repository.", new Object[]{this.runningState.name()});
            if (this.reindexSystemContent(rootNode, Integer.MAX_VALUE, indexes)) {
                this.commitChanges(systemWorkspaceName);
            }
            this.logger.debug("Completed reindex of system content in '{0}' repository.", new Object[]{this.runningState.name()});
        }
        for (String workspaceName : repoCache.getWorkspaceNames()) {
            WorkspaceCache workspaceCache = repoCache.getWorkspaceCache(workspaceName);
            CachedNode rootNode = workspaceCache.getNode(workspaceCache.getRootKey());
            this.logger.debug("Starting reindex of workspace '{0}' content in '{1}' repository.", new Object[]{this.runningState.name(), workspaceName});
            if (this.reindexContent(workspaceName, workspaceCache, rootNode, Integer.MAX_VALUE, false, indexes)) {
                this.commitChanges(workspaceName);
            }
            this.logger.debug("Completed reindex of workspace '{0}' content in '{1}' repository.", new Object[]{this.runningState.name(), workspaceName});
        }
    }

    public void reindexContent(JcrWorkspace workspace) {
        this.reindexContent(workspace, Path.ROOT_PATH, Integer.MAX_VALUE);
    }

    public void reindexContent(JcrWorkspace workspace, Path path, int depth) {
        if (this.getIndexWriter().canBeSkipped()) {
            return;
        }
        CheckArg.isPositive((int)depth, (String)"depth");
        JcrSession session = workspace.getSession();
        WorkspaceCache cache = session.cache().getWorkspace();
        String workspaceName = workspace.getName();
        CachedNode node = cache.getNode(cache.getRootKey());
        for (Path.Segment segment : path) {
            ChildReference ref = node.getChildReferences(cache).getChild(segment);
            if (ref == null) {
                return;
            }
            node = cache.getNode(ref);
        }
        RepositoryCache repoCache = this.runningState.repositoryCache();
        String systemWorkspaceName = repoCache.getSystemWorkspaceName();
        String systemWorkspaceKey = repoCache.getSystemWorkspaceKey();
        if (node.getKey().getWorkspaceKey().equals(systemWorkspaceKey)) {
            if (this.reindexSystemContent(node, depth, this.getIndexWriter())) {
                this.commitChanges(systemWorkspaceName);
            }
        } else if (this.reindexContent(workspaceName, cache, node, depth, path.isRoot(), this.getIndexWriter())) {
            this.commitChanges(workspaceName);
        }
    }

    protected void reindexSince(JcrWorkspace workspace, long timestamp) {
        ChangeJournal journal = this.runningState.journal();
        assert (journal != null);
        Iterator<NodeKey> changedNodes = journal.changedNodesSince(timestamp);
        if (!changedNodes.hasNext()) {
            return;
        }
        this.reindexSince(workspace.getSession().cache().getWorkspace(), this.getIndexWriter(), changedNodes);
    }

    protected void reindexSince(WorkspaceCache cache, IndexWriter writer, Iterator<NodeKey> changedNodes) {
        if (writer.canBeSkipped()) {
            return;
        }
        String workspaceName = cache.getWorkspaceName();
        String workspaceKey = NodeKey.keyForWorkspaceName(workspaceName);
        boolean commitRequired = false;
        while (changedNodes.hasNext()) {
            NodeKey nodeKey = changedNodes.next();
            if (!workspaceKey.equals(nodeKey.getWorkspaceKey())) continue;
            CachedNode node = cache.getNode(nodeKey);
            if (node != null) {
                commitRequired |= this.reindexContent(workspaceName, cache, node, 1, true, writer);
                continue;
            }
            commitRequired |= writer.remove(workspaceName, nodeKey);
        }
        if (commitRequired) {
            this.commitChanges(workspaceName);
        }
    }

    protected Future<Boolean> reindexSinceAsync(JcrWorkspace workspace, long timestamp) {
        ChangeJournal journal = this.runningState.journal();
        assert (journal != null);
        Iterator<NodeKey> changedNodes = journal.changedNodesSince(timestamp);
        if (!changedNodes.hasNext()) {
            return new ImmediateFuture((Object)Boolean.FALSE);
        }
        return this.reindexSinceAsync(workspace.getSession().cache().getWorkspace(), this.getIndexWriter(), changedNodes);
    }

    protected Future<Boolean> reindexSinceAsync(final WorkspaceCache cache, final IndexWriter indexWriter, final Iterator<NodeKey> changedNodes) {
        return this.indexingExecutorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RepositoryQueryManager.this.reindexSince(cache, indexWriter, changedNodes);
                return Boolean.TRUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reindexContent(String workspaceName, NodeCache cache, CachedNode node, int depth, boolean reindexSystemContent, IndexWriter indexes) {
        assert (indexes != null);
        if (indexes.canBeSkipped()) {
            return false;
        }
        if (node.isExcludedFromSearch(cache)) {
            return false;
        }
        boolean indexesUpdated = false;
        try {
            NodeKey key;
            this.updateIndexesStatus(workspaceName, IndexManager.IndexStatus.ENABLED, IndexManager.IndexStatus.REINDEXING);
            PathCache paths = new PathCache(cache);
            Path nodePath = paths.getPath(node);
            if (this.indexLogger.isTraceEnabled()) {
                String path = (String)this.runningState.context().getValueFactories().getStringFactory().create(nodePath);
                this.indexLogger.debug("Reindexing node '{0}' in workspace '{1}' of repository '{2}': {3}", new Object[]{path, workspaceName, this.runningState.name(), node});
            }
            indexesUpdated |= indexes.add(workspaceName, node.getKey(), nodePath, node.getPrimaryType(cache), node.getMixinTypes(cache), node.getPropertiesByName(cache));
            if (depth == 1) {
                boolean path = indexesUpdated;
                return path;
            }
            LinkedList<NodeKey> queue = new LinkedList<NodeKey>();
            if (reindexSystemContent) {
                ChildReferences childRefs = node.getChildReferences(cache);
                ChildReference systemRef = childRefs.getChild(JcrLexicon.SYSTEM);
                NodeKey systemKey = systemRef != null ? systemRef.getKey() : null;
                for (ChildReference childRef : node.getChildReferences(cache)) {
                    NodeKey childKey = childRef.getKey();
                    if (childKey.equals(systemKey)) {
                        node = cache.getNode(childKey);
                        indexesUpdated |= this.reindexSystemContent(node, depth - 1, indexes);
                        continue;
                    }
                    queue.add(childKey);
                }
            } else {
                for (ChildReference childRef : node.getChildReferences(cache)) {
                    NodeKey childKey = childRef.getKey();
                    if (childKey.getWorkspaceKey().equals(this.runningState.systemWorkspaceKey())) continue;
                    queue.add(childKey);
                }
            }
            while ((key = (NodeKey)queue.poll()) != null) {
                node = cache.getNode(key);
                if (node == null || node.isExcludedFromSearch(cache)) continue;
                nodePath = paths.getPath(node);
                if (this.indexLogger.isTraceEnabled()) {
                    String path = (String)this.runningState.context().getValueFactories().getStringFactory().create(nodePath);
                    this.indexLogger.debug("Reindexing node '{0}' in workspace '{1}' of repository '{2}': {3}", new Object[]{path, workspaceName, this.runningState.name(), node});
                }
                indexesUpdated |= indexes.add(workspaceName, node.getKey(), nodePath, node.getPrimaryType(cache), node.getMixinTypes(cache), node.getPropertiesByName(cache));
                if (nodePath.size() > depth) continue;
                for (ChildReference childRef : node.getChildReferences(cache)) {
                    queue.add(childRef.getKey());
                }
            }
            boolean bl = indexesUpdated;
            return bl;
        }
        finally {
            this.updateIndexesStatus(workspaceName, IndexManager.IndexStatus.REINDEXING, IndexManager.IndexStatus.ENABLED);
        }
    }

    protected void updateIndexesStatus(String workspaceName, final IndexManager.IndexStatus currentStatus, final IndexManager.IndexStatus newStatus) {
        for (IndexProvider indexProvider : this.indexManager.getProviders()) {
            indexProvider.onEachIndexInWorkspace(workspaceName, new IndexProvider.ManagedIndexOperation(){

                @Override
                public void apply(String workspaceName, ManagedIndex index, IndexDefinition defn) {
                    index.updateStatus(currentStatus, newStatus);
                }
            });
        }
    }

    protected void commitChanges(String workspaceName) {
        for (IndexProvider indexProvider : this.indexManager.getProviders()) {
            indexProvider.getIndexWriter().commit(workspaceName);
        }
    }

    protected boolean reindexSystemContent(CachedNode nodeInSystemBranch, int depth, IndexWriter indexes) {
        RepositoryCache repoCache = this.runningState.repositoryCache();
        String workspaceName = repoCache.getSystemWorkspaceName();
        WorkspaceCache systemWorkspaceCache = repoCache.getWorkspaceCache(workspaceName);
        return this.reindexContent(workspaceName, systemWorkspaceCache, nodeInSystemBranch, depth, true, indexes);
    }

    protected void reindexSystemContent() {
        CachedNode systemNode;
        WorkspaceCache systemWorkspaceCache;
        RepositoryCache repoCache = this.runningState.repositoryCache();
        String workspaceName = repoCache.getSystemWorkspaceName();
        if (this.reindexContent(workspaceName, systemWorkspaceCache = repoCache.getWorkspaceCache(workspaceName), systemNode = systemWorkspaceCache.getNode(repoCache.getSystemKey()), Integer.MAX_VALUE, true, this.getIndexWriter())) {
            this.commitChanges(workspaceName);
        }
    }

    public Future<Boolean> reindexContentAsync(final JcrWorkspace workspace) {
        return this.indexingExecutorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RepositoryQueryManager.this.reindexContent(workspace);
                return Boolean.TRUE;
            }
        });
    }

    public Future<Boolean> reindexContentAsync(final JcrWorkspace workspace, final Path path, final int depth) {
        return this.indexingExecutorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RepositoryQueryManager.this.reindexContent(workspace, path, depth);
                return Boolean.TRUE;
            }
        });
    }
}

