/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.io.File;
import java.nio.file.Paths;
import javax.jcr.RepositoryException;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.query.qom.ChildCount;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.index.local.IndexUpdater;
import org.modeshape.jcr.index.local.LocalIndexBuilder;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.spi.index.IndexCostCalculator;
import org.modeshape.jcr.spi.index.provider.IndexProvider;
import org.modeshape.jcr.spi.index.provider.IndexUsage;
import org.modeshape.jcr.spi.index.provider.ManagedIndexBuilder;

public class LocalIndexProvider
extends IndexProvider {
    private static final String DB_FILENAME = "local-indexes.db";
    private String directory;
    private String path;
    private String relativeTo;
    private DB db;
    private IndexUpdater indexUpdater;
    private boolean cacheLRUEnable = false;
    private boolean mmapFileEnable = false;
    private boolean commitFileSyncDisable = false;
    private boolean transactionDisable = false;
    private boolean asyncWrite = false;
    private Integer cacheSize;

    public String getDirectory() {
        return this.directory;
    }

    @Override
    protected void doInitialize() throws RepositoryException {
        if (this.directory == null && this.relativeTo != null && this.path != null) {
            try {
                File rel = new File(this.relativeTo);
                File dir = Paths.get(rel.toURI()).resolve(this.path).toFile();
                this.directory = dir.getAbsolutePath();
            }
            catch (RuntimeException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        if (this.directory == null) {
            throw new RepositoryException(JcrI18n.localIndexProviderMustHaveDirectory.text(new Object[]{this.getRepositoryName()}));
        }
        this.logger().debug("Initializing the local index provider '{0}' in repository '{1}' at: {2}", new Object[]{this.getName(), this.getRepositoryName(), this.directory});
        File dir = new File(this.directory);
        if (!dir.exists()) {
            this.logger().debug("Attempting to create directory for local indexes in repository '{1}' at: {0}", new Object[]{dir.getAbsolutePath(), this.getRepositoryName()});
            if (dir.mkdirs()) {
                this.logger().debug("Created directory for local indexes in repository '{1}' at: {0}", new Object[]{dir.getAbsolutePath(), this.getRepositoryName()});
            } else {
                this.logger().debug("Unable to create directory for local indexes in repository '{1}' at: {0}", new Object[]{dir.getAbsolutePath(), this.getRepositoryName()});
            }
        }
        if (!dir.canRead()) {
            throw new RepositoryException(JcrI18n.localIndexProviderDirectoryMustBeReadable.text(new Object[]{dir, this.getRepositoryName()}));
        }
        if (!dir.canWrite()) {
            throw new RepositoryException(JcrI18n.localIndexProviderDirectoryMustBeWritable.text(new Object[]{dir, this.getRepositoryName()}));
        }
        File file = new File(dir, DB_FILENAME);
        if (this.logger().isDebugEnabled()) {
            String action = file.exists() ? "Opening" : "Creating";
            this.logger().debug("{0} the local index provider database for repository '{1}' at: {2}", new Object[]{action, this.getRepositoryName(), file.getAbsolutePath()});
        }
        DBMaker dbMaker = DBMaker.newFileDB((File)file);
        if (this.cacheSize != null) {
            dbMaker.cacheSize(this.cacheSize.intValue());
            this.logger().debug("MapDB cache size set to {0} for index provider {1}", new Object[]{this.cacheSize, this.getName()});
        }
        if (this.cacheLRUEnable) {
            dbMaker.cacheLRUEnable();
            this.logger().debug("MapDB cacheLRU enabled for index provider {0}", new Object[]{this.getName()});
        }
        if (this.mmapFileEnable) {
            dbMaker.mmapFileEnableIfSupported();
            this.logger().debug("MapDB mmapFiles enabled for index provider {0}", new Object[]{this.getName()});
        }
        if (this.commitFileSyncDisable) {
            dbMaker.commitFileSyncDisable();
            this.logger().debug("MapDB commitFileSync enabled for index provider {0}", new Object[]{this.getName()});
        }
        if (this.transactionDisable) {
            dbMaker.transactionDisable();
            this.logger().debug("MapDB transactions disabled for index provider {0}", new Object[]{this.getName()});
        }
        if (this.asyncWrite) {
            dbMaker.asyncWriteEnable();
            this.logger().debug("MapDB async writes enabled for index provider {0}", new Object[]{this.getName()});
        }
        dbMaker.closeOnJvmShutdown();
        this.db = dbMaker.make();
        this.indexUpdater = new IndexUpdater(this.db);
        this.logger().trace("Found the index files {0} in index database for repository '{1}' at: {2}", new Object[]{this.db.getCatalog(), this.getRepositoryName(), file.getAbsolutePath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postShutdown() {
        this.logger().debug("Shutting down the local index provider '{0}' in repository '{1}'", new Object[]{this.getName(), this.getRepositoryName()});
        if (this.db != null) {
            try {
                this.db.commit();
                this.db.close();
            }
            finally {
                this.db = null;
            }
        }
    }

    @Override
    public Long getLatestIndexUpdateTime() {
        return this.indexUpdater.latestIndexUpdateTime();
    }

    @Override
    public void validateProposedIndex(ExecutionContext context, IndexDefinition defn, NodeTypes.Supplier nodeTypeSupplier, Problems problems) {
        LocalIndexBuilder.validate(defn, problems);
    }

    @Override
    protected ManagedIndexBuilder getIndexBuilder(IndexDefinition defn, String workspaceName, NodeTypes.Supplier nodeTypesSupplier, ChangeSetAdapter.NodeTypePredicate matcher) {
        return LocalIndexBuilder.create(this.context(), defn, nodeTypesSupplier, workspaceName, matcher, this.db);
    }

    @Override
    protected IndexUsage evaluateUsage(QueryContext context, IndexCostCalculator calculator, IndexDefinition defn) {
        return new IndexUsage(context, calculator, defn){

            @Override
            protected boolean applies(FullTextSearch search) {
                return false;
            }

            @Override
            protected boolean indexAppliesTo(Comparison constraint) {
                if ("jcr.operator.like".equals(constraint.getOperator())) {
                    return false;
                }
                return super.indexAppliesTo(constraint);
            }

            @Override
            protected boolean applies(ChildCount operand) {
                return false;
            }
        };
    }
}

