/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.journal;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import org.infinispan.schematic.document.ThreadSafe;
import org.joda.time.DateTime;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.common.util.TimeBasedKeys;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.journal.ChangeJournal;
import org.modeshape.jcr.journal.JournalRecord;

@ThreadSafe
public class LocalJournal
implements ChangeJournal {
    private static final Logger LOGGER = Logger.getLogger(LocalJournal.class);
    private static final int DEFAULT_MAX_TIME_TO_KEEP_FILES = -1;
    private static final String RECORDS_FIELD = "records";
    private static final String JOURNAL_ID_FIELD = "journalId";
    private static final TimeBasedKeys TIME_BASED_KEYS = TimeBasedKeys.create();
    private static final long DEFAULT_LOCAL_SEARCH_DELTA = TimeUnit.SECONDS.toMillis(1L);
    private final String journalLocation;
    private final boolean asyncWritesEnabled;
    private final long maxTimeToKeepEntriesMillis;
    private String journalId;
    private DB journalDB;
    private BTreeMap<Long, JournalRecord> records;
    private long searchTimeDelta;
    private volatile boolean stopped;

    public LocalJournal(String journalLocation, boolean asyncWritesEnabled, int maxDaysToKeepEntries) {
        CheckArg.isNotNull((Object)journalLocation, (String)"journalLocation");
        this.journalLocation = journalLocation;
        this.asyncWritesEnabled = asyncWritesEnabled;
        this.maxTimeToKeepEntriesMillis = TimeUnit.DAYS.toMillis(maxDaysToKeepEntries);
        this.stopped = true;
        this.searchTimeDelta = DEFAULT_LOCAL_SEARCH_DELTA;
    }

    protected LocalJournal(String journalLocation) {
        this(journalLocation, false, -1);
    }

    @Override
    public boolean started() {
        return !this.stopped;
    }

    @Override
    public synchronized void start() throws RepositoryException {
        if (!this.stopped) {
            return;
        }
        try {
            File journalFileLocation = new File(this.journalLocation);
            if (!journalFileLocation.exists()) {
                boolean folderHierarchyCreated = journalFileLocation.mkdirs();
                assert (folderHierarchyCreated);
            }
            DBMaker dbMaker = DBMaker.newFileDB((File)new File(journalFileLocation, RECORDS_FIELD)).compressionEnable().checksumEnable().mmapFileEnableIfSupported().closeOnJvmShutdown();
            if (this.asyncWritesEnabled) {
                dbMaker.asyncWriteEnable();
            }
            this.journalDB = dbMaker.make();
            this.records = this.journalDB.createTreeMap(RECORDS_FIELD).keySerializer(BTreeKeySerializer.ZERO_OR_POSITIVE_LONG).counterEnable().makeOrGet();
            Atomic.String journalAtomic = this.journalDB.getAtomicString(JOURNAL_ID_FIELD);
            if (StringUtil.isBlank((String)journalAtomic.get())) {
                journalAtomic.set("Journal_" + UUID.randomUUID().toString());
            }
            this.journalId = journalAtomic.get();
            this.stopped = false;
        }
        catch (Exception e) {
            throw new RepositoryException(JcrI18n.cannotStartJournal.text(new Object[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        if (this.stopped) {
            return;
        }
        try {
            this.journalDB.commit();
            this.journalDB.close();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, (I18nResource)JcrI18n.cannotStopJournal, new Object[0]);
        }
        finally {
            this.stopped = true;
        }
    }

    @Override
    public void notify(ChangeSet changeSet) {
        boolean systemWorkspaceChanges = "system".equalsIgnoreCase(changeSet.getWorkspaceName());
        if (changeSet.isEmpty() || systemWorkspaceChanges) {
            return;
        }
        this.addRecords(new JournalRecord(changeSet));
    }

    @Override
    public synchronized void addRecords(JournalRecord ... records) {
        if (this.stopped) {
            return;
        }
        LOGGER.debug("Adding {0} records", new Object[]{records.length});
        for (JournalRecord record : records) {
            if (record.getTimeBasedKey() < 0L) {
                long createTimeMillisUTC = TIME_BASED_KEYS.nextKey();
                record.withTimeBasedKey(createTimeMillisUTC);
            }
            this.records.put((Object)record.getTimeBasedKey(), (Object)record);
        }
        this.journalDB.commit();
    }

    @Override
    public synchronized void removeOldRecords() {
        this.removeRecordsOlderThan(System.currentTimeMillis() - this.maxTimeToKeepEntriesMillis);
    }

    protected void removeRecordsOlderThan(long millisInUtc) {
        if (millisInUtc <= 0L || this.stopped) {
            return;
        }
        long searchBound = TIME_BASED_KEYS.getCounterEndingAt(millisInUtc);
        LOGGER.debug("Removing records older than " + searchBound, new Object[0]);
        ConcurrentNavigableMap toRemove = this.records.headMap((Object)searchBound);
        toRemove.clear();
        this.journalDB.commit();
        this.journalDB.compact();
    }

    protected String getJournalLocation() {
        return this.journalLocation;
    }

    @Override
    public ChangeJournal.Records allRecords(boolean descendingOrder) {
        return LocalJournal.recordsFrom(this.records, descendingOrder);
    }

    @Override
    public JournalRecord lastRecord() {
        return this.records == null || this.records.isEmpty() ? null : (JournalRecord)this.records.lastEntry().getValue();
    }

    @Override
    public ChangeJournal.Records recordsNewerThan(DateTime changeSetTime, boolean inclusive, boolean descendingOrder) {
        ConcurrentNavigableMap subMap;
        if (this.stopped) {
            return ChangeJournal.Records.EMPTY;
        }
        long changeSetMillisUTC = -1L;
        long searchBound = -1L;
        if (changeSetTime != null) {
            changeSetMillisUTC = changeSetTime.getMillis();
            searchBound = TIME_BASED_KEYS.getCounterStartingAt(changeSetMillisUTC - this.searchTimeDelta);
        }
        if ((subMap = this.records.tailMap((Object)searchBound, true)).isEmpty()) {
            return ChangeJournal.Records.EMPTY;
        }
        long startKeyInSubMap = -1L;
        for (Long timeBasedKey : subMap.keySet()) {
            JournalRecord record = (JournalRecord)subMap.get(timeBasedKey);
            long recordChangeTimeMillisUTC = record.getChangeTimeMillis();
            if ((recordChangeTimeMillisUTC != changeSetMillisUTC || !inclusive) && recordChangeTimeMillisUTC <= changeSetMillisUTC) continue;
            startKeyInSubMap = timeBasedKey;
            break;
        }
        return startKeyInSubMap != -1L ? LocalJournal.recordsFrom(subMap.tailMap(startKeyInSubMap, true), descendingOrder) : ChangeJournal.Records.EMPTY;
    }

    @Override
    public Iterator<NodeKey> changedNodesSince(final long timestamp) {
        long searchBound = TIME_BASED_KEYS.getCounterStartingAt(timestamp - this.searchTimeDelta);
        Collection journalRecords = this.records.tailMap((Object)searchBound, true).values();
        if (journalRecords.isEmpty()) {
            return Collections.emptyListIterator();
        }
        final Iterator recordsIterator = journalRecords.iterator();
        return new Iterator<NodeKey>(){
            private Iterator<NodeKey> currentBatchOfKeys = null;

            @Override
            public boolean hasNext() {
                this.nextBatchOfKeys();
                return this.currentBatchOfKeys != null && this.currentBatchOfKeys.hasNext();
            }

            @Override
            public NodeKey next() {
                this.nextBatchOfKeys();
                if (this.currentBatchOfKeys == null) {
                    throw new NoSuchElementException();
                }
                assert (this.currentBatchOfKeys.hasNext());
                return this.currentBatchOfKeys.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void nextBatchOfKeys() {
                if ((this.currentBatchOfKeys == null || !this.currentBatchOfKeys.hasNext()) && recordsIterator.hasNext()) {
                    while (recordsIterator.hasNext()) {
                        JournalRecord record = (JournalRecord)recordsIterator.next();
                        if (record.getChangeTimeMillis() < timestamp) continue;
                        this.currentBatchOfKeys = record.getChangeSet().changedNodes().iterator();
                        break;
                    }
                }
                if (this.currentBatchOfKeys != null && !this.currentBatchOfKeys.hasNext()) {
                    this.currentBatchOfKeys = null;
                }
            }
        };
    }

    @Override
    public String journalId() {
        return this.journalId;
    }

    protected LocalJournal withSearchTimeDelta(long searchTimeDelta) {
        this.searchTimeDelta = searchTimeDelta;
        return this;
    }

    private static ChangeJournal.Records recordsFrom(final NavigableMap<Long, JournalRecord> content, boolean descending) {
        final Iterator iterator = descending ? content.descendingMap().values().iterator() : content.values().iterator();
        return new ChangeJournal.Records(){

            @Override
            public int size() {
                return content.size();
            }

            @Override
            public Iterator<JournalRecord> iterator() {
                return new Iterator<JournalRecord>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public JournalRecord next() {
                        return (JournalRecord)iterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("This iterator is read-only");
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return this.size() == 0;
            }
        };
    }
}

