/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrRepositoriesContainer;
import org.modeshape.jcr.api.RepositoryFactory;

@ThreadSafe
public class JcrRepositoryFactory
implements RepositoryFactory {
    private static final Logger LOG = Logger.getLogger(JcrRepositoryFactory.class);
    private static final JcrRepositoriesContainer CONTAINER = new JcrRepositoriesContainer();

    public Repository getRepository(Map parameters) throws RepositoryException {
        LOG.debug("Trying to load ModeShape JCR Repository with parameters: " + parameters, new Object[0]);
        return CONTAINER.getRepository(null, parameters);
    }

    @Deprecated
    public Future<Boolean> shutdown() {
        return CONTAINER.shutdown();
    }

    @Deprecated
    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        return CONTAINER.shutdown(timeout, unit);
    }

    @Deprecated
    public Repository getRepository(String repositoryName) throws RepositoryException {
        return CONTAINER.getRepository(repositoryName, null);
    }

    @Deprecated
    public Set<String> getRepositoryNames() {
        try {
            return CONTAINER.getRepositoryNames(null);
        }
        catch (RepositoryException e) {
            LOG.debug((Throwable)e, "Cannot retrieve the names of all the repositories", new Object[0]);
            return Collections.emptySet();
        }
    }
}

