/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;

public class TransactionalWorkspaceCaches {
    private static final Logger LOGGER = Logger.getLogger(TransactionalWorkspaceCache.class);
    private final TransactionManager txnMgr;
    private final Map<Transaction, Map<String, TransactionalWorkspaceCache>> transactionalCachesByTransaction = new HashMap<Transaction, Map<String, TransactionalWorkspaceCache>>();

    public TransactionalWorkspaceCaches(Transactions transactions) {
        CheckArg.isNotNull((Object)transactions, (String)"transactions");
        this.txnMgr = transactions.getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkspaceCache getTransactionalCache(WorkspaceCache globalWorkspaceCache) throws Exception {
        Transaction txn = this.txnMgr.getTransaction();
        if (txn == null || txn.getStatus() != 0) {
            return globalWorkspaceCache;
        }
        TransactionalWorkspaceCaches transactionalWorkspaceCaches = this;
        synchronized (transactionalWorkspaceCaches) {
            String workspaceName = globalWorkspaceCache.getWorkspaceName();
            return this.transactionalCachesByTransaction.computeIfAbsent(txn, tx -> new HashMap()).computeIfAbsent(workspaceName, wsName -> this.createCache(globalWorkspaceCache, txn));
        }
    }

    public synchronized void rollbackActiveTransactionsForWorkspace(String workspaceName) {
        ArrayList toRemove = new ArrayList();
        this.transactionalCachesByTransaction.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(workspaceName)).map(Map.Entry::getKey).forEach(tx -> {
            toRemove.add(tx);
            try {
                tx.rollback();
            }
            catch (SystemException e) {
                LOGGER.error((Throwable)e, (I18nResource)JcrI18n.errorWhileRollingBackActiveTransactionUsingWorkspaceThatIsBeingDeleted, new Object[]{workspaceName, e.getMessage()});
            }
        });
        toRemove.stream().forEach(this.transactionalCachesByTransaction::remove);
    }

    protected synchronized void remove(Transaction txn) {
        this.transactionalCachesByTransaction.remove(txn);
    }

    protected synchronized Stream<TransactionalWorkspaceCache> workspaceCachesFor(Transaction txn) {
        return this.transactionalCachesByTransaction.getOrDefault(txn, Collections.emptyMap()).values().stream();
    }

    private TransactionalWorkspaceCache createCache(WorkspaceCache sharedWorkspaceCache, final Transaction txn) {
        TransactionalWorkspaceCache cache = new TransactionalWorkspaceCache(sharedWorkspaceCache, this, txn);
        try {
            txn.registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    TransactionalWorkspaceCaches.this.remove(txn);
                }
            });
        }
        catch (RollbackException | SystemException e) {
            throw new RuntimeException(e);
        }
        return cache;
    }
}

