/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.modeshape.common.database.DatabaseType;
import org.modeshape.common.database.DatabaseUtil;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;

public class Database {
    public static final String TABLE_NAME = "CONTENT_STORE";
    public static final String STATEMENTS_FILE_PATH = "org/modeshape/jcr/database/";
    protected static final String STATEMENTS_FILE_PREFIX = "binary_store_";
    protected static final String STATEMENTS_FILENAME_SUFFIX = "_database.properties";
    protected static final String DEFAULT_STATEMENTS_FILE_PATH = "org/modeshape/jcr/database/binary_store_default_database.properties";
    protected static final int DEFAULT_MAX_EXTRACTED_TEXT_LENGTH = 1000;
    private static final Logger LOGGER = Logger.getLogger(Database.class);
    private static final String INSERT_CONTENT_STMT_KEY = "add_content";
    private static final String USED_CONTENT_STMT_KEY = "get_used_content";
    private static final String UNUSED_CONTENT_STMT_KEY = "get_unused_content";
    private static final String MARK_UNUSED_STMT_KEY = "mark_unused";
    private static final String MARK_USED_STMT_KEY = "mark_used";
    private static final String REMOVE_EXPIRED_STMT_KEY = "remove_expired";
    private static final String GET_MIMETYPE_STMT_KEY = "get_mimetype";
    private static final String SET_MIMETYPE_STMT_KEY = "set_mimetype";
    private static final String GET_EXTRACTED_TEXT_STMT_KEY = "get_extracted_text";
    private static final String SET_EXTRACTED_TEXT_STMT_KEY = "set_extracted_text";
    private static final String GET_BINARY_KEYS_STMT_KEY = "get_binary_keys";
    private static final String CREATE_TABLE_STMT_KEY = "create_table";
    private static final String TABLE_EXISTS_STMT_KEY = "table_exists_query";
    private static final String EXTRACTED_TEXT_COLUMN_NAME = "ext_text";
    private final String tableName;
    private final int maxExtractedTextLength;
    private Properties statements;

    protected Database(Connection connection) throws IOException, SQLException {
        this(connection, null);
    }

    protected Database(Connection connection, String prefix) throws IOException, SQLException {
        assert (connection != null);
        DatabaseMetaData metaData = connection.getMetaData();
        DatabaseType databaseType = DatabaseUtil.determineType((DatabaseMetaData)metaData);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Discovered DBMS type for binary store as '{0}' on '{1}", new Object[]{databaseType, metaData.getURL()});
        }
        String tablePrefix = prefix == null ? null : prefix.trim();
        this.tableName = tablePrefix != null && tablePrefix.length() != 0 ? tablePrefix + TABLE_NAME : TABLE_NAME;
        this.initializeStatements(databaseType);
        this.initializeStorage(connection, databaseType);
        this.maxExtractedTextLength = this.determineMaxExtractedTextLength(metaData);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using max length for extracted text '{0}'", new Object[]{this.maxExtractedTextLength});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int determineMaxExtractedTextLength(DatabaseMetaData metaData) {
        int n;
        ResultSet resultSet = null;
        try {
            String tableName = this.tableName;
            if (metaData.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            } else if (metaData.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            }
            resultSet = metaData.getColumns(null, null, tableName, EXTRACTED_TEXT_COLUMN_NAME);
            n = resultSet.next() ? resultSet.getInt("COLUMN_SIZE") : 1000;
        }
        catch (SQLException e) {
            int n2;
            try {
                LOGGER.debug((Throwable)e, "Cannot determine the maximum size of the column which holds the extracted text. Defaulting to {0}", new Object[]{1000});
                n2 = 1000;
            }
            catch (Throwable throwable) {
                Database.tryToClose(resultSet);
                throw throwable;
            }
            Database.tryToClose(resultSet);
            return n2;
        }
        Database.tryToClose(resultSet);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStatements(DatabaseType databaseType) throws IOException {
        String statementsFilename = DEFAULT_STATEMENTS_FILE_PATH;
        Properties defaultStatements = new Properties();
        try (InputStream statementStream = this.getClass().getClassLoader().getResourceAsStream(statementsFilename);){
            LOGGER.trace("Loading default statement from '{0}'", new Object[]{statementsFilename});
            defaultStatements.load(statementStream);
        }
        statementsFilename = "org/modeshape/jcr/database/binary_store_" + databaseType.nameString().toLowerCase() + STATEMENTS_FILENAME_SUFFIX;
        statementStream = this.getClass().getClassLoader().getResourceAsStream(statementsFilename);
        if (statementStream != null) {
            try {
                LOGGER.trace("Loading DBMS-specific statement from '{0}'", new Object[]{statementsFilename});
                this.statements = new Properties(defaultStatements);
                this.statements.load(statementStream);
            }
            finally {
                statementStream.close();
            }
        } else {
            this.statements = defaultStatements;
            LOGGER.trace("No DBMS-specific statement found in '{0}'", new Object[]{statementsFilename});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initializeStorage(Connection connection, DatabaseType databaseType) throws SQLException {
        boolean createTable = true;
        PreparedStatement exists = null;
        try {
            exists = this.prepareStatement(TABLE_EXISTS_STMT_KEY, connection);
            this.execute(exists);
            createTable = false;
        }
        catch (SQLException sQLException) {
            Database.tryToClose(exists);
            catch (Throwable throwable) {
                Database.tryToClose(exists);
                throw throwable;
            }
        }
        Database.tryToClose(exists);
        if (createTable) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to find existing table. Attempting to create '{0}' table in {1}", new Object[]{this.tableName, connection.getMetaData().getURL()});
            }
            PreparedStatement create = this.prepareStatement(CREATE_TABLE_STMT_KEY, connection);
            try {
                this.execute(create);
            }
            catch (SQLException e) {
                String msg = JcrI18n.errorCreatingDatabaseTable.text(new Object[]{this.tableName, databaseType});
                throw new RuntimeException(msg, e);
            }
            finally {
                Database.tryToClose(create);
            }
        }
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected PreparedStatement prepareStatement(String statementKey, Connection connection) throws SQLException {
        String statementString = this.statements.getProperty(statementKey);
        statementString = StringUtil.createString((String)statementString, (Object[])new Object[]{this.tableName});
        LOGGER.trace("Preparing statement: {0}", new Object[]{statementString});
        return connection.prepareStatement(statementString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertContent(BinaryKey key, InputStream stream, long size, Connection connection) throws SQLException {
        PreparedStatement addContentSql = this.prepareStatement(INSERT_CONTENT_STMT_KEY, connection);
        try {
            addContentSql.setString(1, key.toString());
            addContentSql.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            addContentSql.setBinaryStream(3, stream, size);
            this.execute(addContentSql);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            Database.tryToClose(addContentSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean contentExists(BinaryKey key, boolean inUse, Connection connection) throws SQLException {
        PreparedStatement readContentStatement = inUse ? this.prepareStatement(USED_CONTENT_STMT_KEY, connection) : this.prepareStatement(UNUSED_CONTENT_STMT_KEY, connection);
        try {
            readContentStatement.setString(1, key.toString());
            ResultSet rs = this.executeQuery(readContentStatement);
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            LOGGER.debug("Cannot determine if content exists under key '{0}'", new Object[]{key.toString()});
            boolean bl = false;
            return bl;
        }
        finally {
            Database.tryToClose(readContentStatement);
        }
    }

    protected InputStream readContent(BinaryKey key, Connection connection) throws SQLException {
        try {
            InputStream is = this.readStreamFromStatement(USED_CONTENT_STMT_KEY, key, connection);
            if (is != null) {
                return is;
            }
            return this.readStreamFromStatement(UNUSED_CONTENT_STMT_KEY, key, connection);
        }
        catch (Throwable t) {
            Database.tryToClose(connection);
            throw t;
        }
    }

    private InputStream readStreamFromStatement(String statement, BinaryKey key, Connection connection) throws SQLException {
        PreparedStatement readContentStatement = this.prepareStatement(statement, connection);
        try {
            readContentStatement.setString(1, key.toString());
            ResultSet rs = this.executeQuery(readContentStatement);
            if (!rs.next()) {
                Database.tryToClose(readContentStatement);
                return null;
            }
            return new DatabaseBinaryStream(connection, readContentStatement, rs.getBinaryStream(1));
        }
        catch (SQLException e) {
            Database.tryToClose(readContentStatement);
            throw e;
        }
        catch (Throwable t) {
            Database.tryToClose(readContentStatement);
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markUnused(Iterable<BinaryKey> keys, Connection connection) throws SQLException {
        PreparedStatement markUnusedSql = this.prepareStatement(MARK_UNUSED_STMT_KEY, connection);
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            for (BinaryKey key : keys) {
                markUnusedSql.setTimestamp(1, now);
                markUnusedSql.setString(2, key.toString());
                this.executeUpdate(markUnusedSql);
            }
        }
        finally {
            Database.tryToClose(markUnusedSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreContent(Connection connection, Iterable<BinaryKey> keys) throws SQLException {
        PreparedStatement markUsedSql = this.prepareStatement(MARK_USED_STMT_KEY, connection);
        try {
            for (BinaryKey key : keys) {
                markUsedSql.setString(1, key.toString());
                this.executeUpdate(markUsedSql);
            }
        }
        finally {
            Database.tryToClose(markUsedSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExpiredContent(long deadline, Connection connection) throws SQLException {
        PreparedStatement removedExpiredSql = this.prepareStatement(REMOVE_EXPIRED_STMT_KEY, connection);
        try {
            removedExpiredSql.setTimestamp(1, new Timestamp(deadline));
            this.execute(removedExpiredSql);
        }
        finally {
            Database.tryToClose(removedExpiredSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMimeType(BinaryKey key, Connection connection) throws SQLException {
        PreparedStatement getMimeType = this.prepareStatement(GET_MIMETYPE_STMT_KEY, connection);
        try {
            getMimeType.setString(1, key.toString());
            ResultSet rs = this.executeQuery(getMimeType);
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            Database.tryToClose(getMimeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMimeType(BinaryKey key, String mimeType, Connection connection) throws SQLException {
        PreparedStatement setMimeTypeSQL = this.prepareStatement(SET_MIMETYPE_STMT_KEY, connection);
        try {
            setMimeTypeSQL.setString(1, mimeType);
            setMimeTypeSQL.setString(2, key.toString());
            this.executeUpdate(setMimeTypeSQL);
        }
        finally {
            Database.tryToClose(setMimeTypeSQL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getExtractedText(BinaryKey key, Connection connection) throws SQLException {
        PreparedStatement getExtractedTextSql = this.prepareStatement(GET_EXTRACTED_TEXT_STMT_KEY, connection);
        try {
            getExtractedTextSql.setString(1, key.toString());
            ResultSet rs = this.executeQuery(getExtractedTextSql);
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            Database.tryToClose(getExtractedTextSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExtractedText(BinaryKey key, String text, Connection connection) throws SQLException {
        if (text.length() > this.maxExtractedTextLength) {
            LOGGER.warn((I18nResource)JcrI18n.warnExtractedTextTooLarge, new Object[]{EXTRACTED_TEXT_COLUMN_NAME, this.maxExtractedTextLength, this.tableName});
            text = text.substring(0, this.maxExtractedTextLength);
        }
        PreparedStatement setExtractedTextSql = this.prepareStatement(SET_EXTRACTED_TEXT_STMT_KEY, connection);
        try {
            setExtractedTextSql.setString(1, text);
            setExtractedTextSql.setString(2, key.toString());
            this.executeUpdate(setExtractedTextSql);
        }
        finally {
            Database.tryToClose(setExtractedTextSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<BinaryKey> getBinaryKeys(Connection connection) throws SQLException {
        PreparedStatement getBinaryKeysSql = this.prepareStatement(GET_BINARY_KEYS_STMT_KEY, connection);
        LinkedHashSet<BinaryKey> keys = new LinkedHashSet<BinaryKey>();
        try {
            ResultSet rs = this.executeQuery(getBinaryKeysSql);
            while (rs.next()) {
                keys.add(new BinaryKey(rs.getString(1)));
            }
            LinkedHashSet<BinaryKey> linkedHashSet = keys;
            return linkedHashSet;
        }
        finally {
            Database.tryToClose(getBinaryKeysSql);
        }
    }

    private void execute(PreparedStatement sql) throws SQLException {
        LOGGER.trace("Executing statement: {0}", new Object[]{sql});
        sql.execute();
    }

    private ResultSet executeQuery(PreparedStatement sql) throws SQLException {
        LOGGER.trace("Executing query statement: {0}", new Object[]{sql});
        return sql.executeQuery();
    }

    private void executeUpdate(PreparedStatement sql) throws SQLException {
        LOGGER.trace("Executing update statement: {0}", new Object[]{sql});
        sql.executeUpdate();
    }

    protected static void tryToClose(PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Throwable t) {
                LOGGER.debug(t, "Cannot close prepared statement", new Object[0]);
            }
        }
    }

    protected static void tryToClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Throwable t) {
                LOGGER.debug(t, "Cannot close result set", new Object[0]);
            }
        }
    }

    protected static void tryToClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Throwable t) {
                LOGGER.debug(t, "Cannot close prepared statement", new Object[0]);
            }
        }
    }

    protected class DatabaseBinaryStream
    extends InputStream {
        private final Connection connection;
        private final PreparedStatement statement;
        private final InputStream jdbcBinaryStream;

        protected DatabaseBinaryStream(Connection connection, PreparedStatement statement, InputStream jdbcBinaryStream) {
            this.connection = connection;
            this.statement = statement;
            this.jdbcBinaryStream = jdbcBinaryStream;
        }

        @Override
        public int read() throws IOException {
            return this.jdbcBinaryStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.jdbcBinaryStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.jdbcBinaryStream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.jdbcBinaryStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.jdbcBinaryStream.available();
        }

        @Override
        public void close() {
            Database.tryToClose(this.statement);
            Database.tryToClose(this.connection);
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.jdbcBinaryStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.jdbcBinaryStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.jdbcBinaryStream.markSupported();
        }
    }
}

