/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.RepositoryEnvironment;
import org.modeshape.jcr.TimeoutException;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.locking.LockingService;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;
import org.modeshape.schematic.SchematicDb;
import org.modeshape.schematic.SchematicEntry;
import org.modeshape.schematic.annotation.RequiresTransaction;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableDocument;

public class LocalDocumentStore
implements DocumentStore {
    private final SchematicDb database;
    private final RepositoryEnvironment repoEnv;
    private String localSourceKey;

    public LocalDocumentStore(SchematicDb database, RepositoryEnvironment repoEnv) {
        CheckArg.isNotNull((Object)database, (String)"database");
        this.database = database;
        CheckArg.isNotNull((Object)repoEnv, (String)"repoEnv");
        this.repoEnv = repoEnv;
    }

    @Override
    public boolean containsKey(String key) {
        return this.database.containsKey(key);
    }

    public List<String> keys() {
        return this.database.keys();
    }

    @Override
    public List<SchematicEntry> load(Collection<String> keys) {
        return this.database.load(keys);
    }

    @Override
    public SchematicEntry get(String key) {
        return this.database.getEntry(key);
    }

    @Override
    public SchematicEntry storeIfAbsent(String key, Document document) {
        return this.database.putIfAbsent(key, document);
    }

    @Override
    public void updateDocument(String key, Document document, SessionNode sessionNode) {
    }

    @Override
    public String newDocumentKey(String parentKey, Name documentName, Name documentPrimaryType) {
        return null;
    }

    @RequiresTransaction
    public void put(String key, Document document) {
        this.database.put(key, document);
    }

    @RequiresTransaction
    public void put(Document entryDocument) {
        this.database.putEntry(entryDocument);
    }

    @Override
    public boolean remove(String key) {
        return this.database.remove(key);
    }

    @RequiresTransaction
    public void removeAll() {
        this.database.removeAll();
    }

    @Override
    public boolean lockDocuments(Collection<String> keys) {
        return this.lockDocuments(keys.toArray(new String[keys.size()]));
    }

    @Override
    public boolean lockDocuments(String ... keys) {
        Transactions.Transaction tx = this.repoEnv.getTransactions().currentTransaction();
        if (tx == null) {
            throw new IllegalStateException("Cannot attempt to lock documents without an existing ModeShape transaction");
        }
        try {
            LockingService lockingService = this.repoEnv.lockingService();
            boolean locked = lockingService.tryLock(keys);
            if (locked) {
                tx.uponCompletion(() -> lockingService.unlock(keys));
            }
            return locked;
        }
        catch (RuntimeException rt) {
            throw rt;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EditableDocument edit(String key, boolean createIfMissing) {
        return this.database.editContent(key, createIfMissing);
    }

    @Override
    public LocalDocumentStore localStore() {
        return this;
    }

    @Override
    public void setLocalSourceKey(String sourceKey) {
        this.localSourceKey = sourceKey;
    }

    @Override
    public String getLocalSourceKey() {
        return this.localSourceKey;
    }

    @Override
    public String createExternalProjection(String projectedNodeKey, String sourceName, String externalPath, String alias) {
        throw new UnsupportedOperationException("External projections are not supported in the local document store");
    }

    @Override
    public Document getChildrenBlock(String key) {
        SchematicEntry entry = this.get(key);
        if (entry == null) {
            return null;
        }
        return entry.content();
    }

    @Override
    public Document getChildReference(String parentKey, String childKey) {
        return null;
    }

    @Override
    public ExternalBinaryValue getExternalBinary(String sourceName, String id) {
        throw new UnsupportedOperationException("External binaries are only supported by the federated document store");
    }

    public String databaseId() {
        return this.database.id();
    }

    public DocumentOperationResults performOnEachDocument(BiFunction<String, EditableDocument, Boolean> operation) {
        DocumentOperationResults results = new DocumentOperationResults();
        this.database.keys().forEach(key -> this.runInTransaction(() -> {
            try {
                EditableDocument doc = this.edit((String)key, false);
                if (doc != null) {
                    if (((Boolean)operation.apply((String)key, doc)).booleanValue()) {
                        results.recordModified();
                    } else {
                        results.recordUnmodified();
                    }
                }
            }
            catch (Throwable t) {
                results.recordFailure();
            }
            return null;
        }, 1, (String)key));
        return results;
    }

    public <V> V runInTransaction(Callable<V> operation, int retryCountOnLockTimeout, String ... keysToLock) {
        Transactions txns = this.repoEnv.getTransactions();
        int retryCount = retryCountOnLockTimeout;
        try {
            Transactions.Transaction txn = txns.begin();
            if (keysToLock.length > 0) {
                List<String> keysList = Arrays.asList(keysToLock);
                boolean locksAcquired = false;
                while (!locksAcquired && retryCountOnLockTimeout-- >= 0) {
                    locksAcquired = this.lockDocuments(keysList);
                }
                if (!locksAcquired) {
                    txn.rollback();
                    throw new TimeoutException("Cannot acquire locks on: " + Arrays.toString(keysToLock) + " after " + retryCount + " attempts");
                }
            }
            try {
                V result = operation.call();
                txn.commit();
                return result;
            }
            catch (Exception e) {
                txn.rollback();
                throw e;
            }
        }
        catch (IllegalStateException | NotSupportedException | SystemException err) {
            throw new SystemFailureException(err);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <V> V runInLocalTransaction(Callable<V> operation, int retryCountOnLockTimeout, String ... keysToLock) {
        Transactions txns = this.repoEnv.getTransactions();
        try {
            Transaction activeTransaction = txns.suspend();
            V result = this.runInTransaction(operation, retryCountOnLockTimeout, keysToLock);
            if (activeTransaction != null) {
                txns.resume(activeTransaction);
            }
            return result;
        }
        catch (SystemException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }

    public static class DocumentOperationResults
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long modifiedCount;
        private long unmodifiedCount;
        private long skipCount;
        private long failureCount;

        public long getModifiedCount() {
            return this.modifiedCount;
        }

        public long getUnmodifiedCount() {
            return this.unmodifiedCount;
        }

        public long getFailureCount() {
            return this.failureCount;
        }

        public long getSkipCount() {
            return this.skipCount;
        }

        protected void recordModified() {
            ++this.modifiedCount;
        }

        protected void recordUnmodified() {
            ++this.unmodifiedCount;
        }

        protected void recordFailure() {
            ++this.failureCount;
        }

        protected void recordSkipped() {
            ++this.skipCount;
        }

        protected DocumentOperationResults combine(DocumentOperationResults other) {
            if (other != null) {
                this.modifiedCount += other.modifiedCount;
                this.unmodifiedCount += other.unmodifiedCount;
                this.skipCount += other.skipCount;
                this.failureCount += other.failureCount;
            }
            return this;
        }

        public String toString() {
            return "" + this.modifiedCount + " documents changed, " + this.unmodifiedCount + " unchanged, " + this.skipCount + " skipped, and " + this.failureCount + " resulted in errors or failures";
        }
    }
}

