/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.mimetype;

import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.mimetype.DefaultMimeTypeDetector;
import org.modeshape.jcr.mimetype.MimeTypeDetector;
import org.modeshape.jcr.mimetype.NullMimeTypeDetector;
import org.modeshape.jcr.mimetype.tika.TikaContentDetector;
import org.modeshape.jcr.mimetype.tika.TikaNameOnlyDetector;

public final class MimeTypeDetectors {
    private static final Logger LOGGER = Logger.getLogger(MimeTypeDetector.class);
    private static final boolean TIKA_AVAILABLE;

    private MimeTypeDetectors() {
    }

    public static MimeTypeDetector createDetectorFor(String mimeTypeDetectionConfig, Environment environment) {
        switch (mimeTypeDetectionConfig.toLowerCase()) {
            case "content": {
                return TIKA_AVAILABLE ? new TikaContentDetector(environment) : new DefaultMimeTypeDetector();
            }
            case "name": {
                return TIKA_AVAILABLE ? new TikaNameOnlyDetector(environment) : new DefaultMimeTypeDetector();
            }
            case "none": {
                return NullMimeTypeDetector.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unknown mime-type detector setting: " + mimeTypeDetectionConfig);
    }

    static {
        boolean tikaAvailable = true;
        ClassLoader classLoader = MimeTypeDetector.class.getClassLoader();
        try {
            Class.forName("org.apache.tika.detect.DefaultDetector", true, classLoader);
            Class.forName("org.apache.tika.metadata.Metadata", true, classLoader);
        }
        catch (Throwable t) {
            tikaAvailable = false;
        }
        TIKA_AVAILABLE = tikaAvailable;
        if (LOGGER.isDebugEnabled()) {
            if (TIKA_AVAILABLE) {
                LOGGER.debug("Tika is available in the CP; will be used for mimetype detection", new Object[0]);
            } else {
                LOGGER.debug("Tika is not available in the CP; ModeShape will use a DefaultMimetypeDetector", new Object[0]);
            }
        }
    }
}

