/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.mapdb.Serializer;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.schematic.internal.HashCode;

public class Tuples {
    private Tuples() {
    }

    public static <T1, T2> Tuple2<T1, T2> tuple(T1 v1, T2 v2) {
        return new Tuple2<T1, T2>(v1, v2);
    }

    public static <T1, T2, T3> Tuple3<T1, T2, T3> tuple(T1 v1, T2 v2, T3 v3) {
        return new Tuple3<T1, T2, T3>(v1, v2, v3);
    }

    public static <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> tuple(T1 v1, T2 v2, T3 v3, T4 v4) {
        return new Tuple4<T1, T2, T3, T4>(v1, v2, v3, v4);
    }

    public static TupleN tuple(Object[] values) {
        return new TupleN(values);
    }

    public static <T1, T2> TypeSystem.TypeFactory<Tuple2<T1, T2>> typeFactory(TypeSystem.TypeFactory<T1> type1, TypeSystem.TypeFactory<T2> type2) {
        return new Tuple2TypeFactory<T1, T2>(type1, type2);
    }

    public static <T1, T2, T3> TypeSystem.TypeFactory<Tuple3<T1, T2, T3>> typeFactory(TypeSystem.TypeFactory<T1> type1, TypeSystem.TypeFactory<T2> type2, TypeSystem.TypeFactory<T3> type3) {
        return new Tuple3TypeFactory<T1, T2, T3>(type1, type2, type3);
    }

    public static <T1, T2, T3, T4> TypeSystem.TypeFactory<Tuple4<T1, T2, T3, T4>> typeFactory(TypeSystem.TypeFactory<T1> type1, TypeSystem.TypeFactory<T2> type2, TypeSystem.TypeFactory<T3> type3, TypeSystem.TypeFactory<T4> type4) {
        return new Tuple4TypeFactory<T1, T2, T3, T4>(type1, type2, type3, type4);
    }

    public static TypeSystem.TypeFactory<?> typeFactory(Collection<TypeSystem.TypeFactory<?>> types) {
        return new TupleNTypeFactory(types);
    }

    public static TypeSystem.TypeFactory<?> typeFactory(TypeSystem.TypeFactory<?> type, int tupleSize) {
        if (tupleSize <= 1) {
            return type;
        }
        if (tupleSize == 2) {
            return Tuples.typeFactory(type, type);
        }
        if (tupleSize == 3) {
            return Tuples.typeFactory(type, type, type);
        }
        if (tupleSize == 4) {
            return Tuples.typeFactory(type, type, type, type);
        }
        ArrayList types = new ArrayList(tupleSize);
        for (int i = 0; i != tupleSize; ++i) {
            types.add(type);
        }
        return new TupleNTypeFactory(types);
    }

    public static <T1, T2> Serializer<Tuple2<T1, T2>> serializer(Serializer<T1> first, Serializer<T2> second) {
        return new Tuple2Serializer<T1, T2>(first, second);
    }

    public static <T1, T2, T3> Serializer<Tuple3<T1, T2, T3>> serializer(Serializer<T1> first, Serializer<T2> second, Serializer<T3> third) {
        return new Tuple3Serializer<T1, T2, T3>(first, second, third);
    }

    public static <T1, T2, T3, T4> Serializer<Tuple4<T1, T2, T3, T4>> serializer(Serializer<T1> first, Serializer<T2> second, Serializer<T3> third, Serializer<T4> fourth) {
        return new Tuple4Serializer<T1, T2, T3, T4>(first, second, third, fourth);
    }

    public static Serializer<TupleN> serializer(Serializer<?>[] serializers) {
        return new TupleNSerializer(serializers);
    }

    public static Serializer<?> serializer(Serializer<?> serializer, int tupleSize) {
        if (tupleSize <= 1) {
            return serializer;
        }
        if (tupleSize == 2) {
            return Tuples.serializer(serializer, serializer);
        }
        if (tupleSize == 3) {
            return Tuples.serializer(serializer, serializer, serializer);
        }
        if (tupleSize == 4) {
            return Tuples.serializer(serializer, serializer, serializer, serializer);
        }
        Object[] serializers = new Serializer[tupleSize];
        Arrays.fill(serializers, serializer);
        return new TupleNSerializer((Serializer<?>[])serializers);
    }

    protected static int compareValues(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null ? 0 : -1;
        }
        return value2 == null ? 1 : ((Comparable)value1).compareTo(value2);
    }

    protected static final class TupleNTypeFactory
    implements TypeSystem.TypeFactory<TupleN>,
    TupleFactory<TupleN> {
        protected final TypeSystem.TypeFactory<?>[] types;
        private final Comparator<TupleN> comparator;
        private final String typeName;

        protected TupleNTypeFactory(Collection<TypeSystem.TypeFactory<?>> typeFactories) {
            this.types = new TypeSystem.TypeFactory[typeFactories.size()];
            Comparator[] comparators = new Comparator[this.types.length];
            Iterator<TypeSystem.TypeFactory<?>> typeIter = typeFactories.iterator();
            for (int i = 0; i != this.types.length; ++i) {
                TypeSystem.TypeFactory<?> typeFactory = typeIter.next();
                this.types[i] = typeFactory;
                comparators[i] = typeFactory.getComparator();
            }
            this.comparator = (Comparator & Serializable)(arg0, arg1) -> {
                int diff = 0;
                for (int i = 0; i != this.types.length; ++i) {
                    diff = comparators[i].compare(arg0.values[i], arg1.values[i]);
                    if (diff == 0) continue;
                    return diff;
                }
                return diff;
            };
            StringBuilder sb = new StringBuilder("TupleN<");
            for (int i = 0; i != this.types.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(this.types[i].getTypeName());
            }
            sb.append(">");
            this.typeName = sb.toString();
        }

        @Override
        public Serializer<TupleN> getSerializer(BufferManager bufferMgr) {
            Serializer[] serializers = new Serializer[this.types.length];
            for (int i = 0; i != this.types.length; ++i) {
                serializers[i] = bufferMgr.nullSafeSerializerFor(this.types[i]);
            }
            return new TupleNSerializer(serializers);
        }

        @Override
        public Class<TupleN> getType() {
            return TupleN.class;
        }

        @Override
        public Comparator<TupleN> getComparator() {
            return this.comparator;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public TupleN create(String value) throws ValueFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public TupleN create(Object value) throws ValueFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String asString(Object value) {
            return value.toString();
        }

        @Override
        public long length(Object value) {
            if (value instanceof TupleN) {
                TupleN tuple = (TupleN)value;
                int len = 0;
                for (int i = 0; i != this.types.length; ++i) {
                    len = (int)((long)len + this.types[i].length(tuple.values[i]));
                }
                return len;
            }
            return this.asString(value).length();
        }

        @Override
        public String asReadableString(Object value) {
            return this.asString(value);
        }
    }

    protected static final class Tuple4TypeFactory<T1, T2, T3, T4>
    implements TypeSystem.TypeFactory<Tuple4<T1, T2, T3, T4>>,
    TupleFactory<Tuple4<T1, T2, T3, T4>> {
        private final TypeSystem.TypeFactory<T1> type1;
        private final TypeSystem.TypeFactory<T2> type2;
        private final TypeSystem.TypeFactory<T3> type3;
        private final TypeSystem.TypeFactory<T4> type4;
        private final Class<Tuple4<T1, T2, T3, T4>> type;
        private final Comparator<Tuple4<T1, T2, T3, T4>> comparator;
        private final String typeName;

        protected Tuple4TypeFactory(TypeSystem.TypeFactory<T1> type1, TypeSystem.TypeFactory<T2> type2, TypeSystem.TypeFactory<T3> type3, TypeSystem.TypeFactory<T4> type4) {
            this.type1 = type1;
            this.type2 = type2;
            this.type3 = type3;
            this.type4 = type4;
            Class<Tuple4> clazz = Tuple4.class;
            this.type = clazz;
            Comparator comparator1 = type1.getComparator();
            Comparator comparator2 = type2.getComparator();
            Comparator comparator3 = type3.getComparator();
            Comparator comparator4 = type4.getComparator();
            this.comparator = (Comparator & Serializable)(arg0, arg1) -> {
                int diff = comparator1.compare(arg0.v1, arg1.v1);
                if (diff != 0) {
                    return diff;
                }
                diff = comparator2.compare(arg0.v2, arg1.v2);
                if (diff != 0) {
                    return diff;
                }
                diff = comparator3.compare(arg0.v3, arg1.v3);
                if (diff != 0) {
                    return diff;
                }
                return comparator4.compare(arg0.v4, arg1.v4);
            };
            this.typeName = "Tuple4<" + type1.getTypeName() + "," + type2.getTypeName() + "," + type3.getTypeName() + "," + type4.getTypeName() + ">";
        }

        @Override
        public Serializer<Tuple4<T1, T2, T3, T4>> getSerializer(BufferManager bufferMgr) {
            Serializer<?> ser1 = bufferMgr.nullSafeSerializerFor(this.type1);
            Serializer<?> ser2 = bufferMgr.nullSafeSerializerFor(this.type2);
            Serializer<?> ser3 = bufferMgr.nullSafeSerializerFor(this.type3);
            Serializer<?> ser4 = bufferMgr.nullSafeSerializerFor(this.type4);
            return new Tuple4Serializer(ser1, ser2, ser3, ser4);
        }

        @Override
        public Class<Tuple4<T1, T2, T3, T4>> getType() {
            return this.type;
        }

        @Override
        public Comparator<Tuple4<T1, T2, T3, T4>> getComparator() {
            return this.comparator;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public Tuple4<T1, T2, T3, T4> create(String value) throws ValueFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Tuple4<T1, T2, T3, T4> create(Object value) throws ValueFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String asString(Object value) {
            return value.toString();
        }

        @Override
        public long length(Object value) {
            if (value instanceof Tuple4) {
                Tuple4 tuple = (Tuple4)value;
                return this.type1.length(tuple.v1) + this.type2.length(tuple.v2) + this.type3.length(tuple.v3) + this.type4.length(tuple.v4);
            }
            return this.asString(value).length();
        }

        @Override
        public String asReadableString(Object value) {
            return this.asString(value);
        }
    }

    protected static final class Tuple3TypeFactory<T1, T2, T3>
    implements TypeSystem.TypeFactory<Tuple3<T1, T2, T3>>,
    TupleFactory<Tuple3<T1, T2, T3>> {
        private final TypeSystem.TypeFactory<T1> type1;
        private final TypeSystem.TypeFactory<T2> type2;
        private final TypeSystem.TypeFactory<T3> type3;
        private final Class<Tuple3<T1, T2, T3>> type;
        private final Comparator<Tuple3<T1, T2, T3>> comparator;
        private final String typeName;

        protected Tuple3TypeFactory(TypeSystem.TypeFactory<T1> type1, TypeSystem.TypeFactory<T2> type2, TypeSystem.TypeFactory<T3> type3) {
            this.type1 = type1;
            this.type2 = type2;
            this.type3 = type3;
            Class<Tuple3> clazz = Tuple3.class;
            this.type = clazz;
            Comparator comparator1 = type1.getComparator();
            Comparator comparator2 = type2.getComparator();
            Comparator comparator3 = type3.getComparator();
            this.comparator = (Comparator & Serializable)(arg0, arg1) -> {
                int diff = comparator1.compare(arg0.v1, arg1.v1);
                if (diff != 0) {
                    return diff;
                }
                diff = comparator2.compare(arg0.v2, arg1.v2);
                if (diff != 0) {
                    return diff;
                }
                return comparator3.compare(arg0.v3, arg1.v3);
            };
            this.typeName = "Tuple3<" + type1.getTypeName() + "," + type2.getTypeName() + "," + type3.getTypeName() + ">";
        }

        @Override
        public Serializer<Tuple3<T1, T2, T3>> getSerializer(BufferManager bufferMgr) {
            Serializer<?> ser1 = bufferMgr.nullSafeSerializerFor(this.type1);
            Serializer<?> ser2 = bufferMgr.nullSafeSerializerFor(this.type2);
            Serializer<?> ser3 = bufferMgr.nullSafeSerializerFor(this.type3);
            return new Tuple3Serializer(ser1, ser2, ser3);
        }

        @Override
        public Class<Tuple3<T1, T2, T3>> getType() {
            return this.type;
        }

        @Override
        public Comparator<Tuple3<T1, T2, T3>> getComparator() {
            return this.comparator;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public Tuple3<T1, T2, T3> create(String value) throws ValueFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Tuple3<T1, T2, T3> create(Object value) throws ValueFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String asString(Object value) {
            return value.toString();
        }

        @Override
        public long length(Object value) {
            if (value instanceof Tuple3) {
                Tuple3 tuple = (Tuple3)value;
                return this.type1.length(tuple.v1) + this.type2.length(tuple.v2) + this.type3.length(tuple.v3);
            }
            return this.asString(value).length();
        }

        @Override
        public String asReadableString(Object value) {
            return this.asString(value);
        }
    }

    protected static final class Tuple2TypeFactory<T1, T2>
    implements TypeSystem.TypeFactory<Tuple2<T1, T2>>,
    TupleFactory<Tuple2<T1, T2>> {
        private final TypeSystem.TypeFactory<T1> type1;
        private final TypeSystem.TypeFactory<T2> type2;
        private final Class<Tuple2<T1, T2>> type;
        private final Comparator<Tuple2<T1, T2>> comparator;
        private final String typeName;

        protected Tuple2TypeFactory(TypeSystem.TypeFactory<T1> type1, TypeSystem.TypeFactory<T2> type2) {
            this.type1 = type1;
            this.type2 = type2;
            Class<Tuple2> clazz = Tuple2.class;
            this.type = clazz;
            this.comparator = new Tuple2Comparator<T1, T2>(type1.getComparator(), type2.getComparator());
            this.typeName = "Tuple2<" + type1.getTypeName() + "," + type2.getTypeName() + ">";
        }

        @Override
        public Serializer<Tuple2<T1, T2>> getSerializer(BufferManager bufferMgr) {
            Serializer<?> ser1 = bufferMgr.nullSafeSerializerFor(this.type1);
            Serializer<?> ser2 = bufferMgr.nullSafeSerializerFor(this.type2);
            return new Tuple2Serializer(ser1, ser2);
        }

        @Override
        public Class<Tuple2<T1, T2>> getType() {
            return this.type;
        }

        @Override
        public Comparator<Tuple2<T1, T2>> getComparator() {
            return this.comparator;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public Tuple2<T1, T2> create(String value) throws ValueFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Tuple2<T1, T2> create(Object value) throws ValueFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String asString(Object value) {
            return value.toString();
        }

        @Override
        public long length(Object value) {
            if (value instanceof Tuple2) {
                Tuple2 tuple = (Tuple2)value;
                return this.type1.length(tuple.v1) + this.type2.length(tuple.v2);
            }
            return this.asString(value).length();
        }

        @Override
        public String asReadableString(Object value) {
            return this.asString(value);
        }
    }

    protected static final class Tuple2Comparator<T1, T2>
    implements Comparator<Tuple2<T1, T2>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Comparator<T1> comparator1;
        private final Comparator<T2> comparator2;

        protected Tuple2Comparator(Comparator<T1> comparator1, Comparator<T2> comparator2) {
            this.comparator1 = comparator1;
            this.comparator2 = comparator2;
        }

        @Override
        public int compare(Tuple2<T1, T2> arg0, Tuple2<T1, T2> arg1) {
            int diff = this.comparator1.compare(arg0.v1, arg1.v1);
            if (diff != 0) {
                return diff;
            }
            return this.comparator2.compare(arg0.v2, arg1.v2);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Tuple2Comparator) {
                Tuple2Comparator that = (Tuple2Comparator)obj;
                return this.comparator1.equals(that.comparator1) && this.comparator2.equals(that.comparator2);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }
    }

    public static interface TupleFactory<T> {
        public Serializer<T> getSerializer(BufferManager var1);
    }

    public static final class TupleN
    implements Comparable<TupleN> {
        protected final Object[] values;
        private final int hc;

        public TupleN(Object[] values) {
            this.values = values;
            this.hc = HashCode.compute((Object[])values);
        }

        @Override
        public int compareTo(TupleN that) {
            if (that == this) {
                return 0;
            }
            int diff = this.values.length - that.values.length;
            if (diff != 0) {
                return diff;
            }
            for (int i = 0; i != this.values.length; ++i) {
                diff = Tuples.compareValues(this.values[i], that.values[i]);
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof TupleN) {
                TupleN that = (TupleN)obj;
                if (this.values.length == that.values.length) {
                    for (int i = 0; i != this.values.length; ++i) {
                        if (!ObjectUtil.isEqualWithNulls((Object)this.values[i], (Object)that.values[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return Arrays.toString(this.values);
        }
    }

    public static final class Tuple4<T1, T2, T3, T4>
    implements Comparable<Tuple4<T1, T2, T3, T4>> {
        public final T1 v1;
        public final T2 v2;
        public final T3 v3;
        public final T4 v4;
        private final int hc;

        public Tuple4(T1 v1, T2 v2, T3 v3, T4 v4) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.v4 = v4;
            this.hc = HashCode.compute((Object[])new Object[]{v1, v2, v3, v4});
        }

        @Override
        public int compareTo(Tuple4<T1, T2, T3, T4> that) {
            if (that == this) {
                return 0;
            }
            int diff = Tuples.compareValues(this.v1, that.v1);
            if (diff != 0) {
                return diff;
            }
            diff = Tuples.compareValues(this.v2, that.v2);
            if (diff != 0) {
                return diff;
            }
            diff = Tuples.compareValues(this.v3, that.v3);
            if (diff != 0) {
                return diff;
            }
            return Tuples.compareValues(this.v4, that.v4);
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Tuple4) {
                Tuple4 that = (Tuple4)obj;
                return ObjectUtil.isEqualWithNulls(this.v1, that.v1) && ObjectUtil.isEqualWithNulls(this.v2, that.v2) && ObjectUtil.isEqualWithNulls(this.v3, that.v3) && ObjectUtil.isEqualWithNulls(this.v4, that.v4);
            }
            return false;
        }

        public String toString() {
            return "<" + this.v1 + "," + this.v2 + "," + this.v3 + "," + this.v4 + ">";
        }
    }

    public static final class Tuple3<T1, T2, T3>
    implements Comparable<Tuple3<T1, T2, T3>> {
        public final T1 v1;
        public final T2 v2;
        public final T3 v3;
        private final int hc;

        public Tuple3(T1 v1, T2 v2, T3 v3) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.hc = HashCode.compute((Object[])new Object[]{v1, v2, v3});
        }

        @Override
        public int compareTo(Tuple3<T1, T2, T3> that) {
            if (that == this) {
                return 0;
            }
            int diff = Tuples.compareValues(this.v1, that.v1);
            if (diff != 0) {
                return diff;
            }
            diff = Tuples.compareValues(this.v2, that.v2);
            if (diff != 0) {
                return diff;
            }
            return Tuples.compareValues(this.v3, that.v3);
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Tuple3) {
                Tuple3 that = (Tuple3)obj;
                return ObjectUtil.isEqualWithNulls(this.v1, that.v1) && ObjectUtil.isEqualWithNulls(this.v2, that.v2) && ObjectUtil.isEqualWithNulls(this.v3, that.v3);
            }
            return false;
        }

        public String toString() {
            return "<" + this.v1 + "," + this.v2 + "," + this.v3 + ">";
        }
    }

    public static final class Tuple2<T1, T2>
    implements Comparable<Tuple2<T1, T2>> {
        public final T1 v1;
        public final T2 v2;
        private final int hc;

        public Tuple2(T1 v1, T2 v2) {
            this.v1 = v1;
            this.v2 = v2;
            this.hc = HashCode.compute((Object[])new Object[]{v1, v2});
        }

        @Override
        public int compareTo(Tuple2<T1, T2> that) {
            if (that == this) {
                return 0;
            }
            int diff = Tuples.compareValues(this.v1, that.v1);
            if (diff != 0) {
                return diff;
            }
            return Tuples.compareValues(this.v2, that.v2);
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Tuple2) {
                Tuple2 that = (Tuple2)obj;
                return ObjectUtil.isEqualWithNulls(this.v1, that.v1) && ObjectUtil.isEqualWithNulls(this.v2, that.v2);
            }
            return false;
        }

        public String toString() {
            return "<" + this.v1 + "," + this.v2 + ">";
        }
    }

    public static final class TupleNSerializer
    implements Serializer<TupleN>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Serializer<Object>[] serializers;
        private final int size;

        public TupleNSerializer(Serializer<?>[] serializers) {
            this.serializers = serializers;
            this.size = serializers.length;
        }

        public int fixedSize() {
            return 1;
        }

        public void serialize(DataOutput out, TupleN value) throws IOException {
            for (int i = 0; i != this.size; ++i) {
                this.serializers[i].serialize(out, value.values[i]);
            }
        }

        public TupleN deserialize(DataInput in, int available) throws IOException {
            Object[] values = new Object[this.size];
            for (int i = 0; i != this.size; ++i) {
                values[i] = this.serializers[i].deserialize(in, available);
            }
            return Tuples.tuple(values);
        }
    }

    public static final class Tuple4Serializer<T1, T2, T3, T4>
    implements Serializer<Tuple4<T1, T2, T3, T4>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Serializer<T1> serializer1;
        private final Serializer<T2> serializer2;
        private final Serializer<T3> serializer3;
        private final Serializer<T4> serializer4;

        public Tuple4Serializer(Serializer<T1> serializer1, Serializer<T2> serializer2, Serializer<T3> serializer3, Serializer<T4> serializer4) {
            this.serializer1 = serializer1;
            this.serializer2 = serializer2;
            this.serializer3 = serializer3;
            this.serializer4 = serializer4;
        }

        public int fixedSize() {
            return 1;
        }

        public void serialize(DataOutput out, Tuple4<T1, T2, T3, T4> value) throws IOException {
            this.serializer1.serialize(out, value.v1);
            this.serializer2.serialize(out, value.v2);
            this.serializer3.serialize(out, value.v3);
            this.serializer4.serialize(out, value.v4);
        }

        public Tuple4<T1, T2, T3, T4> deserialize(DataInput in, int available) throws IOException {
            Object v1 = this.serializer1.deserialize(in, available);
            Object v2 = this.serializer2.deserialize(in, available);
            Object v3 = this.serializer3.deserialize(in, available);
            Object v4 = this.serializer4.deserialize(in, available);
            return Tuples.tuple(v1, v2, v3, v4);
        }
    }

    public static final class Tuple3Serializer<T1, T2, T3>
    implements Serializer<Tuple3<T1, T2, T3>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Serializer<T1> serializer1;
        private final Serializer<T2> serializer2;
        private final Serializer<T3> serializer3;

        public Tuple3Serializer(Serializer<T1> serializer1, Serializer<T2> serializer2, Serializer<T3> serializer3) {
            this.serializer1 = serializer1;
            this.serializer2 = serializer2;
            this.serializer3 = serializer3;
        }

        public int fixedSize() {
            return 1;
        }

        public void serialize(DataOutput out, Tuple3<T1, T2, T3> value) throws IOException {
            this.serializer1.serialize(out, value.v1);
            this.serializer2.serialize(out, value.v2);
            this.serializer3.serialize(out, value.v3);
        }

        public Tuple3<T1, T2, T3> deserialize(DataInput in, int available) throws IOException {
            Object v1 = this.serializer1.deserialize(in, available);
            Object v2 = this.serializer2.deserialize(in, available);
            Object v3 = this.serializer3.deserialize(in, available);
            return Tuples.tuple(v1, v2, v3);
        }
    }

    public static final class Tuple2Serializer<T1, T2>
    implements Serializer<Tuple2<T1, T2>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Serializer<T1> serializer1;
        private final Serializer<T2> serializer2;

        public Tuple2Serializer(Serializer<T1> serializer1, Serializer<T2> serializer2) {
            this.serializer1 = serializer1;
            this.serializer2 = serializer2;
        }

        public int fixedSize() {
            return 1;
        }

        public void serialize(DataOutput out, Tuple2<T1, T2> value) throws IOException {
            this.serializer1.serialize(out, value.v1);
            this.serializer2.serialize(out, value.v2);
        }

        public Tuple2<T1, T2> deserialize(DataInput in, int available) throws IOException {
            Object v1 = this.serializer1.deserialize(in, available);
            Object v2 = this.serializer2.deserialize(in, available);
            return Tuples.tuple(v1, v2);
        }
    }
}

