/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.spi.index.provider;

import java.util.Set;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.ChangeSetAdapter;
import org.modeshape.jcr.spi.index.provider.ProvidedIndex;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;

public abstract class IndexChangeAdapter
extends ChangeSetAdapter {
    protected final String workspaceName;
    protected final ProvidedIndex<?> index;
    protected final Logger logger;

    protected IndexChangeAdapter(ExecutionContext context, String workspaceName, ChangeSetAdapter.NodeTypePredicate predicate, ProvidedIndex<?> index) {
        super(context, predicate);
        assert (index != null);
        this.index = index;
        assert (workspaceName != null);
        this.workspaceName = workspaceName;
        this.logger = Logger.getLogger(this.getClass());
    }

    @Override
    protected boolean includesWorkspace(String workspaceName) {
        return this.workspaceName.equals(workspaceName);
    }

    protected final boolean reindex(String workspaceName, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, CachedNode.Properties properties, boolean queryable) {
        if (this.predicate.matchesType(primaryType, mixinTypes)) {
            this.reindexNode(workspaceName, key, path, primaryType, mixinTypes, properties, queryable);
            return true;
        }
        return false;
    }

    protected static String nodeKey(NodeKey key) {
        return key.toString();
    }

    protected void clearDataFor(NodeKey key) {
        this.index.remove(IndexChangeAdapter.nodeKey(key));
    }

    protected <T> ProvidedIndex<T> index() {
        return this.index;
    }

    @Override
    protected void completeChanges() {
        this.index.commit();
    }

    @Override
    protected void completeWorkspaceChanges() {
        this.index.commit();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(\"" + this.index.getName() + "\")";
    }
}

