/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.iterable.S3Objects;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.modeshape.jcr.value.binary.StoredBinaryValue;
import org.modeshape.jcr.value.binary.TransientBinaryStore;

public class S3BinaryStore
extends AbstractBinaryStore {
    private AmazonS3Client s3Client = null;
    private FileSystemBinaryStore fileSystemCache;
    private String bucketName;
    protected static final String EXTRACTED_TEXT_KEY = "extracted-text";
    protected static final String UNUSED_KEY = "unused";

    public S3BinaryStore(String accessKey, String secretKey, String bucketName) throws BinaryStoreException {
        this(accessKey, secretKey, bucketName, null);
    }

    public S3BinaryStore(String accessKey, String secretKey, String bucketName, String endPoint) throws BinaryStoreException {
        this.bucketName = bucketName;
        this.s3Client = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        if (endPoint != null) {
            this.s3Client.setEndpoint(endPoint);
        }
        this.fileSystemCache = TransientBinaryStore.get();
        this.fileSystemCache.setMinimumBinarySizeInBytes(1L);
        try {
            if (!this.s3Client.doesBucketExist(bucketName)) {
                this.s3Client.createBucket(bucketName);
            }
        }
        catch (AmazonClientException e) {
            throw new BinaryStoreException(e);
        }
    }

    protected S3BinaryStore(String bucketName, AmazonS3Client s3Client) {
        this.bucketName = bucketName;
        this.s3Client = s3Client;
        this.fileSystemCache = TransientBinaryStore.get();
        this.fileSystemCache.setMinimumBinarySizeInBytes(1L);
    }

    @Override
    protected String getStoredMimeType(BinaryValue binaryValue) throws BinaryStoreException {
        try {
            String key = binaryValue.getKey().toString();
            ObjectMetadata metadata = this.s3Client.getObjectMetadata(this.bucketName, key);
            return metadata.getContentType();
        }
        catch (AmazonClientException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    protected void storeMimeType(BinaryValue binaryValue, String mimeType) throws BinaryStoreException {
        try {
            String key = binaryValue.getKey().toString();
            ObjectMetadata metadata = this.s3Client.getObjectMetadata(this.bucketName, key);
            metadata.setContentType(mimeType);
            CopyObjectRequest copyRequest = new CopyObjectRequest(this.bucketName, key, this.bucketName, key);
            copyRequest.setNewObjectMetadata(metadata);
            this.s3Client.copyObject(copyRequest);
        }
        catch (AmazonClientException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void storeExtractedText(BinaryValue binaryValue, String extractedText) throws BinaryStoreException {
        if (extractedText.length() > 2000) {
            throw new BinaryStoreException("S3 objects cannot store associated data that is larger than 2KB");
        }
        this.setS3ObjectUserProperty(binaryValue.getKey(), EXTRACTED_TEXT_KEY, extractedText);
    }

    private void setS3ObjectUserProperty(BinaryKey binaryKey, String metadataKey, String metadataValue) throws BinaryStoreException {
        try {
            String key = binaryKey.toString();
            ObjectMetadata metadata = this.s3Client.getObjectMetadata(this.bucketName, key);
            Map userMetadata = metadata.getUserMetadata();
            if (null != metadataValue && metadataValue.equals(userMetadata.get(metadataKey))) {
                return;
            }
            userMetadata.put(metadataKey, metadataValue);
            metadata.setUserMetadata(userMetadata);
            CopyObjectRequest copyRequest = new CopyObjectRequest(this.bucketName, key, this.bucketName, key);
            copyRequest.setNewObjectMetadata(metadata);
            this.s3Client.copyObject(copyRequest);
        }
        catch (AmazonClientException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public String getExtractedText(BinaryValue binaryValue) throws BinaryStoreException {
        try {
            String key = binaryValue.getKey().toString();
            ObjectMetadata metadata = this.s3Client.getObjectMetadata(this.bucketName, key);
            return (String)metadata.getUserMetadata().get(EXTRACTED_TEXT_KEY);
        }
        catch (AmazonClientException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public BinaryValue storeValue(InputStream stream, boolean markAsUnused) throws BinaryStoreException {
        BinaryValue cachedFile = this.fileSystemCache.storeValue(stream, markAsUnused);
        try {
            BinaryKey key = new BinaryKey(cachedFile.getKey().toString());
            if (!this.s3Client.doesObjectExist(this.bucketName, key.toString())) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentType(this.fileSystemCache.getMimeType(cachedFile, key.toString()));
                Map userMetadata = metadata.getUserMetadata();
                userMetadata.put(UNUSED_KEY, String.valueOf(markAsUnused));
                metadata.setUserMetadata(userMetadata);
                this.s3Client.putObject(this.bucketName, key.toString(), this.fileSystemCache.getInputStream(key), metadata);
            } else if (markAsUnused) {
                this.markAsUnused(Collections.singleton(key));
            } else {
                this.markAsUsed(Collections.singleton(key));
            }
            StoredBinaryValue storedBinaryValue = new StoredBinaryValue(this, key, cachedFile.getSize());
            return storedBinaryValue;
        }
        catch (AmazonClientException | IOException | RepositoryException e) {
            throw new BinaryStoreException(e);
        }
        finally {
            this.fileSystemCache.markAsUnused(Collections.singleton(cachedFile.getKey()));
            this.fileSystemCache.removeValuesUnusedLongerThan(1L, TimeUnit.MICROSECONDS);
        }
    }

    @Override
    public InputStream getInputStream(BinaryKey key) throws BinaryStoreException {
        try {
            S3Object s3Object = this.s3Client.getObject(this.bucketName, key.toString());
            return s3Object.getObjectContent();
        }
        catch (AmazonClientException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public void markAsUsed(Iterable<BinaryKey> keys) throws BinaryStoreException {
        for (BinaryKey key : keys) {
            this.setS3ObjectUserProperty(key, UNUSED_KEY, String.valueOf(false));
        }
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) throws BinaryStoreException {
        for (BinaryKey key : keys) {
            this.setS3ObjectUserProperty(key, UNUSED_KEY, String.valueOf(true));
        }
    }

    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit timeUnit) throws BinaryStoreException {
        Date deadline = new Date(System.currentTimeMillis() - timeUnit.toMillis(minimumAge));
        try {
            for (BinaryKey key : this.getAllBinaryKeys()) {
                Date lastMod;
                ObjectMetadata metadata = this.s3Client.getObjectMetadata(this.bucketName, key.toString());
                String unused = (String)metadata.getUserMetadata().get(UNUSED_KEY);
                if (null == unused || !unused.equals(String.valueOf(true)) || !(lastMod = metadata.getLastModified()).before(deadline)) continue;
                try {
                    this.s3Client.deleteObject(this.bucketName, key.toString());
                }
                catch (AmazonClientException e) {
                    Logger log = Logger.getLogger(this.getClass());
                    log.warn((Throwable)e, (I18nResource)JcrI18n.unableToDeleteTemporaryFile, new Object[]{e.getMessage()});
                }
            }
        }
        catch (AmazonClientException e) {
            throw new BinaryStoreException(e);
        }
    }

    @Override
    public Iterable<BinaryKey> getAllBinaryKeys() throws BinaryStoreException {
        try {
            final Iterator objectsIterator = S3Objects.inBucket((AmazonS3)this.s3Client, (String)this.bucketName).iterator();
            return () -> new Iterator<BinaryKey>(){

                @Override
                public boolean hasNext() {
                    return objectsIterator.hasNext();
                }

                @Override
                public BinaryKey next() {
                    S3ObjectSummary object = (S3ObjectSummary)objectsIterator.next();
                    return new BinaryKey(object.getKey());
                }
            };
        }
        catch (AmazonClientException e) {
            throw new BinaryStoreException(e);
        }
    }
}

