/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.modeshape.jdbc.DriverInfo;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.RepositoryDelegate;
import org.modeshape.jdbc.util.Logger;

public abstract class AbstractRepositoryDelegate
implements RepositoryDelegate {
    protected static final Logger LOGGER = Logger.getLogger("org.modeshape.jdbc.delegate");
    private Repository repository = null;
    private Set<String> repositoryNames = null;
    private ConnectionInfo connInfo = null;
    private String url;
    private Properties propertiesInfo;

    public AbstractRepositoryDelegate(String url, Properties info) {
        this.url = url;
        this.propertiesInfo = info;
    }

    abstract ConnectionInfo createConnectionInfo(String var1, Properties var2);

    abstract void createRepository() throws SQLException;

    @Override
    public synchronized ConnectionInfo getConnectionInfo() {
        if (this.connInfo == null) {
            this.connInfo = this.createConnectionInfo(this.url, this.propertiesInfo);
            this.connInfo.init();
        }
        return this.connInfo;
    }

    @Override
    public void closeStatement() {
    }

    @Override
    public void commit() throws RepositoryException {
    }

    @Override
    public void close() {
    }

    @Override
    public void rollback() throws RepositoryException {
    }

    @Override
    public Connection createConnection(DriverInfo info) throws SQLException {
        LOGGER.debug("Creating connection for RepositoryDelegte", new Object[0]);
        if (this.repository == null) {
            this.createRepository();
        }
        return new JcrConnection(this, info);
    }

    public synchronized Repository getRepository() {
        return this.repository;
    }

    protected void setRepository(Repository repository) {
        this.repository = repository;
    }

    public String getRepositoryName() {
        return this.getConnectionInfo().getRepositoryName();
    }

    protected void setRepositoryName(String repositoryName) {
        this.getConnectionInfo().setRepositoryName(repositoryName);
    }

    @Override
    public Set<String> getRepositoryNames() {
        return this.repositoryNames;
    }

    protected void setRepositoryNames(Set<String> repositoryNames) {
        this.repositoryNames = repositoryNames;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException(JdbcLocalI18n.classDoesNotImplementInterface.text(RepositoryDelegate.class.getSimpleName(), iface.getName()));
        }
        return iface.cast(this);
    }
}

