/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.modeshape.jdbc.DriverInfo;
import org.modeshape.jdbc.JcrMetaData;
import org.modeshape.jdbc.JcrStatement;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.LocalJcrDriver;
import org.modeshape.jdbc.ModeShapeMetaData;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.RepositoryDelegate;

public class JcrConnection
implements Connection {
    public static final String JCR_SQL2 = "JCR-SQL2";
    public static final String JCR_SQL = "sql";
    private boolean closed;
    private boolean autoCommit = true;
    private SQLWarning warning;
    private Properties clientInfo = new Properties();
    private DatabaseMetaData metadata;
    private final RepositoryDelegate jcrDelegate;
    private final DriverInfo driverInfo;

    public JcrConnection(RepositoryDelegate jcrDelegate, DriverInfo driverInfo) {
        this.jcrDelegate = jcrDelegate;
        this.driverInfo = driverInfo;
        assert (this.jcrDelegate != null);
        assert (this.driverInfo != null);
    }

    protected ConnectionInfo info() {
        return this.jcrDelegate.getConnectionInfo();
    }

    protected DriverInfo driverInfo() {
        return this.driverInfo;
    }

    public RepositoryDelegate getRepositoryDelegate() {
        return this.jcrDelegate;
    }

    protected NodeType nodeType(String name) throws SQLException {
        try {
            return this.getRepositoryDelegate().nodeType(name);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.notClosed();
        return true;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.notClosed();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.closed) {
            return false;
        }
        if (timeout < 0) {
            throw new SQLException(JdbcLocalI18n.timeoutMayNotBeNegative.text(new Object[0]));
        }
        try {
            return this.getRepositoryDelegate().isValid(timeout);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.getRepositoryDelegate().close();
            }
            finally {
                this.metadata = null;
                this.closed = true;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected final void notClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(JdbcLocalI18n.connectionIsClosed.text(new Object[0]));
        }
    }

    @Override
    public void commit() throws SQLException {
        this.notClosed();
        try {
            this.getRepositoryDelegate().commit();
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.notClosed();
        try {
            this.getRepositoryDelegate().rollback();
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.notClosed();
        this.warning = null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.notClosed();
        return this.warning;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.notClosed();
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.notClosed();
        this.autoCommit = autoCommit;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.notClosed();
        return 2;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.notClosed();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getCatalog() {
        return this.info().getRepositoryName();
    }

    @Override
    public void setCatalog(String catalog) {
    }

    @Override
    public Properties getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String name) {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> status = new HashMap<String, ClientInfoStatus>();
        Properties validProperties = new Properties();
        for (String name : properties.stringPropertyNames()) {
            if (name == null || LocalJcrDriver.ALL_PROPERTY_NAMES.contains(name)) {
                status.put(name, ClientInfoStatus.REASON_VALUE_INVALID);
                continue;
            }
            String value = properties.getProperty(name);
            validProperties.put(name, value);
        }
        if (validProperties.isEmpty()) {
            if (!status.isEmpty()) {
                String reason = JdbcLocalI18n.invalidClientInfo.text(new Object[0]);
                throw new SQLClientInfoException(reason, status);
            }
        } else {
            this.clientInfo.putAll((Map<?, ?>)validProperties);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Properties properties = new Properties();
        properties.put(name, value);
        this.setClientInfo(properties);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.notClosed();
        if (this.metadata == null) {
            String descriptor = this.getRepositoryDelegate().getDescriptor("jcr.repository.name");
            if (descriptor != null && descriptor.toLowerCase().contains("modeshape")) {
                return new ModeShapeMetaData(this);
            }
            return new JcrMetaData(this);
        }
        return this.metadata;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return new HashMap(1);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) {
        return sql;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new JcrStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.notClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.notClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.notClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.notClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.notClosed();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this) || this.getRepositoryDelegate().isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        return this.getRepositoryDelegate().unwrap(iface);
    }
}

