/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.SQLException;
import java.util.Properties;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.LocalJcrDriver;
import org.modeshape.jdbc.delegate.LocalRepositoryDelegate;
import org.modeshape.jdbc.delegate.RepositoryDelegate;

public class RepositoryDelegateFactory {
    protected static final int PROTOCOL_UNKNOWN = -1;
    protected static final int PROTOCOL_JNDI = 1;

    protected RepositoryDelegateFactory() {
    }

    public RepositoryDelegate createRepositoryDelegate(String url, Properties info, LocalJcrDriver.JcrContextFactory contextFactory) throws SQLException {
        if (!this.acceptUrl(url)) {
            throw new SQLException(JdbcLocalI18n.invalidUrlPrefix.text(new Object[]{"jdbc:jcr:jndi:"}));
        }
        return this.create(this.determineProtocol(url), url, info, contextFactory);
    }

    public boolean acceptUrl(String url) {
        return !StringUtil.isBlank((String)url) && this.determineProtocol(url.trim()) > 0;
    }

    protected int determineProtocol(String url) {
        assert (url != null);
        assert (url.length() != 0);
        if (url.startsWith("jdbc:jcr:jndi:") && url.length() > "jdbc:jcr:jndi:".length()) {
            return 1;
        }
        return -1;
    }

    protected RepositoryDelegate create(int protocol, String url, Properties info, LocalJcrDriver.JcrContextFactory contextFactory) {
        switch (protocol) {
            case 1: {
                return new LocalRepositoryDelegate(url, info, contextFactory);
            }
        }
        throw new IllegalArgumentException("Invalid protocol: " + protocol);
    }
}

