/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.util;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.connector.store.jpa.Model;
import org.modeshape.connector.store.jpa.util.StoreOptionEntity;

public class SchemaGen {
    public static final String CREATE_FILE_NAME = "create.dna-jpa-connector.ddl";
    public static final String DROP_FILE_NAME = "drop.dna-jpa-connector.ddl";
    private final Dialect dialect;
    private final Model model;
    private final File outputPath;
    public static final String USAGE = "java -jar <jar_name> -dialect <dialect name> -model <model_name> [-out <path to output directory>]\n\tExample: java -jar modeshape-jpa-ddl-gen-1.2-jar-with-dependencies.jar -dialect HSQL -model Basic -out /tmp";

    public SchemaGen(String dialect, String model, File outputPath) {
        this.dialect = this.dialectFor(dialect);
        this.model = JpaSource.Models.getModel((String)model);
        this.outputPath = outputPath;
    }

    private Dialect dialectFor(String dialectName) {
        Properties props = new Properties();
        if (!dialectName.endsWith("Dialect")) {
            dialectName = dialectName + "Dialect";
        }
        if (!dialectName.startsWith("org.hibernate.dialect.")) {
            dialectName = "org.hibernate.dialect." + dialectName;
        }
        props.put("hibernate.dialect", dialectName);
        return Dialect.getDialect((Properties)props);
    }

    void generate() throws IOException {
        Ejb3Configuration configurator = new Ejb3Configuration();
        configurator.setProperty("hibernate.dialect", this.dialect.toString());
        this.model.configure(configurator);
        configurator.addAnnotatedClass(StoreOptionEntity.class);
        SchemaExport export = new SchemaExport((Configuration)configurator.getHibernateConfiguration());
        export.setOutputFile(new File(this.outputPath, CREATE_FILE_NAME).getCanonicalPath());
        export.create(false, false);
        export.setOutputFile(new File(this.outputPath, DROP_FILE_NAME).getCanonicalPath());
        export.drop(false, false);
    }

    public static void main(String[] args) throws IOException {
        String modelName = null;
        String dialectName = null;
        File outputFile = new File(".");
        for (int i = 0; i < args.length; ++i) {
            if ("-dialect".equals(args[i])) {
                if (i == args.length - 1) {
                    SchemaGen.printUsage();
                }
                dialectName = args[++i];
                continue;
            }
            if ("-model".equals(args[i])) {
                if (i == args.length - 1) {
                    SchemaGen.printUsage();
                }
                modelName = args[++i];
                continue;
            }
            if ("-out".equals(args[i])) {
                if (i == args.length - 1) {
                    SchemaGen.printUsage();
                }
                outputFile = new File(args[++i]);
                continue;
            }
            if (!"-help".equals(args[i]) && !"-?".equals(args[i])) continue;
            SchemaGen.printUsage();
        }
        if (modelName == null || dialectName == null) {
            SchemaGen.printUsage();
        }
        SchemaGen main = new SchemaGen(dialectName, modelName, outputFile);
        main.generate();
    }

    private static void printUsage() {
        System.err.println(USAGE);
        System.exit(1);
    }
}

