/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.util;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.connector.store.jpa.Model;
import org.modeshape.connector.store.jpa.util.StoreOptionEntity;
import org.modeshape.util.JpaDdlGenI18n;

public class SchemaGen {
    protected static Logger logger = Logger.getLogger("org.modeshape.util");
    public static final String CREATE_FILE_NAME = "create.modeshape-jpa-connector.ddl";
    public static final String DROP_FILE_NAME = "drop.modeshape-jpa-connector.ddl";
    private final Dialect dialect;
    private final Model model;
    private final File outputPath;
    private final String delimiter;
    private boolean newLineAfterStatement = false;
    public static final String USAGE = "./ddl-gen.sh -dialect <dialect name> -model <model_name> [-out <path to output directory>] [-delimiter <delim>] [-newline]\n\tExample: ./ddl-gen.sh -dialect HSQL -model Simple -out /tmp  -delimiter % -newline ";

    public SchemaGen(String dialect, String model, File outputPath) {
        this.dialect = this.dialectFor(dialect);
        this.delimiter = null;
        this.model = JpaSource.Models.getModel((String)model);
        if (this.model == null) {
            throw new RuntimeException(JpaDdlGenI18n.invalidModel.text(new Object[0]));
        }
        this.outputPath = outputPath;
        if (this.outputPath != null && !this.outputPath.exists()) {
            this.outputPath.mkdirs();
            String logMsg = JpaDdlGenI18n.directoryLocationCreated.text(new Object[]{this.outputPath.getAbsolutePath()});
            logger.log(Level.INFO, logMsg);
        }
    }

    public SchemaGen(String dialect, String model, File outputPath, String delimiter) {
        this.dialect = this.dialectFor(dialect);
        this.delimiter = delimiter;
        this.model = JpaSource.Models.getModel((String)model);
        if (this.model == null) {
            throw new RuntimeException(JpaDdlGenI18n.invalidModel.text(new Object[0]));
        }
        this.outputPath = outputPath;
        if (this.outputPath != null && !this.outputPath.exists()) {
            this.outputPath.mkdirs();
            String logMsg = JpaDdlGenI18n.directoryLocationCreated.text(new Object[]{this.outputPath.getAbsolutePath()});
            logger.log(Level.INFO, logMsg);
        }
    }

    public void setNewLineAfterStatement(boolean newLine) {
        this.newLineAfterStatement = newLine;
    }

    private Dialect dialectFor(String dialectName) {
        Properties props = new Properties();
        if (!dialectName.endsWith("Dialect")) {
            dialectName = dialectName + "Dialect";
        }
        if (!dialectName.startsWith("org.hibernate.dialect.")) {
            dialectName = "org.hibernate.dialect." + dialectName;
        }
        props.put("hibernate.dialect", dialectName);
        return Dialect.getDialect((Properties)props);
    }

    void generate() throws IOException {
        Ejb3Configuration configurator = new Ejb3Configuration();
        configurator.setProperty("hibernate.dialect", this.dialect.toString());
        this.model.configure(configurator);
        configurator.addAnnotatedClass(StoreOptionEntity.class);
        SchemaExport export = new SchemaExport((Configuration)configurator.getHibernateConfiguration());
        export.setOutputFile(new File(this.outputPath, CREATE_FILE_NAME).getCanonicalPath());
        if (this.delimiter != null) {
            export.setDelimiter(this.newLineAfterStatement ? "\r" + this.delimiter : this.delimiter);
        } else if (this.newLineAfterStatement) {
            export.setDelimiter("\r");
        }
        export.execute(false, false, false, true);
        export.setOutputFile(new File(this.outputPath, DROP_FILE_NAME).getCanonicalPath());
        export.drop(false, false);
    }

    public static void main(String[] args) throws IOException {
        String modelName = null;
        String dialectName = null;
        File outputFile = new File(".");
        String delim = null;
        boolean newline = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-dialect".equals(args[i])) {
                if (i == args.length - 1) {
                    SchemaGen.printUsage();
                }
                dialectName = args[++i];
                continue;
            }
            if ("-model".equals(args[i])) {
                if (i == args.length - 1) {
                    SchemaGen.printUsage();
                }
                modelName = args[++i];
                continue;
            }
            if ("-out".equals(args[i])) {
                if (i == args.length - 1) {
                    SchemaGen.printUsage();
                }
                outputFile = new File(args[++i]);
                continue;
            }
            if ("-delimiter".equals(args[i])) {
                if (i == args.length - 1) {
                    SchemaGen.printUsage();
                }
                delim = args[++i];
                continue;
            }
            if ("-newline".equals(args[i])) {
                newline = true;
                continue;
            }
            if (!"-help".equals(args[i]) && !"-?".equals(args[i])) continue;
            SchemaGen.printUsage();
        }
        if (modelName == null || dialectName == null) {
            SchemaGen.printUsage();
        }
        SchemaGen main = new SchemaGen(dialectName, modelName, outputFile, delim);
        main.setNewLineAfterStatement(newline);
        main.generate();
    }

    private static void printUsage() {
        System.err.println(USAGE);
        System.exit(1);
    }
}

