/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.Constraint;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.index.lucene.FieldUtil;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.LuceneIndexException;
import org.modeshape.jcr.index.lucene.Searcher;
import org.modeshape.jcr.index.lucene.query.LuceneQueryFactory;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.spi.index.provider.ProvidedIndex;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.StringFactory;

@ThreadSafe
@Immutable
public abstract class LuceneIndex
implements ProvidedIndex<Object> {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final String name;
    protected final ExecutionContext context;
    protected final IndexWriter writer;
    protected final Map<String, PropertyType> propertyTypesByName;
    protected final LuceneConfig config;
    protected final StringFactory stringFactory;
    protected final Searcher searcher;

    protected LuceneIndex(String name, String workspaceName, LuceneConfig config, Map<String, PropertyType> propertyTypesByName, ExecutionContext context) {
        assert (!propertyTypesByName.isEmpty());
        this.propertyTypesByName = propertyTypesByName;
        this.name = name;
        this.context = context;
        this.stringFactory = context.getValueFactories().getStringFactory();
        this.config = config;
        this.writer = config.newWriter(workspaceName, name);
        this.searcher = new Searcher(config, this.writer, name);
    }

    public void add(String nodeKey, String propertyName, Object value) {
        this.add(nodeKey, propertyName, new Object[]{value});
    }

    public void remove(String nodeKey) {
        CheckArg.isNotNull((Object)nodeKey, (String)"nodeKey");
        try {
            this.writer.deleteDocuments(new Term[]{FieldUtil.idTerm(nodeKey)});
        }
        catch (IOException e) {
            throw new LuceneIndexException(e);
        }
    }

    public void remove(String nodeKey, String propertyName, Object value) {
        this.remove(nodeKey, propertyName);
    }

    public void remove(String nodeKey, String propertyName, Object[] values) {
        this.remove(nodeKey, propertyName);
    }

    public String getName() {
        return this.name;
    }

    public long estimateCardinality(List<Constraint> andedConstraints, Map<String, Object> variables) {
        try {
            return this.searcher.estimateCardinality(andedConstraints, this.queryFactory(variables));
        }
        catch (IOException e) {
            throw new LuceneIndexException(e);
        }
    }

    public long estimateTotalCount() {
        return this.writer.numDocs();
    }

    public Filter.Results filter(IndexConstraints constraints) {
        return this.searcher.filter(constraints, this.queryFactory(constraints.getVariables()));
    }

    public boolean requiresReindexing() {
        try {
            return !DirectoryReader.indexExists((Directory)this.writer.getDirectory());
        }
        catch (IOException e) {
            this.logger.debug((Throwable)e, "cannot determine if lucene index exists...", new Object[0]);
            return false;
        }
    }

    public void commit() {
        if (!this.writer.hasUncommittedChanges()) {
            return;
        }
        try {
            Map oldData = this.writer.getCommitData();
            HashMap<String, String> newData = new HashMap<String, String>(oldData);
            this.preCommit(newData);
            this.writer.setCommitData(newData);
            this.writer.commit();
            this.postCommit();
        }
        catch (IOException e) {
            throw new LuceneIndexException("Cannot commit index writer", e);
        }
    }

    protected void postCommit() {
    }

    protected void preCommit(Map<String, String> commitData) {
        commitData.put("last_commit_time", String.valueOf(System.currentTimeMillis()));
    }

    public void shutdown(boolean destroyed) {
        if (destroyed) {
            this.clearAllData();
        }
        try {
            this.searcher.close();
            this.writer.close();
        }
        catch (IOException e) {
            throw new LuceneIndexException("Cannot shutdown lucene index", e);
        }
    }

    public void clearAllData() {
        try {
            this.writer.deleteAll();
            this.writer.commit();
        }
        catch (IOException e) {
            throw new LuceneIndexException("Cannot remove all documents from the index");
        }
    }

    protected void addProperty(String nodeKey, Document document, String property, Object ... values) {
        if (values != null && values.length > 0) {
            List<Field> fields = this.valuesToFields(property, values);
            for (Field field : fields) {
                document.add((IndexableField)field);
            }
        }
        document.add((IndexableField)FieldUtil.idField(nodeKey));
    }

    protected abstract void remove(String var1, String var2);

    protected abstract LuceneQueryFactory queryFactory(Map<String, Object> var1);

    protected List<Field> valuesToFields(String propertyName, Object ... values) {
        assert (values.length > 0);
        PropertyType type = this.propertyTypesByName.get(propertyName);
        assert (type != null);
        ArrayList<Field> fields = new ArrayList<Field>();
        block9: for (Object value : values) {
            switch (type) {
                case NAME: 
                case PATH: 
                case REFERENCE: 
                case SIMPLEREFERENCE: 
                case WEAKREFERENCE: 
                case URI: 
                case STRING: {
                    this.addStringField(propertyName, (String)this.stringFactory.create(value), fields);
                    continue block9;
                }
                case BOOLEAN: {
                    this.addBooleanField(propertyName, (Boolean)value, fields);
                    continue block9;
                }
                case BINARY: {
                    this.addBinaryField(propertyName, value, fields);
                    continue block9;
                }
                case DATE: {
                    this.addDateField(propertyName, (DateTime)value, fields);
                    continue block9;
                }
                case DECIMAL: {
                    this.addDecimalField(propertyName, (BigDecimal)value, fields);
                    continue block9;
                }
                case DOUBLE: {
                    this.addDoubleField(propertyName, (Double)value, fields);
                    continue block9;
                }
                case LONG: {
                    this.addLongField(propertyName, (Long)value, fields);
                    continue block9;
                }
                default: {
                    throw new LuceneIndexException("Unsupported property type: " + type);
                }
            }
        }
        return fields;
    }

    protected void addStringField(String propertyName, String value, List<Field> fields) {
        fields.add((Field)new StringField(propertyName, value, Field.Store.YES));
        fields.add((Field)new LongField(FieldUtil.lengthField(propertyName), (long)value.length(), Field.Store.YES));
    }

    protected void addBooleanField(String propertyName, Boolean value, List<Field> fields) {
        String valueString = (String)this.stringFactory.create((Object)value);
        int intValue = value != false ? 1 : 0;
        fields.add((Field)new IntField(propertyName, intValue, Field.Store.YES));
        fields.add((Field)new LongField(FieldUtil.lengthField(propertyName), (long)valueString.length(), Field.Store.YES));
    }

    protected void addDateField(String propertyName, DateTime value, List<Field> fields) {
        fields.add((Field)new LongField(propertyName, value.getMilliseconds(), Field.Store.YES));
        String valueString = (String)this.stringFactory.create(value);
        fields.add((Field)new LongField(FieldUtil.lengthField(propertyName), (long)valueString.length(), Field.Store.YES));
    }

    protected void addBinaryField(String propertyName, Object value, List<Field> fields) {
        try {
            Binary binary = (Binary)value;
            fields.add((Field)new LongField(FieldUtil.lengthField(propertyName), binary.getSize(), Field.Store.YES));
        }
        catch (RepositoryException e) {
            throw new LuceneIndexException(e);
        }
    }

    protected void addDecimalField(String propertyName, BigDecimal value, List<Field> fields) {
        String stringValue = FieldUtil.decimalToString(value);
        fields.add((Field)new StringField(propertyName, stringValue, Field.Store.YES));
        fields.add((Field)new LongField(FieldUtil.lengthField(propertyName), (long)((String)this.stringFactory.create(value)).length(), Field.Store.YES));
    }

    protected void addDoubleField(String propertyName, Double value, List<Field> fields) {
        fields.add((Field)new DoubleField(propertyName, value.doubleValue(), Field.Store.YES));
        String valueString = (String)this.stringFactory.create((Object)value);
        fields.add((Field)new LongField(FieldUtil.lengthField(propertyName), (long)valueString.length(), Field.Store.YES));
    }

    protected void addLongField(String propertyName, Long value, List<Field> fields) {
        fields.add((Field)new LongField(propertyName, value.longValue(), Field.Store.YES));
        String valueString = (String)this.stringFactory.create((Object)value);
        fields.add((Field)new LongField(FieldUtil.lengthField(propertyName), (long)valueString.length(), Field.Store.YES));
    }
}

