/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.index.lucene.FieldUtil;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.LuceneIndex;
import org.modeshape.jcr.index.lucene.LuceneIndexException;
import org.modeshape.jcr.index.lucene.query.LuceneQueryFactory;
import org.modeshape.jcr.value.PropertyType;

@ThreadSafe
@Immutable
class MultiColumnIndex
extends LuceneIndex {
    private final DocumentIdCache cache = new DocumentIdCache();

    protected MultiColumnIndex(String name, String workspaceName, LuceneConfig config, Map<String, PropertyType> propertyTypesByName, ExecutionContext context) {
        super(name, workspaceName, config, propertyTypesByName, context);
    }

    public void add(String nodeKey, String propertyName, Object[] values) {
        CheckArg.isNotNull((Object)nodeKey, (String)"nodeKey");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        CheckArg.isNotNull((Object)values, (String)"values");
        try {
            if (this.documentExists(nodeKey)) {
                this.logger.debug("Updating the property '{0}' of document '{1}' in the Lucene index '{2}' with the values '{3}'", new Object[]{propertyName, nodeKey, this.name, values});
                Document oldDocument = this.searcher.loadDocumentById(nodeKey);
                Document newDocument = this.clone(oldDocument, propertyName);
                List<Field> fields = this.valuesToFields(propertyName, values);
                fields.stream().forEach(arg_0 -> ((Document)newDocument).add(arg_0));
                this.writer.updateDocument(FieldUtil.idTerm(nodeKey), (Iterable)newDocument);
            } else {
                this.logger.debug("Adding the document '{0}' in the Lucene Index '{1}' with the property '{2}' and values '{3}", new Object[]{nodeKey, this.name, propertyName, values});
                Document document = new Document();
                this.addProperty(nodeKey, document, propertyName, values);
                this.writer.addDocument((Iterable)document);
                this.cache.add(nodeKey);
            }
        }
        catch (IOException e) {
            throw new LuceneIndexException(e);
        }
    }

    private Document clone(Document oldDocument, String ... excludeProps) {
        List<String> excluded = Arrays.asList(excludeProps);
        Document newDocument = new Document();
        oldDocument.getFields().stream().filter((? super T field) -> !excluded.contains(field.name())).map(field -> this.clone((Field)field)).forEach(arg_0 -> ((Document)newDocument).add(arg_0));
        return newDocument;
    }

    private Field clone(Field existing) {
        String name = existing.name();
        if (name.startsWith(":len:")) {
            return new LongField(name, Long.valueOf(existing.stringValue()).longValue(), Field.Store.YES);
        }
        Number numberValue = existing.numericValue();
        if (numberValue instanceof Integer) {
            return new IntField(name, numberValue.intValue(), Field.Store.YES);
        }
        if (numberValue instanceof Long) {
            return new LongField(name, numberValue.longValue(), Field.Store.YES);
        }
        if (numberValue instanceof Double) {
            return new DoubleField(name, numberValue.doubleValue(), Field.Store.YES);
        }
        String stringValue = existing.stringValue();
        if (stringValue != null) {
            return new StringField(name, stringValue, Field.Store.YES);
        }
        BytesRef bytesRef = existing.binaryValue();
        if (bytesRef != null) {
            return new StringField(name, bytesRef, Field.Store.YES);
        }
        throw new LuceneIndexException("Cannot clone existing field: " + existing);
    }

    @Override
    protected void preCommit(Map<String, String> commitData) {
        super.preCommit(commitData);
        this.cache.updateCommmitData(commitData);
    }

    @Override
    protected void remove(String nodeKey, String propertyName) {
        CheckArg.isNotNull((Object)nodeKey, (String)"nodeKey");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        if (!this.documentExists(nodeKey)) {
            return;
        }
        try {
            boolean hasProperty;
            Document document = this.searcher.loadDocumentById(nodeKey);
            boolean bl = hasProperty = document.getField(propertyName) != null;
            if (!hasProperty) {
                return;
            }
            Term idTerm = FieldUtil.idTerm(nodeKey);
            if (document.getFields().size() == 1) {
                this.writer.deleteDocuments(new Term[]{idTerm});
                this.cache.remove(nodeKey);
            } else {
                Document newDocument = this.clone(document, propertyName);
                this.writer.updateDocument(idTerm, (Iterable)newDocument);
            }
        }
        catch (IOException e) {
            throw new LuceneIndexException(e);
        }
    }

    @Override
    protected LuceneQueryFactory queryFactory(Map<String, Object> variables) {
        return LuceneQueryFactory.forMultiColumnIndex(this.context.getValueFactories(), variables, this.propertyTypesByName);
    }

    @Override
    public void remove(String nodeKey) {
        super.remove(nodeKey);
        if (this.documentExists(nodeKey)) {
            this.cache.remove(nodeKey);
        }
    }

    private boolean documentExists(String nodeKey) {
        return this.cache.hasNode(nodeKey) || this.writer.getCommitData().containsKey(nodeKey);
    }

    private class DocumentIdCache {
        private final Set<String> removed = new HashSet<String>();
        private final Set<String> added = new HashSet<String>();

        private DocumentIdCache() {
        }

        protected synchronized boolean hasNode(String nodeKey) {
            return this.added.contains(nodeKey) || this.removed.contains(nodeKey);
        }

        protected synchronized void add(String nodeKey) {
            this.removed.remove(nodeKey);
            this.added.add(nodeKey);
        }

        protected synchronized void remove(String nodeKey) {
            this.added.remove(nodeKey);
            this.removed.add(nodeKey);
        }

        protected synchronized void clear() {
            this.added.clear();
            this.removed.clear();
        }

        protected synchronized void updateCommmitData(Map<String, String> commitData) {
            if (!this.removed.isEmpty()) {
                for (String key : this.removed) {
                    commitData.remove(key);
                }
            }
            if (!this.added.isEmpty()) {
                for (String key : this.added) {
                    commitData.put(key, "");
                }
            }
        }
    }
}

