/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.SingleColumnIndex;
import org.modeshape.jcr.index.lucene.query.LuceneQueryFactory;
import org.modeshape.jcr.value.PropertyType;

@Immutable
@ThreadSafe
class TextIndex
extends SingleColumnIndex {
    protected TextIndex(String name, String workspaceName, LuceneConfig config, Map<String, PropertyType> propertyTypesByName, ExecutionContext context) {
        super(name, workspaceName, config, propertyTypesByName, context);
    }

    @Override
    protected LuceneQueryFactory queryFactory(Map<String, Object> variables) {
        return LuceneQueryFactory.forTextIndex(this.context.getValueFactories(), variables, this.propertyTypesByName, this.config);
    }

    @Override
    protected void addStringField(String propertyName, String value, List<Field> fields) {
        fields.add((Field)new TextField(propertyName, value, Field.Store.NO));
    }

    @Override
    protected void addBooleanField(String propertyName, Boolean value, List<Field> fields) {
    }

    @Override
    protected void addDateField(String propertyName, DateTime value, List<Field> fields) {
    }

    @Override
    protected void addBinaryField(String propertyName, Object value, List<Field> fields) {
        String valueString = value instanceof String ? (String)value : (String)this.stringFactory.create(value);
        fields.add((Field)new TextField(propertyName, valueString, Field.Store.NO));
    }

    @Override
    protected void addDecimalField(String propertyName, BigDecimal value, List<Field> fields) {
    }

    @Override
    protected void addDoubleField(String propertyName, Double value, List<Field> fields) {
    }

    @Override
    protected void addLongField(String propertyName, Long value, List<Field> fields) {
    }
}

