/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.text.StringCharacterIterator;
import java.util.regex.Pattern;
import org.apache.lucene.search.Query;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.index.lucene.query.ConstantScoreWeightQuery;

@Immutable
public class RelikeQuery
extends ConstantScoreWeightQuery {
    private final String relikeValue;

    protected RelikeQuery(String field, String relikeValue) {
        super(field);
        this.relikeValue = relikeValue;
    }

    @Override
    protected boolean accepts(String value) {
        return value != null && RelikeQuery.like(this.relikeValue, value);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        return sb.append(field).append(" RELIKE ").append(this.relikeValue).toString();
    }

    public Query clone() {
        return new RelikeQuery(this.field(), this.relikeValue);
    }

    private static boolean like(String value, String pattern) {
        CompareType cmpType = RelikeQuery.getCompareType(pattern);
        switch (cmpType) {
            case EQ: {
                return value.equals(pattern);
            }
            case ENDS_WITH: {
                return value.endsWith(pattern.substring(1));
            }
            case STARTS_WITH: {
                return value.startsWith(pattern.substring(0, pattern.length() - 1));
            }
        }
        Pattern p = Pattern.compile(RelikeQuery.toRegularExpression(pattern));
        return p.matcher(value).matches();
    }

    private static CompareType getCompareType(String expression) {
        CompareType result = CompareType.EQ;
        StringCharacterIterator iter = new StringCharacterIterator(expression);
        boolean fistIndex = false;
        int lastIndex = expression.length() - 1;
        boolean skipNext = false;
        char c = iter.first();
        while (c != '\uffff') {
            if (skipNext) {
                skipNext = false;
            } else {
                if (c == '_') {
                    return CompareType.REGEXP;
                }
                if (c == '%') {
                    if (result != CompareType.EQ) {
                        return CompareType.REGEXP;
                    }
                    int index = iter.getIndex();
                    if (index == 0) {
                        result = CompareType.ENDS_WITH;
                    } else if (index == lastIndex) {
                        result = CompareType.STARTS_WITH;
                    } else {
                        return CompareType.REGEXP;
                    }
                }
                if (c == '\\') {
                    skipNext = true;
                }
            }
            c = iter.next();
        }
        return result;
    }

    private static String toRegularExpression(String likeExpression) {
        String result = likeExpression.replaceAll("\\\\(.)", "$1");
        result = result.replaceAll("([$.|+()\\*\\?\\[\\\\^\\\\\\\\])", "\\\\$1");
        result = result.replace("%", ".*").replace("_", ".");
        return result;
    }

    private static enum CompareType {
        EQ,
        STARTS_WITH,
        ENDS_WITH,
        REGEXP;

    }
}

